# バッチ設計書 7-eng/common/CIBuild.cmd

## 概要

本ドキュメントは、.NET Runtimeプロジェクトの `eng/common/CIBuild.cmd` - CIビルドスクリプト（Windows）の設計仕様を記載する。

### 本バッチの処理概要

このバッチは、Windows CI環境でのフルビルドを実行するためのエントリーポイントスクリプトである。restore、build、test、sign、pack、publishの全アクションを一括で実行し、CI/CDパイプラインでの完全なビルドサイクルを提供する。

**業務上の目的・背景**：CI/CDパイプライン（Azure DevOps、GitHub Actions等）では、一貫した方法でフルビルドを実行する必要がある。このスクリプトは、すべてのビルドステップを単一のコマンドで実行できるようにし、CIエージェントでの自動化を容易にする。

**バッチの実行タイミング**：CI/CDパイプラインから自動的に呼び出される。プルリクエストのビルド、マージビルド、ナイトリービルド等で使用される。

**主要な処理内容**：
1. PowerShell経由でBuild.ps1を呼び出す
2. -restore フラグで依存関係を復元
3. -build フラグでプロジェクトをビルド
4. -test フラグでテストを実行
5. -sign フラグで成果物に署名
6. -pack フラグでNuGetパッケージを作成
7. -publish フラグで成果物を公開
8. -ci フラグでCI固有の設定を有効化

**前後の処理との関連**：このスクリプトは `eng/common/Build.ps1` を呼び出す。CI/CDパイプラインの定義ファイル（azure-pipelines.yml等）から参照される。

**影響範囲**：プロジェクト全体のビルド、テスト、パッケージング、公開に影響する。CI環境でのアーティファクト生成とリリースプロセスの起点となる。

## バッチ種別

CIビルド / フルビルド実行

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | CI/CDトリガーに依存 |
| 実行時刻 | 自動（トリガー時） |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | CI/CDパイプライン（PR、マージ、スケジュール等） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Windows OS | Windows CI エージェントでの実行 |
| PowerShell | PowerShellが利用可能であること |
| CI環境 | CI/CDシステム上での実行が想定される |
| eng/common/Build.ps1 | 委譲先スクリプトが存在すること |

### 実行可否判定

スクリプトは常に実行可能。CI環境以外でも実行できるが、フルビルドが実行されるため時間がかかる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| %* | string | No | なし | 追加のコマンドライン引数（Build.ps1に渡される） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| %~dp0 | バッチ変数 | スクリプトのディレクトリパス |
| CI環境変数 | 環境変数 | CI/CDシステムが設定する各種変数 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | ビルドの進捗とログ |
| artifacts/ | ディレクトリ | ビルド成果物 |
| artifacts/packages | NuGet | パッケージファイル |
| artifacts/log | ログ | ビルドログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 構成に依存 |
| 出力先 | artifacts/ ディレクトリ配下 |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. エコー出力の抑制
   └─ @echo off
2. PowerShell の実行
   └─ ExecutionPolicy ByPass でBuild.ps1を呼び出し
3. 以下のフラグを付与
   └─ -restore: 依存関係復元
   └─ -build: ビルド実行
   └─ -test: テスト実行
   └─ -sign: 署名
   └─ -pack: パッケージ作成
   └─ -publish: 公開
   └─ -ci: CI モード
4. 追加引数の受け渡し
   └─ %* で追加引数を委譲
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[echo off]
    B --> C[PowerShell起動]
    C --> D[Build.ps1呼び出し]
    D --> E[-restore: 依存関係復元]
    E --> F[-build: ビルド実行]
    F --> G[-test: テスト実行]
    G --> H[-sign: 署名]
    H --> I[-pack: パッケージ作成]
    I --> J[-publish: 公開]
    J --> K[-ci: CIモード有効]
    K --> L[追加引数処理]
    L --> M[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（データベース操作は行わない）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | ビルドエラー | ビルド、テスト、署名等のいずれかが失敗 | ログを確認して問題を修正 |
| 1 | PowerShellエラー | PowerShellの起動に失敗 | エージェントの環境を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | CI/CDシステムの設定に依存 |
| リトライ間隔 | CI/CDシステムの設定に依存 |
| リトライ対象エラー | CI/CDシステムの設定に依存 |

### 障害時対応

1. CI/CDパイプラインのログを確認
2. 失敗したステップ（restore、build、test等）を特定
3. バイナリログを確認して詳細なエラー情報を取得

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のフルビルド |
| 目標処理時間 | プロジェクトサイズに依存（通常数十分〜数時間） |
| メモリ使用量上限 | CIエージェントのスペックに依存 |

## 排他制御

CI/CDシステムのジョブスケジューリングにより、同時実行が制御される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 標準出力 | 処理中 | ビルド進捗、テスト結果 |
| バイナリログ | CIモード時自動 | MSBuildの詳細ログ |
| テスト結果 | テスト完了時 | テスト結果レポート |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非0 | CI/CDシステム、開発者通知 |
| ビルド時間 | 閾値超過時 | CI/CDシステム |
| テスト失敗 | 1件以上 | CI/CDシステム、開発者通知 |

## 備考

- このスクリプトは1行のシンプルなラッパーであり、すべての処理は `Build.ps1` に委譲される
- `-ci` フラグにより、CI固有の設定（バイナリログ有効化、ノード再利用無効化等）が自動的に適用される
- `-sign` フラグはコード署名証明書が利用可能な環境でのみ有効
- `-publish` フラグはCI環境での成果物公開に使用される
- 追加の引数は `%*` により Build.ps1 にそのまま渡される
- フルビルドが実行されるため、ローカル開発での使用は非推奨（時間がかかる）
