# バッチ設計書 71-check-channel-consistency.ps1

## 概要

本ドキュメントは、.NET runtimeプロジェクトにおけるMaestroチャンネル整合性チェックスクリプト（check-channel-consistency.ps1）の設計仕様を記載したものである。

### 本バッチの処理概要

このバッチは、Maestro（.NETの依存関係管理システム）で設定されたプロモーションチャンネルと、Azure DevOpsパイプラインのYAML設定で定義されたチャンネルIDの整合性を検証するスクリプトである。

**業務上の目的・背景**：.NETのリリースパイプラインでは、ビルド成果物を複数のMaestroチャンネルに公開することで、依存関係の自動更新が行われる。このバッチは、Maestroで指定されたチャンネルがYAML設定に存在することを検証し、設定の不整合によるリリース失敗を未然に防止する。設定ミスがあった場合、ビルド成果物が正しいチャンネルに公開されず、下流プロジェクトの依存関係更新が失敗する可能性がある。

**バッチの実行タイミング**：ポストビルドフェーズで実行される。具体的には、ビルド完了後、成果物の公開前に整合性チェックとして実行される。CI/CDパイプラインの一部として自動実行される。

**主要な処理内容**：
1. PromoteToChannelsパラメータから公開対象のチャンネルIDリストを抽出
2. 各チャンネルIDがAvailableChannelIdsに含まれているかを検証
3. 不整合が検出された場合はエラーを報告
4. チャンネル未設定の場合は警告を出力してスキップ

**前後の処理との関連**：本バッチはビルド完了後、publish-using-darc.ps1によるパッケージ公開前に実行される。整合性チェックに失敗した場合、後続の公開処理は実行されない。

**影響範囲**：Maestroチャンネル設定、Azure DevOpsパイプライン設定、.NETエコシステム全体の依存関係フロー

## バッチ種別

設定検証 / 整合性チェック

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルドごと） |
| 実行時刻 | ビルド完了後 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | Azure DevOpsパイプライン（ポストビルドステージ） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ビルド完了 | ビルドフェーズが正常に完了していること |
| Maestro設定 | リポジトリがMaestroに登録されていること |
| YAML設定 | AvailableChannelIdsがパイプライン変数として設定されていること |
| tools.ps1 | eng/common/tools.ps1が利用可能であること |

### 実行可否判定

- PromoteToChannelsが空の場合：警告を出力してスキップ（正常終了）
- PromoteToChannelsに値がある場合：整合性チェックを実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| PromoteToChannels | string | Yes | なし | Maestroで指定されたプロモーション対象チャンネルのリスト（スペースまたはカンマ区切り） |
| AvailableChannelIds | array | Yes | なし | YAMLで定義された利用可能なチャンネルIDの配列 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Maestro API | 文字列 | ビルドに関連付けられたデフォルトチャンネル情報 |
| パイプライン変数 | 配列 | YAML設定で定義されたチャンネルID一覧 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 処理結果メッセージ |
| パイプラインログ | テキスト | エラーまたは警告メッセージ |

### 出力ファイル仕様

ファイル出力なし

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ $ci変数を$trueに設定、tools.ps1を読み込み
2. PromoteToChannels空チェック
   └─ 空の場合は警告を出力して正常終了
3. チャンネルIDの抽出
   └─ PromoteToChannelsを非数字で分割してIDリストを取得
4. 整合性チェックループ
   └─ 各チャンネルIDがAvailableChannelIdsに存在するか検証
5. エラー報告
   └─ 不整合があればエラーメッセージを出力
6. 終了処理
   └─ エラーがあれば終了コード1、なければ0で終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[tools.ps1読み込み]
    B --> C{PromoteToChannels空?}
    C -->|Yes| D[警告出力]
    D --> E[終了コード0で終了]
    C -->|No| F[チャンネルID抽出]
    F --> G[ループ: 各チャンネルID]
    G --> H{IDがAvailableに存在?}
    H -->|Yes| I[次のID]
    H -->|No| J[エラー出力、hasErrors=true]
    J --> I
    I --> K{全ID処理完了?}
    K -->|No| G
    K -->|Yes| L{hasErrors?}
    L -->|Yes| M[終了コード1で終了]
    L -->|No| N[done出力]
    N --> O[終了コード0で終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし（設定検証のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | チャンネル不整合 | MaestroチャンネルがYAML設定に存在しない | @dncengに連絡、YAML設定にチャンネルを追加 |
| 1 | 例外発生 | スクリプト実行中の例外 | ログを確認し原因を調査 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. エラーメッセージを確認し、どのチャンネルIDで不整合が発生したか特定
2. Maestroのデフォルトチャンネル設定を確認（`darc get-default-channels`）
3. パイプラインYAMLのAvailableChannelIds設定を確認
4. 不足しているチャンネルをYAML設定に追加するか、Maestro設定を修正

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（検証処理のみ） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1-10チャンネル程度 |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 最小限（文字列操作のみ） |

## 排他制御

同時実行可能。状態を変更しない読み取り専用の検証処理のため、排他制御不要。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 警告ログ | チャンネル未設定時 | 公開先チャンネルが設定されていない旨のメッセージ |
| エラーログ | 整合性エラー時 | 不整合のチャンネルIDと@dncengへの連絡依頼 |
| テレメトリ | 例外発生時 | CheckChannelConsistencyカテゴリでエラー情報 |
| 完了ログ | 正常終了時 | "done." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 実行失敗 | 終了コード1 | パイプライン通知 |
| 整合性エラー | 発生時 | @dnceng（メッセージ内で指示） |

## 備考

- このスクリプトはArcadeフレームワークの一部として提供されている
- Maestroは.NETのバージョン管理とリリースチャンネルを管理するシステム
- DARCはMaestroと連携するCLIツール
- 参照: https://github.com/dotnet/arcade/blob/main/Documentation/Darc.md
