# バッチ設計書 72-publish-using-darc.ps1

## 概要

本ドキュメントは、.NET runtimeプロジェクトにおけるDARCを使用したビルド公開スクリプト（publish-using-darc.ps1）の設計仕様を記載したものである。

### 本バッチの処理概要

このバッチは、DARC（Dependency Automation and Repository Control）CLIツールを使用して、ビルド成果物をMaestroのデフォルトチャンネルに公開するスクリプトである。

**業務上の目的・背景**：.NETエコシステムでは、複数のリポジトリが相互に依存関係を持っている。Maestroは、これらの依存関係を自動的に更新するシステムである。本バッチは、ビルドが完了した後、その成果物（NuGetパッケージ、シンボル等）をMaestroチャンネルに公開することで、下流のリポジトリが最新のパッケージを自動的に取得できるようにする。これにより、手動での依存関係更新作業が不要となり、リリースサイクルが大幅に効率化される。

**バッチの実行タイミング**：ポストビルドフェーズの最終段階で実行される。check-channel-consistency.ps1による整合性チェック後に実行され、ビルド成果物の公開を担当する。

**主要な処理内容**：
1. DARCツールの取得と初期化
2. オプショナルパラメータの組み立て（アーティファクト公開パラメータ、シンボル公開パラメータ等）
3. `darc add-build-to-channel`コマンドの実行
4. 公開完了の待機（オプション）
5. 結果の検証と報告

**前後の処理との関連**：check-channel-consistency.ps1によるチャンネル整合性チェック後に実行される。本バッチの実行後、成果物は指定されたMaestroチャンネルで利用可能となり、Maestroの依存関係更新フローが開始される。

**影響範囲**：Maestroチャンネル、Azure Artifacts、NuGetフィード、下流リポジトリの依存関係更新

## バッチ種別

データ連携 / パッケージ公開

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルドごと） |
| 実行時刻 | ビルド完了後 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | Azure DevOpsパイプライン（ポストビルドステージ） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ビルド完了 | ビルドフェーズが正常に完了していること |
| チャンネル整合性 | check-channel-consistency.ps1が正常終了していること |
| DARCインストール | DARCツールが利用可能であること |
| Azure DevOpsトークン | 有効なAzDoPATが提供されていること |
| tools.ps1 | eng/common/tools.ps1が利用可能であること |

### 実行可否判定

- 必須パラメータがすべて提供されている場合に実行
- DARCコマンドが利用可能な場合に実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| BuildId | int | Yes | なし | 公開対象のビルドID |
| PublishingInfraVersion | int | Yes | なし | 公開インフラのバージョン |
| AzdoToken | string | Yes | なし | Azure DevOpsアクセストークン |
| MaestroApiEndPoint | string | No | https://maestro.dot.net | MaestroAPIのエンドポイント |
| WaitPublishingFinish | string | Yes | なし | 公開完了を待機するかどうか（"true"/"false"） |
| ArtifactsPublishingAdditionalParameters | string | No | なし | アーティファクト公開の追加パラメータ |
| SymbolPublishingAdditionalParameters | string | No | なし | シンボル公開の追加パラメータ |
| RequireDefaultChannels | string | No | なし | デフォルトチャンネル必須フラグ（"true"/"false"） |
| SkipAssetsPublishing | string | No | なし | アセット公開スキップフラグ（"true"/"false"） |
| runtimeSourceFeed | string | No | なし | ランタイムソースフィードURL |
| runtimeSourceFeedKey | string | No | なし | ランタイムソースフィードキー |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| パイプライン変数 | 各種 | Azure DevOpsパイプラインからの入力パラメータ |
| Maestro API | REST | ビルドとチャンネル情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 処理結果メッセージ |
| Maestro | API | ビルドがチャンネルに追加される |
| NuGetフィード | パッケージ | 公開されたNuGetパッケージ |
| シンボルサーバー | シンボル | 公開されたデバッグシンボル |

### 出力ファイル仕様

ファイル直接出力なし（Maestro/NuGetフィード経由での公開）

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ $ci変数を$trueに設定、tools.ps1を読み込み
2. DARCツール取得
   └─ Get-Darc関数でDARCパスを取得
3. オプショナルパラメータ構築
   └─ 各オプションフラグに応じてパラメータリストを構築
4. DARCコマンド実行
   └─ darc add-build-to-channel コマンドを実行
5. 結果検証
   └─ 終了コードを確認し、エラー時は報告
6. 完了処理
   └─ "done."を出力して終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[tools.ps1読み込み]
    B --> C[Get-DarcでDARCパス取得]
    C --> D[オプションパラメータ構築]
    D --> E{ArtifactsPublishingAdditionalParameters?}
    E -->|Yes| F[--artifact-publishing-parameters追加]
    E -->|No| G{SymbolPublishingAdditionalParameters?}
    F --> G
    G -->|Yes| H[--symbol-publishing-parameters追加]
    G -->|No| I{WaitPublishingFinish=false?}
    H --> I
    I -->|Yes| J[--no-wait追加]
    I -->|No| K{RequireDefaultChannels=true?}
    J --> K
    K -->|Yes| L[--default-channels-required追加]
    K -->|No| M{SkipAssetsPublishing=true?}
    L --> M
    M -->|Yes| N[--skip-assets-publishing追加]
    M -->|No| O[darc add-build-to-channel実行]
    N --> O
    O --> P{終了コード=0?}
    P -->|Yes| Q[done出力]
    Q --> R[終了コード0で終了]
    P -->|No| S[エラー出力]
    S --> T[終了コード1で終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本スクリプトは直接データベースを操作しないが、DARC/Maestroを通じて以下の影響がある：

| 処理 | 対象システム | 操作種別 | 概要 |
|-----|-------------|---------|------|
| ビルド登録 | Maestro | INSERT | ビルド情報をMaestroに登録 |
| チャンネル紐付け | Maestro | INSERT | ビルドをデフォルトチャンネルに紐付け |
| パッケージ公開 | NuGetフィード | INSERT | NuGetパッケージをフィードに公開 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | DARC実行失敗 | darc add-build-to-channelが失敗 | ログを確認し、Maestro/Azure DevOps設定を検証 |
| 1 | 例外発生 | スクリプト実行中の例外 | ログを確認し原因を調査 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（スクリプトレベル） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. エラーメッセージを確認し、DARCコマンドの失敗原因を特定
2. Azure DevOpsトークンの有効性を確認
3. MaestroAPIエンドポイントへの接続性を確認
4. 手動でDARCコマンドを実行して問題を切り分け
5. 必要に応じてMaestroチームに連絡

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | DARCコマンド単位 |
| コミットタイミング | DARCコマンド完了時 |
| ロールバック条件 | DARCコマンド失敗時（Maestro側で管理） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ビルド/実行 |
| 目標処理時間 | 数分〜数十分（公開待機時） |
| メモリ使用量上限 | 最小限（外部ツール呼び出し） |

## 排他制御

- 同一ビルドIDに対する同時公開は避けるべき
- Maestro側で重複登録はエラーとなる

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| DARCログ | コマンド実行中 | --verboseによる詳細ログ |
| エラーログ | DARC失敗時 | ビルドID、失敗メッセージ |
| テレメトリ | 例外発生時 | PromoteBuildカテゴリでエラー情報 |
| 完了ログ | 正常終了時 | "done." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 実行失敗 | 終了コード1 | パイプライン通知 |
| 公開遅延 | 設定時間超過 | パイプライン通知 |

## 備考

- DARCはMaestro CLIツールで、依存関係の自動更新を管理
- --ci フラグにより非対話モードで実行
- --verbose フラグにより詳細ログが出力される
- --source-branch mainは固定値で、mainブランチからのビルドとして扱われる
- 参照: https://github.com/dotnet/arcade/blob/main/Documentation/Darc.md
