# バッチ設計書 73-redact-logs.ps1

## 概要

本ドキュメントは、.NET runtimeプロジェクトにおけるビルドログ編集スクリプト（redact-logs.ps1）の設計仕様を記載したものである。

### 本バッチの処理概要

このバッチは、ビルドログ（特にbinlog形式）から機密情報（トークン、パスワード、認証情報等）を削除・編集するスクリプトである。binlogtoolを使用して、指定されたトークンをログファイルから安全に削除する。

**業務上の目的・背景**：CI/CDパイプラインのビルドログには、環境変数やパラメータとして渡された認証トークン、APIキー、パスワードなどの機密情報が含まれる可能性がある。これらのログをアーティファクトとして保存したり、外部に公開したりする際に、機密情報が漏洩するリスクがある。本バッチは、ログ公開前に機密情報を自動的に編集（redact）することで、セキュリティインシデントを防止する。これはセキュリティコンプライアンスの観点から必須の処理である。

**バッチの実行タイミング**：ポストビルドフェーズで実行される。ビルド完了後、ログアーティファクトの公開前に実行され、すべてのbinlogファイルを処理する。

**主要な処理内容**：
1. binlogtoolのインストール（dotnet tool install）
2. 編集対象トークンの収集（パラメータおよびファイルから）
3. 未展開Azure DevOps変数のフィルタリング
4. binlogtool redactコマンドの実行（in-place編集）
5. 処理結果の報告

**前後の処理との関連**：ビルド完了後、ログアーティファクトの公開前に実行される。他のポストビルド処理（パッケージ公開等）とは独立して実行可能。

**影響範囲**：ビルドログファイル（binlog）、アーティファクト公開

## バッチ種別

データクレンジング / セキュリティ処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルドごと） |
| 実行時刻 | ビルド完了後 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | Azure DevOpsパイプライン（ポストビルドステージ） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ビルド完了 | ビルドフェーズが正常に完了していること |
| .NET SDK | dotnet CLIが利用可能であること |
| binlogファイル | 編集対象のbinlogファイルが存在すること |
| tools.ps1 | eng/common/tools.ps1が利用可能であること |
| ネットワーク | NuGetフィードへの接続が可能であること |

### 実行可否判定

- InputPathが存在する場合に実行
- binlogtoolのインストールが成功した場合に処理続行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| InputPath | string | Yes | なし | binlogファイルが格納されているディレクトリパス |
| BinlogToolVersion | string | Yes | なし | binlogtoolのバージョン |
| DotnetPath | string | No | なし | dotnet CLIのパス（省略時は自動検出） |
| PackageFeed | string | No | dotnet-public | binlogtoolのダウンロード元NuGetフィード |
| TokensFilePath | string | No | なし | 編集対象トークンを記載したファイルパス |
| TokensToRedact | string[] | No | なし | 編集対象トークンの配列 |
| runtimeSourceFeed | string | No | なし | ランタイムソースフィードURL |
| runtimeSourceFeedKey | string | No | なし | ランタイムソースフィードキー |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| binlogファイル | バイナリ | MSBuildのバイナリログファイル |
| トークンファイル | テキスト | 改行区切りの編集対象トークンリスト |
| パラメータ | 配列 | 編集対象トークンの直接指定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| binlogファイル | バイナリ | 機密情報が編集されたbinlog（上書き） |
| 標準出力 | テキスト | 処理結果メッセージ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 入力ファイルと同一（in-place編集） |
| 出力先 | InputPathと同一 |
| 文字コード | バイナリ形式 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ $ci変数を$trueに設定、tools.ps1を読み込み
2. dotnetパス解決
   └─ DotnetPath指定がなければInitializeDotNetCliで取得
3. 既存ツールのアンインストール
   └─ グローバルにインストールされたbinlogtoolを削除
4. ツールディレクトリ準備
   └─ .toolsディレクトリを作成
5. binlogtoolのローカルインストール
   └─ dotnet new tool-manifest + dotnet tool install
6. トークンファイルの読み込み
   └─ TokensFilePathが存在すれば読み込んでTokensToRedactに追加
7. トークンのフィルタリング
   └─ 未展開AzDO変数（$(...）形式）を除外
8. redactコマンド実行
   └─ dotnet binlogtool redact --input --recurse --in-place
9. 完了処理
   └─ "done."を出力して終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[tools.ps1読み込み]
    B --> C{DotnetPath指定あり?}
    C -->|Yes| D[指定パス使用]
    C -->|No| E[InitializeDotNetCliでSDK初期化]
    D --> F[グローバルbinlogtoolアンインストール]
    E --> F
    F --> G[.toolsディレクトリ作成]
    G --> H[dotnet new tool-manifest]
    H --> I[dotnet tool install binlogtool]
    I --> J{TokensFilePath存在?}
    J -->|Yes| K[ファイルからトークン読み込み]
    J -->|No| L[TokensToRedactをそのまま使用]
    K --> L
    L --> M[ループ: 各トークン]
    M --> N{未展開AzDO変数?}
    N -->|Yes| O[スキップ]
    N -->|No| P[オプションに追加]
    O --> Q{全トークン処理完了?}
    P --> Q
    Q -->|No| M
    Q -->|Yes| R[binlogtool redact実行]
    R --> S{終了コード=0?}
    S -->|Yes| T[done出力]
    S -->|No| U[警告出力]
    T --> V[終了]
    U --> V
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 警告 | redact失敗 | binlogtool redactが非ゼロ終了 | 警告として扱い処理続行 |
| 1 | 例外発生 | スクリプト実行中の例外 | ログを確認し原因を調査 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. エラーメッセージを確認し、失敗原因を特定
2. NuGetフィードへの接続性を確認
3. binlogtoolのバージョン互換性を確認
4. InputPathの存在とアクセス権限を確認
5. 手動でbinlogtoolを実行して問題を切り分け

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイル単位（in-place編集） |
| コミットタイミング | 各ファイル処理完了時 |
| ロールバック条件 | なし（in-place編集のため復元不可） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数個〜数十個のbinlogファイル |
| 目標処理時間 | 数分以内 |
| メモリ使用量上限 | binlogファイルサイズに依存 |

## 排他制御

- 同一ディレクトリへの同時実行は避けるべき
- in-place編集のため、処理中はファイルがロックされる

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | ツールインストール時 | インストールコマンドと結果 |
| 情報ログ | トークン処理時 | スキップされた未展開変数 |
| 警告ログ | redact失敗時 | 失敗したが無視する旨のメッセージ |
| テレメトリ | 例外発生時 | Redactorカテゴリでエラー情報 |
| 完了ログ | 正常終了時 | "done." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 実行失敗 | 終了コード1 | パイプライン通知 |
| redact警告 | 発生時 | パイプライン警告 |

## 備考

- binlogtoolはMSBuildバイナリログを操作するためのツール
- --recurseオプションにより、サブディレクトリも含めて処理
- --in-placeオプションにより、元ファイルを直接編集（バックアップなし）
- 未展開AzDO変数（`$(...)` 形式）は自動的にスキップされる
- トークンファイルでは`# `で始まる行はコメントとして無視される
- 処理結果のエラーは警告として扱い、ビルド全体は失敗させない設計
