# バッチ設計書 74-sdl.ps1

## 概要

本ドキュメントは、.NET runtimeプロジェクトにおけるSDL（Security Development Lifecycle）メインスクリプト（sdl.ps1）の設計仕様を記載したものである。

### 本バッチの処理概要

このバッチは、Microsoft Guardian CLIツールをインストールするための関数を提供するスクリプトである。Install-Gdn関数をエクスポートし、他のSDLスクリプトから呼び出されてGuardianツールのセットアップを行う。

**業務上の目的・背景**：Microsoft Security Development Lifecycle（SDL）は、ソフトウェア開発プロセスにセキュリティを組み込むためのフレームワークである。Guardianは、MicrosoftのSDLツールスイートを提供するCLIツールで、コードスキャン、脆弱性検出、コンプライアンスチェックなどのセキュリティ検証を実行する。本スクリプトは、これらのセキュリティツールを使用するための基盤を提供し、.NETプロジェクトのセキュリティ品質を確保する上で重要な役割を果たす。

**バッチの実行タイミング**：SDLスキャン実行前に、他のSDLスクリプトから関数として呼び出される。直接実行されるスクリプトではなく、ライブラリとして使用される。

**主要な処理内容**：
1. 指定されたパスにGuardian CLIをインストール
2. オプションでバージョン指定が可能
3. NuGetを使用してSecurityToolsフィードからパッケージを取得
4. インストールされたguardian.cmdのパスを返却

**前後の処理との関連**：execute-all-sdl-tools.ps1やその他のSDLスクリプトから呼び出される。本関数でGuardianをインストール後、init-sdl.ps1で初期化、configure-sdl-tool.ps1でツール設定、run-sdl.ps1でスキャン実行という流れになる。

**影響範囲**：Guardianツールのインストール先ディレクトリ、SDLスキャン実行環境

## バッチ種別

ツールセットアップ / ライブラリ関数

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（SDLスキャン実行時） |
| 実行時刻 | SDLパイプライン実行時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 他のSDLスクリプトからの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| NuGet | nugetコマンドが利用可能であること |
| ネットワーク | SecurityToolsフィードへの接続が可能であること |
| 書き込み権限 | インストール先パスへの書き込み権限があること |
| tools.ps1 | eng/common/tools.ps1が利用可能であること |

### 実行可否判定

- Pathパラメータが指定されている場合に実行
- nugetコマンドが正常に動作する場合に処理続行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| Path | string | Yes | なし | Guardianツールのインストール先ディレクトリ |
| Version | string | No | なし | インストールするGuardianのバージョン（省略時は最新） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| SecurityToolsフィード | NuGet | Microsoft.Guardian.Cliパッケージ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 指定パス | ディレクトリ | Guardianツール一式 |
| 戻り値 | string | guardian.cmdの絶対パス |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | guardian.cmd |
| 出力先 | {Path}/Microsoft.Guardian.Cli.{Version}/tools/ |
| 文字コード | 該当なし（実行ファイル） |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ ErrorActionPreference、StrictMode設定
   └─ $ci変数を$trueに設定、tools.ps1を読み込み
2. NuGet引数の構築
   └─ install、パッケージ名、ソース、出力先、オプションを設定
3. バージョン指定の処理
   └─ Versionパラメータが指定されていれば引数に追加
4. NuGetインストール実行
   └─ Start-Processでnugetを実行
5. guardian.cmdの検索
   └─ Get-ChildItemで再帰的に検索
6. パス返却
   └─ guardian.cmdのフルパスを返却
```

### フローチャート

```mermaid
flowchart TD
    A[Install-Gdn呼び出し] --> B[tools.ps1読み込み]
    B --> C[NuGet引数構築]
    C --> D{Version指定あり?}
    D -->|Yes| E[バージョン引数追加]
    D -->|No| F[nuget install実行]
    E --> F
    F --> G[guardian.cmdを検索]
    G --> H{guardian.cmd見つかった?}
    H -->|Yes| I[フルパスを返却]
    H -->|No| J[テレメトリエラー出力]
    I --> K[関数終了]
    J --> K
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| なし | インストール失敗 | guardian.cmdが見つからない | NuGet接続性、フィードアクセス権限を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. エラーメッセージを確認
2. SecurityToolsフィードへの接続性を確認
3. nugetコマンドの動作を確認
4. インストール先パスの権限を確認
5. 手動でnuget installを実行して問題を切り分け

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1パッケージ/実行 |
| 目標処理時間 | 数十秒〜数分（ネットワーク速度依存） |
| メモリ使用量上限 | 最小限（外部プロセス呼び出し） |

## 排他制御

- 同一インストール先への同時実行は避けるべき
- 通常はパイプライン内で一度だけ呼び出される

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| テレメトリ | インストール失敗時 | Sdlカテゴリで"Failure installing Guardian" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| インストール失敗 | guardian.cmd未検出 | パイプライン通知 |

## 備考

- 本スクリプトは関数ライブラリとして設計されており、直接実行ではなくドットソースで読み込んで使用する
- GuardianはMicrosoftのセキュリティスキャンツールスイート
- SecurityToolsフィードはMicrosoft内部のNuGetフィード（https://securitytools.pkgs.visualstudio.com/_packaging/Guardian/nuget/v3/index.json）
- -NoCacheオプションにより、常に最新のパッケージを取得
- -NonInteractiveオプションにより、対話なしで実行
