# バッチ設計書 75-init-sdl.ps1

## 概要

本ドキュメントは、.NET runtimeプロジェクトにおけるSDL初期化スクリプト（init-sdl.ps1）の設計仕様を記載したものである。

### 本バッチの処理概要

このバッチは、Microsoft Guardian CLIを初期化し、セキュリティスキャン用のベースライン設定を作成するスクリプトである。Guardian CLIの`init`コマンドと`baseline`コマンドを実行して、作業ディレクトリにSDL設定を準備する。

**業務上の目的・背景**：Guardianベースのセキュリティスキャンを実行するためには、作業ディレクトリに`.gdn`フォルダと設定ファイルを初期化する必要がある。また、スキャン結果のベースラインを設定することで、既知の問題を除外し、新規の問題のみを検出できるようになる。本スクリプトは、このセットアップ作業を自動化し、一貫したセキュリティスキャン環境を提供する。

**バッチの実行タイミング**：SDLスキャン実行前に、execute-all-sdl-tools.ps1から呼び出される。Guardianツールのインストール後、ツール設定前に実行される。

**主要な処理内容**：
1. Guardian CLIの`init`コマンドで作業ディレクトリを初期化
2. `.gdn`フォルダと基本設定ファイルの作成
3. Guardian CLIの`baseline`コマンドで`mainbaseline`を作成
4. ベースライン設定により、後続の編集が可能な状態にする

**前後の処理との関連**：sdl.ps1のInstall-Gdn関数でGuardianをインストール後に呼び出される。本スクリプトの実行後、configure-sdl-tool.ps1でツール設定、run-sdl.ps1でスキャン実行という流れになる。

**影響範囲**：作業ディレクトリの`.gdn`フォルダ、Guardianベースライン設定

## バッチ種別

セットアップ / 初期化処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（SDLスキャン実行時） |
| 実行時刻 | SDLパイプライン実行時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | execute-all-sdl-tools.ps1からの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Guardian CLI | guardian.cmdが利用可能であること |
| 作業ディレクトリ | WorkingDirectoryへの書き込み権限があること |
| Azure DevOpsトークン | 有効なAzureDevOpsAccessTokenが提供されていること |
| tools.ps1 | eng/common/tools.ps1が利用可能であること |

### 実行可否判定

- GuardianCliLocationが有効なパスである場合に実行
- WorkingDirectoryが存在する場合に実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| GuardianCliLocation | string | No | なし | Guardian CLIの実行ファイルパス |
| Repository | string | No | なし | リポジトリ名 |
| BranchName | string | No | master | ブランチ名またはgdn設定のバージョン |
| WorkingDirectory | string | No | なし | 作業ディレクトリパス |
| AzureDevOpsAccessToken | string | No | なし | Azure DevOpsアクセストークン |
| GuardianLoggerLevel | string | No | Standard | Guardianのログレベル |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Azure DevOps | リポジトリ | sdl-tool-cfgリポジトリの.gdn設定（オプション） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| .gdnフォルダ | ディレクトリ | Guardian設定フォルダ |
| ベースライン | 設定ファイル | mainbaseline設定 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | .gdn/（ディレクトリ） |
| 出力先 | {WorkingDirectory}/.gdn/ |
| 文字コード | UTF-8（設定ファイル） |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ ErrorActionPreference、StrictMode設定
   └─ $ci変数を$trueに設定、tools.ps1を読み込み
2. 進捗表示の無効化
   └─ ProgressPreference = 'SilentlyContinue'
3. 認証情報の準備
   └─ Azure DevOpsトークンをBase64エンコード
4. URI構築
   └─ sdl-tool-cfgリポジトリへのアクセスURI構築
5. .gdnフォルダパス設定
   └─ 作業ディレクトリに.gdnフォルダパスを設定
6. Guardian init実行
   └─ guardian init --working-directory で初期化
7. Guardian baseline実行
   └─ guardian baseline --name mainbaseline でベースライン作成
8. 正常終了
   └─ ExitWithExitCode 0
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[tools.ps1読み込み]
    B --> C[ProgressPreference設定]
    C --> D[認証情報Base64エンコード]
    D --> E[URI構築]
    E --> F[.gdnフォルダパス設定]
    F --> G[Guardian init実行]
    G --> H{終了コード=0?}
    H -->|Yes| I[Guardian baseline実行]
    H -->|No| J[テレメトリエラー出力]
    J --> K[エラー終了]
    I --> L{終了コード=0?}
    L -->|Yes| M[終了コード0で終了]
    L -->|No| N[テレメトリエラー出力]
    N --> O[エラー終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非ゼロ | init失敗 | Guardian initコマンドが失敗 | GuardianCliLocation、WorkingDirectoryを確認 |
| 非ゼロ | baseline失敗 | Guardian baselineコマンドが失敗 | init成功後の.gdnフォルダ状態を確認 |
| 1 | 例外発生 | スクリプト実行中の例外 | ログを確認し原因を調査 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. エラーメッセージを確認し、失敗したコマンドを特定
2. GuardianCliLocationの有効性を確認
3. WorkingDirectoryの存在と権限を確認
4. 手動でGuardianコマンドを実行して問題を切り分け
5. .gdnフォルダを削除して再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイルシステム操作） |
| コミットタイミング | 各コマンド完了時 |
| ロールバック条件 | なし（手動で.gdnフォルダ削除） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ディレクトリ/実行 |
| 目標処理時間 | 数秒〜数十秒 |
| メモリ使用量上限 | 最小限（外部コマンド呼び出し） |

## 排他制御

- 同一作業ディレクトリへの同時実行は避けるべき
- 既存の.gdnフォルダがある場合の動作に注意

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | コマンド実行前 | 実行するGuardianコマンド |
| テレメトリ | init失敗時 | "Guardian init failed with exit code X" |
| テレメトリ | baseline失敗時 | "Guardian baseline failed with exit code X" |
| テレメトリ | 例外発生時 | Sdlカテゴリでエラー情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 実行失敗 | 非ゼロ終了コード | パイプライン通知 |

## 備考

- BranchNameパラメータのデフォルトは'master'だが、現在は主に設定のバージョン管理に使用
- ProgressPreferenceを'SilentlyContinue'に設定することで、PowerShellの進捗表示を無効化し、パフォーマンスを向上
- mainbaselineはベースラインの名前で、後から編集可能
- 認証情報はBase64エンコードされてHTTPヘッダーで使用
- sdl-tool-cfgリポジトリは設定のテンプレートを格納（現在のコードでは実際にはダウンロードせず初期化のみ実行）
