# バッチ設計書 76-run-sdl.ps1

## 概要

本ドキュメントは、.NET runtimeプロジェクトにおけるSDL実行スクリプト（run-sdl.ps1）の設計仕様を記載したものである。

### 本バッチの処理概要

このバッチは、設定済みのGuardian SDLツールを実行し、セキュリティスキャンを行うスクリプトである。`.gdn/r`ディレクトリに配置された設定ファイルを読み込み、Guardian CLIの`run`コマンドですべてのセキュリティツールを一括実行する。

**業務上の目的・背景**：configure-sdl-tool.ps1で個別に設定されたセキュリティツール（CredScan、PoliCheck、BinSkim、CodeQL等）を一括で実行する必要がある。複数のツールを別々に実行すると、実行のたびに結果が上書きされてしまうため、すべての設定ファイルを一度の`run`コマンドで実行することで、統合されたセキュリティスキャン結果を得ることができる。本スクリプトは、この一括実行を担当し、ベースラインとの比較も行う。

**バッチの実行タイミング**：SDLツールの設定完了後、execute-all-sdl-tools.ps1から呼び出される。init-sdl.ps1による初期化、configure-sdl-tool.ps1によるツール設定が完了した後に実行される。

**主要な処理内容**：
1. Guardian CLIパスの検証
2. `.gdn/r`ディレクトリから設定ファイル（*.gdnconfig）の検出
3. Guardian CLIの`run`コマンドで全ツールを実行
4. mainbaselineとの比較による差分検出
5. ベースライン更新（オプション）

**前後の処理との関連**：configure-sdl-tool.ps1でツール設定後に呼び出される。本スクリプトの実行後、TSA公開やブレイク判定などの後処理がexecute-all-sdl-tools.ps1で行われる。

**影響範囲**：セキュリティスキャン結果、ベースライン設定、パイプライン結果

## バッチ種別

セキュリティスキャン実行

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（SDLスキャン実行時） |
| 実行時刻 | SDLパイプライン実行時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | execute-all-sdl-tools.ps1からの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Guardian CLI | GuardianCliLocationが有効なパスであること |
| 設定完了 | .gdn/rディレクトリに設定ファイルが存在すること |
| 初期化完了 | init-sdl.ps1による初期化が完了していること |
| tools.ps1 | eng/common/tools.ps1が利用可能であること |

### 実行可否判定

- GuardianCliLocationが有効なファイルパスである場合に実行
- .gdn/rディレクトリに*.gdnconfigファイルが存在する場合に処理続行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| GuardianCliLocation | string | No | なし | Guardian CLIの実行ファイルパス |
| WorkingDirectory | string | No | なし | 作業ディレクトリパス |
| GdnFolder | string | No | なし | .gdnフォルダのパス |
| UpdateBaseline | string | No | なし | ベースラインを更新するかどうか |
| GuardianLoggerLevel | string | No | Standard | Guardianのログレベル |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| .gdnconfigファイル | XML/JSON | Guardian設定ファイル |
| mainbaseline | 設定 | ベースライン設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| スキャン結果 | Guardian形式 | セキュリティスキャン結果 |
| 更新されたベースライン | 設定 | ベースライン更新時 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | Guardian内部で管理 |
| 出力先 | .gdnフォルダ内 |
| 文字コード | Guardian形式に準拠 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ ErrorActionPreference、StrictMode設定
   └─ $ci変数を$trueに設定、tools.ps1を読み込み
2. 設定パス構築
   └─ .gdn/rディレクトリパスを設定
3. CLIパス検証
   └─ GuardianCliLocationの存在確認
4. 設定ファイル検出
   └─ Get-ChildItemで*.gdnconfigを再帰検索
5. 設定ファイル出力
   └─ 検出した設定ファイル一覧をログ出力
6. Guardian run実行
   └─ 全設定ファイルを--configに渡して実行
7. 終了コード確認
   └─ Exit-IfNZECで非ゼロ終了コードをチェック
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[tools.ps1読み込み]
    B --> C[.gdn/rパス構築]
    C --> D{GuardianCliLocation有効?}
    D -->|No| E[テレメトリエラー出力]
    E --> F[終了コード1で終了]
    D -->|Yes| G[*.gdnconfigファイル検索]
    G --> H[設定ファイル一覧出力]
    H --> I[Guardian run実行]
    I --> J[Exit-IfNZECでチェック]
    J --> K{正常終了?}
    K -->|Yes| L[処理完了]
    K -->|No| M[エラー処理]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | CLIパス無効 | GuardianCliLocationが存在しない | インストール状況を確認 |
| 非ゼロ | スキャン失敗 | Guardian runコマンドが失敗 | スキャン対象とツール設定を確認 |
| 1 | 例外発生 | スクリプト実行中の例外 | ログを確認し原因を調査 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. エラーメッセージを確認し、失敗原因を特定
2. GuardianCliLocationの有効性を確認
3. .gdn/rディレクトリの設定ファイルを確認
4. 手動でGuardian runコマンドを実行して問題を切り分け
5. 個別のツール設定を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | スキャン対象ファイル数に依存 |
| 目標処理時間 | 数分〜数十分（ツールとスキャン対象による） |
| メモリ使用量上限 | ツールに依存 |

## 排他制御

- 同一作業ディレクトリへの同時実行は避けるべき
- スキャン中はファイルがロックされる可能性あり

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | 設定検出時 | "Discovered Guardian config files:" |
| 情報ログ | コマンド実行時 | Guardianの詳細ログ（logger-levelに依存） |
| テレメトリ | CLIパス無効時 | Sdlカテゴリで"Invalid Guardian CLI Location." |
| テレメトリ | 例外発生時 | Sdlカテゴリでエラー情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 実行失敗 | 非ゼロ終了コード | パイプライン通知 |
| スキャン時間 | 設定閾値超過 | パイプライン警告 |

## 備考

- 複数のツール設定を一度の`run`コマンドで実行することで、結果の上書きを防止
- --baseline mainbaselineにより、init-sdl.ps1で作成したベースラインと比較
- --update-baseline $UpdateBaselineにより、ベースライン更新の可否を制御
- --config @gdnConfigFilesにより、配列展開で複数設定ファイルを指定
- Exec-BlockVerboselyを使用して、実行コマンドを詳細ログに出力
- Exit-IfNZECは、非ゼロ終了コードの場合にSdlカテゴリでエラーを報告
