# バッチ設計書 77-execute-all-sdl-tools.ps1

## 概要

本ドキュメントは、.NET runtimeプロジェクトにおける全SDLツール実行スクリプト（execute-all-sdl-tools.ps1）の設計仕様を記載したものである。

### 本バッチの処理概要

このバッチは、SDL（Security Development Lifecycle）セキュリティスキャンの全体オーケストレーションを担当するメインスクリプトである。Guardianの初期化、ツール設定、スキャン実行、TSA公開、ビルドブレイク判定までの一連のSDL処理を統合的に実行する。

**業務上の目的・背景**：.NETプロジェクトでは、セキュリティ品質を確保するために複数のセキュリティツール（CredScan、PoliCheck、BinSkim、CodeQL等）によるスキャンが必要である。これらのツールを個別に管理・実行するのは煩雑であり、設定ミスや実行漏れのリスクがある。本スクリプトは、すべてのSDLツールの実行を一元管理し、パイプライン内で簡単に呼び出せるエントリーポイントを提供する。また、TSA（Test & Security Automation）との連携により、検出されたセキュリティ問題を自動的にバグとして登録する機能も備える。

**バッチの実行タイミング**：CI/CDパイプラインのセキュリティスキャンステージで実行される。ビルド完了後、またはソースコードの変更時にトリガーされる。

**主要な処理内容**：
1. Guardian CLIの初期化（init-sdl.ps1呼び出し）
2. TSAオンボーディング（オプション）
3. ソースツール、アーティファクトツール、カスタムツールの設定（configure-sdl-tool.ps1呼び出し）
4. 全ツールの一括実行（run-sdl.ps1呼び出し）
5. TSAへの結果公開（オプション）
6. ビルドブレイク判定（オプション）

**前後の処理との関連**：本スクリプトが他のSDLスクリプト（init-sdl.ps1、configure-sdl-tool.ps1、run-sdl.ps1）を呼び出すオーケストレーターとして機能する。ビルドパイプラインからは本スクリプトのみを呼び出せばよい。

**影響範囲**：セキュリティスキャン結果、TSAバグ登録、パイプライン成否判定

## バッチ種別

オーケストレーション / セキュリティ検証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ビルドごと/定期スキャン） |
| 実行時刻 | パイプライン実行時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | Azure DevOpsパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Guardian CLI | GuardianPackageNameまたはGuardianCliLocationが指定されていること |
| ソースディレクトリ | SourceDirectoryが存在すること |
| Azure DevOpsトークン | AzureDevOpsAccessTokenが提供されていること |
| tools.ps1 | eng/common/tools.ps1が利用可能であること |

### 実行可否判定

- GuardianCliLocationが有効なパスである場合に実行
- 必須パラメータ（Repository、SourceDirectory等）が提供されている場合に処理続行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| GuardianPackageName | string | No | なし | GuardianパッケージのNuGet名 |
| NugetPackageDirectory | string | No | なし | NuGetパッケージのインストール先 |
| GuardianCliLocation | string | No | なし | Guardian CLIの直接パス |
| Repository | string | No | $env:BUILD_REPOSITORY_NAME | リポジトリ名 |
| BranchName | string | No | $env:BUILD_SOURCEBRANCH | ブランチ名 |
| SourceDirectory | string | No | $env:BUILD_SOURCESDIRECTORY | ソースコードディレクトリ |
| ArtifactsDirectory | string | No | artifacts | ビルドアーティファクトディレクトリ |
| AzureDevOpsAccessToken | string | No | なし | Azure DevOpsアクセストークン |
| SourceToolsList | object[] | No | なし | ソースコード用SDLツールリスト |
| ArtifactToolsList | object[] | No | なし | アーティファクト用SDLツールリスト |
| CustomToolsList | object[] | No | なし | カスタムツールリスト |
| TsaPublish | bool | No | $False | TSAに結果を公開するか |
| TsaBranchName | string | No | $env:BUILD_SOURCEBRANCH | TSA用ブランチ名 |
| TsaRepositoryName | string | No | $env:BUILD_REPOSITORY_NAME | TSA用リポジトリ名 |
| BuildNumber | string | No | $env:BUILD_BUILDNUMBER | ビルド番号 |
| UpdateBaseline | bool | No | $False | ベースラインを更新するか |
| TsaOnboard | bool | No | $False | TSAにオンボードするか |
| TsaInstanceUrl | string | No | なし | TSAインスタンスURL |
| TsaCodebaseName | string | No | なし | TSAコードベース名 |
| TsaProjectName | string | No | なし | TSAプロジェクト名 |
| TsaNotificationEmail | string | No | なし | TSA通知メール |
| TsaCodebaseAdmin | string | No | なし | TSAコードベース管理者 |
| TsaBugAreaPath | string | No | なし | TSAバグエリアパス |
| TsaIterationPath | string | No | なし | TSAイテレーションパス |
| GuardianLoggerLevel | string | No | Standard | Guardianログレベル |
| CrScanAdditionalRunConfigParams | string[] | No | なし | CredScan追加パラメータ |
| PoliCheckAdditionalRunConfigParams | string[] | No | なし | PoliCheck追加パラメータ |
| CodeQLAdditionalRunConfigParams | string[] | No | なし | CodeQL追加パラメータ |
| BinskimAdditionalRunConfigParams | string[] | No | なし | BinSkim追加パラメータ |
| BreakOnFailure | bool | No | $False | 失敗時にビルドを失敗させるか |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| ソースコード | ファイル | SourceDirectory配下のファイル |
| アーティファクト | ファイル | ArtifactsDirectory配下のファイル |
| 環境変数 | 各種 | Azure DevOpsビルド環境変数 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| スキャン結果 | Guardian形式 | セキュリティスキャン結果 |
| TSA | バグ | 検出された問題をバグとして登録 |
| パイプライン | 終了コード | ビルド成否判定 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | Guardian内部で管理 |
| 出力先 | .gdnフォルダ内 |
| 文字コード | Guardian形式に準拠 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ ErrorActionPreference、StrictMode設定
   └─ $ci変数を$trueに設定、tools.ps1を読み込み
2. リポジトリ名正規化
   └─ "org-repo"形式を"org/repo"形式に変換
3. Guardian CLIパス解決
   └─ GuardianPackageNameまたはGuardianCliLocationからパスを決定
4. CLIパス検証
   └─ パスの存在確認、無効な場合はエラー終了
5. Guardian初期化
   └─ init-sdl.ps1を呼び出し
6. TSAオンボード（オプション）
   └─ TsaOnboard=trueの場合、guardian tsa-onboardを実行
7. ツール設定
   └─ ArtifactToolsList、SourceToolsList、CustomToolsListの各設定
   └─ configure-sdl-tool.ps1を呼び出し
8. SDLスキャン実行
   └─ run-sdl.ps1を呼び出し
9. TSA公開（オプション）
   └─ TsaPublish=trueの場合、guardian tsa-publishを実行
10. ブレイク判定（オプション）
    └─ BreakOnFailure=trueの場合、guardian breakを実行
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[tools.ps1読み込み]
    B --> C[リポジトリ名正規化]
    C --> D[Guardian CLIパス解決]
    D --> E{CLIパス有効?}
    E -->|No| F[エラー終了]
    E -->|Yes| G[init-sdl.ps1呼び出し]
    G --> H{TsaOnboard?}
    H -->|Yes| I[guardian tsa-onboard]
    H -->|No| J[Configure-ToolsList]
    I --> J
    J --> K[ArtifactToolsListの設定]
    K --> L[SourceToolsListの設定]
    L --> M[CustomToolsListの設定]
    M --> N[run-sdl.ps1呼び出し]
    N --> O{TsaPublish?}
    O -->|Yes| P[guardian tsa-publish]
    O -->|No| Q{BreakOnFailure?}
    P --> Q
    Q -->|Yes| R[guardian break]
    Q -->|No| S[処理完了]
    R --> S
```

## データベース操作仕様

### 操作別データベース影響一覧

直接のデータベース操作なし（TSA経由でAzure DevOpsにバグ登録）

| 処理 | 対象システム | 操作種別 | 概要 |
|-----|-------------|---------|------|
| TSA公開 | Azure DevOps | INSERT | セキュリティバグの自動登録 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | CLIパス無効 | GuardianCliLocationが存在しない | インストール状況を確認 |
| 非ゼロ | TSAオンボード失敗 | guardian tsa-onboardが失敗 | TSA設定パラメータを確認 |
| 非ゼロ | TSA公開失敗 | guardian tsa-publishが失敗 | TSA設定とビルド番号を確認 |
| 1 | 例外発生 | スクリプト実行中の例外 | ログを確認し原因を調査 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. エラーメッセージを確認し、失敗したフェーズを特定
2. 該当するサブスクリプトのログを確認
3. パラメータ設定を確認
4. 手動で個別スクリプトを実行して問題を切り分け

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | スキャン対象サイズに依存 |
| 目標処理時間 | 数十分〜数時間（ツールとスキャン対象による） |
| メモリ使用量上限 | ツールに依存 |

## 排他制御

- 同一作業ディレクトリへの同時実行は避けるべき
- スキャン中はファイルがロックされる可能性あり

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | 各フェーズ開始時 | フェーズ名とパラメータ |
| テレメトリ | CLIパス無効時 | Sdlカテゴリでエラー |
| テレメトリ | TSA失敗時 | Sdlカテゴリでエラー |
| テレメトリ | 例外発生時 | Sdlカテゴリでエラー情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 実行失敗 | 非ゼロ終了コード | パイプライン通知 |
| スキャン時間 | 設定閾値超過 | パイプライン警告 |
| セキュリティ問題 | BreakOnFailure時 | パイプラインエラー |

## 備考

- 本スクリプトがSDLスキャンの統合エントリーポイント
- TSA（Test & Security Automation）はMicrosoftの自動セキュリティバグ登録フレームワーク
- SourceToolsListはソースコードディレクトリを対象、ArtifactToolsListはビルド成果物を対象
- CustomToolsListはデフォルトターゲットを指定しない特殊なツール用
- BreakOnFailure=trueの場合、セキュリティ問題検出時にビルドが失敗する
- BreakOnFailure=falseの場合、問題があってもビルドは成功として扱われる
- Configure-ToolsList関数は内部で定義され、各ツールリストに対してconfigure-sdl-tool.ps1を呼び出す
