# バッチ設計書 78-configure-sdl-tool.ps1

## 概要

本ドキュメントは、.NET runtimeプロジェクトにおけるSDLツール設定スクリプト（configure-sdl-tool.ps1）の設計仕様を記載したものである。

### 本バッチの処理概要

このバッチは、Guardian SDLツールの設定ファイル（.gdnconfig）を生成するスクリプトである。指定されたツールリストに基づいて、各ツールに適切なパラメータを設定し、`.gdn/r`ディレクトリに設定ファイルを出力する。

**業務上の目的・背景**：Guardianセキュリティスキャンでは、各ツール（CredScan、PoliCheck、BinSkim、CodeQL等）に対してスキャン対象ディレクトリや追加パラメータを設定する必要がある。これらの設定を手動で行うのは煩雑であり、ツールごとに異なる設定形式を理解する必要がある。本スクリプトは、統一されたインターフェースでツール設定を行い、ツール固有のデフォルトパラメータを自動的に追加することで、設定作業を簡素化する。

**バッチの実行タイミング**：init-sdl.ps1による初期化後、run-sdl.ps1によるスキャン実行前に呼び出される。execute-all-sdl-tools.ps1から各ツールリストに対して呼び出される。

**主要な処理内容**：
1. ツールリストの正規化（文字列からハッシュテーブルへの変換）
2. 各ツールに対するデフォルトパラメータの追加
3. Guardian CLIの`configure`コマンドで設定ファイルを生成
4. `.gdn/r`ディレクトリに設定ファイルを出力

**前後の処理との関連**：execute-all-sdl-tools.ps1のConfigure-ToolsList関数から呼び出される。生成された設定ファイルはrun-sdl.ps1で使用される。

**影響範囲**：Guardian設定ファイル、SDLスキャン対象と設定

## バッチ種別

設定生成 / ツールセットアップ

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（SDLスキャン実行時） |
| 実行時刻 | SDLパイプライン実行時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | execute-all-sdl-tools.ps1からの呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Guardian CLI | GuardianCliLocationが有効なパスであること |
| 初期化完了 | .gdnフォルダが存在すること |
| ツールリスト | ToolsListにツールが指定されていること |
| tools.ps1 | eng/common/tools.ps1が利用可能であること |

### 実行可否判定

- GuardianCliLocationが有効なファイルパスである場合に実行
- ToolsListに要素がある場合に処理続行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| GuardianCliLocation | string | No | なし | Guardian CLIの実行ファイルパス |
| WorkingDirectory | string | No | なし | 作業ディレクトリパス |
| TargetDirectory | string | No | なし | スキャン対象ディレクトリ |
| GdnFolder | string | No | なし | .gdnフォルダのパス |
| ToolsList | object[] | No | なし | 設定するツールのリスト |
| GuardianLoggerLevel | string | No | Standard | Guardianのログレベル |
| CrScanAdditionalRunConfigParams | string[] | No | なし | CredScan追加パラメータ |
| PoliCheckAdditionalRunConfigParams | string[] | No | なし | PoliCheck追加パラメータ |
| CodeQLAdditionalRunConfigParams | string[] | No | なし | CodeQL追加パラメータ |
| BinskimAdditionalRunConfigParams | string[] | No | なし | BinSkim追加パラメータ |

### ToolsListの形式

ToolsListの各要素は以下の形式をサポート：

**文字列形式：**
```powershell
"credscan"
```
→ `@{ Name="credscan" }` に変換

**ハッシュテーブル形式：**
```powershell
@{
    Name = "credscan"
    Scenario = "custom"  # オプション：シナリオ名
    Args = @("param1 < value1", "param2 < value2")  # オプション：追加パラメータ
}
```

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| パラメータ | 配列 | ツール設定情報 |
| .gdnフォルダ | ディレクトリ | Guardian設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| .gdn/rディレクトリ | ファイル | 各ツールの設定ファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | {ToolName}[-_{Scenario}]-configure.gdnconfig |
| 出力先 | {GdnFolder}/r/ |
| 文字コード | Guardian形式に準拠 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ ErrorActionPreference、StrictMode設定
   └─ $ci変数を$trueに設定、tools.ps1を読み込み
2. ツールリスト正規化
   └─ 文字列→ハッシュテーブル変換
   └─ ScenarioとArgsのデフォルト値設定
3. ツールリスト出力
   └─ 設定対象ツール一覧をログ出力
4. CLIパス検証
   └─ GuardianCliLocationの存在確認
5. 各ツールのループ処理
   └─ ツール名とシナリオから設定名を構築
   └─ 出力ファイルパスを決定
   └─ ツール固有のデフォルトパラメータを追加
   └─ Guardian configureコマンドを実行
   └─ 設定ファイル作成を確認
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[tools.ps1読み込み]
    B --> C[ツールリスト正規化]
    C --> D[ツールリスト出力]
    D --> E{CLIパス有効?}
    E -->|No| F[エラー終了]
    E -->|Yes| G[ループ: 各ツール]
    G --> H[設定名構築]
    H --> I[出力パス決定]
    I --> J{ツール種別判定}
    J -->|credscan| K[CredScanパラメータ追加]
    J -->|policheck| L[PoliCheckパラメータ追加]
    J -->|semmle/codeql| M[CodeQLパラメータ追加]
    J -->|binskim| N[BinSkimパラメータ追加]
    J -->|other| O[追加パラメータなし]
    K --> P[Guardian configure実行]
    L --> P
    M --> P
    N --> P
    O --> P
    P --> Q[設定ファイル作成確認]
    Q --> R{次のツール?}
    R -->|Yes| G
    R -->|No| S[処理完了]
```

## ツール別デフォルトパラメータ

### credscan

| パラメータ | 値 | 説明 |
|-----------|-----|------|
| TargetDirectory | $TargetDirectory | スキャン対象ディレクトリ |
| OutputType | pre | 出力形式 |
| + | CrScanAdditionalRunConfigParams | 追加パラメータ |

### policheck

| パラメータ | 値 | 説明 |
|-----------|-----|------|
| Target | $TargetDirectory | スキャン対象ディレクトリ |
| + | PoliCheckAdditionalRunConfigParams | 追加パラメータ |

### semmle / codeql

| パラメータ | 値 | 説明 |
|-----------|-----|------|
| SourceCodeDirectory | $TargetDirectory | ソースコードディレクトリ |
| + | CodeQLAdditionalRunConfigParams | 追加パラメータ |

### binskim

| パラメータ | 値 | 説明 |
|-----------|-----|------|
| Target | $TargetDirectory\**;-:file\|$TargetDirectory\**\_.pdb | スキャン対象（_.pdb除外） |
| + | BinskimAdditionalRunConfigParams | 追加パラメータ |

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | CLIパス無効 | GuardianCliLocationが存在しない | インストール状況を確認 |
| 非ゼロ | configure失敗 | Guardian configureコマンドが失敗 | ツール名とパラメータを確認 |
| 1 | 例外発生 | スクリプト実行中の例外 | ログを確認し原因を調査 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. エラーメッセージを確認し、失敗したツールを特定
2. ツール名のスペルを確認
3. パラメータ形式を確認（"Arg < Value"形式）
4. 手動でGuardian configureコマンドを実行して問題を切り分け

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 各ツール設定完了時 |
| ロールバック条件 | なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1-10ツール/実行 |
| 目標処理時間 | 数秒〜数十秒 |
| メモリ使用量上限 | 最小限（外部コマンド呼び出し） |

## 排他制御

- 同一.gdnフォルダへの同時実行は避けるべき
- 設定ファイル生成時のファイルロックに注意

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | ツールリスト正規化後 | "List of tools to configure:" |
| 情報ログ | 各ツール設定開始時 | "=== Configuring {toolConfigName}..." |
| 情報ログ | 設定ファイル作成後 | "Created '{toolConfigName}' configuration file: {path}" |
| テレメトリ | CLIパス無効時 | Sdlカテゴリで"Invalid Guardian CLI Location." |
| テレメトリ | 例外発生時 | Sdlカテゴリでエラー情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 実行失敗 | 非ゼロ終了コード | パイプライン通知 |

## 備考

- パラメータ形式は"Arg < Value"（スペースで囲まれた<）
- --forceオプションにより既存設定ファイルを上書き
- --noninteractiveオプションにより対話なしで実行
- BinSkimでは_.pdbファイルを除外（GitHub issue #924対策）
- Scenarioを指定すると、同じツールで複数の設定を持てる
- semmleとcodeqlは同等のツールとして扱われる
- 参照: https://dev.azure.com/securitytools/SecurityIntegration/_wiki/wikis/Guardian/1395/configure
