# バッチ設計書 8-eng/common/cibuild.sh

## 概要

本ドキュメントは、.NET Runtimeプロジェクトの `eng/common/cibuild.sh` - CIビルドスクリプト（Linux/macOS）の設計仕様を記載する。

### 本バッチの処理概要

このバッチは、Linux/macOS CI環境でのフルビルドを実行するためのエントリーポイントスクリプトである。`eng/common/build.sh` をCI用のパラメータセットで呼び出し、restore、build、test、pack、publishの全アクションを一括で実行する。

**業務上の目的・背景**：CI/CDパイプライン（Azure DevOps、GitHub Actions等）のLinux/macOSビルドエージェントで、一貫した方法でフルビルドを実行する必要がある。このスクリプトは、`eng/common/CIBuild.cmd` のUnix版として、すべてのビルドステップを単一のコマンドで実行できるようにする。

**バッチの実行タイミング**：CI/CDパイプラインから自動的に呼び出される。プルリクエストのビルド、マージビルド、ナイトリービルド等で使用される。

**主要な処理内容**：
1. シンボリックリンクの解決
2. スクリプトルートディレクトリの特定
3. build.shをCI用パラメータで呼び出し
   - --restore: 依存関係復元
   - --build: ビルド実行
   - --test: テスト実行
   - --pack: パッケージ作成
   - --publish: 公開
   - --ci: CIモード有効化

**前後の処理との関連**：このスクリプトは `eng/common/build.sh` を呼び出す。CI/CDパイプラインの定義ファイル（azure-pipelines.yml等）から参照される。

**影響範囲**：プロジェクト全体のビルド、テスト、パッケージング、公開に影響する。CI環境でのアーティファクト生成とリリースプロセスの起点となる。

## バッチ種別

CIビルド / フルビルド実行

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | CI/CDトリガーに依存 |
| 実行時刻 | 自動（トリガー時） |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | CI/CDパイプライン（PR、マージ、スケジュール等） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Linux/macOS | Unix系CIエージェントでの実行 |
| Bashシェル | Bash互換シェルが利用可能であること |
| CI環境 | CI/CDシステム上での実行が想定される |
| eng/common/build.sh | 委譲先スクリプトが存在すること |

### 実行可否判定

スクリプトは常に実行可能。CI環境以外でも実行できるが、フルビルドが実行されるため時間がかかる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $@ | string[] | No | なし | 追加のコマンドライン引数（build.shに渡される） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| BASH_SOURCE[0] | 環境変数 | スクリプト自身のパス |
| CI環境変数 | 環境変数 | CI/CDシステムが設定する各種変数 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | ビルドの進捗とログ |
| artifacts/ | ディレクトリ | ビルド成果物 |
| artifacts/packages | NuGet | パッケージファイル |
| artifacts/log | ログ | ビルドログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 構成に依存 |
| 出力先 | artifacts/ ディレクトリ配下 |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. スクリプトパスの初期化
   └─ BASH_SOURCE[0] から source 変数を設定
2. シンボリックリンクの解決
   └─ while ループでシンボリックリンクを解決
3. スクリプトルートの特定
   └─ cd -P と dirname で絶対パスを取得
4. build.sh の呼び出し
   └─ CI用パラメータセットで build.sh を実行
   └─ --restore, --build, --test, --pack, --publish, --ci
5. 追加引数の受け渡し
   └─ $@ で追加引数を委譲
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[BASH_SOURCE からパス取得]
    B --> C{シンボリックリンク?}
    C -->|Yes| D[リンク先を解決]
    D --> C
    C -->|No| E[scriptroot を設定]
    E --> F[build.sh を呼び出し]
    F --> G[--restore: 依存関係復元]
    G --> H[--build: ビルド実行]
    H --> I[--test: テスト実行]
    I --> J[--pack: パッケージ作成]
    J --> K[--publish: 公開]
    K --> L[--ci: CIモード]
    L --> M[追加引数処理]
    M --> N[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（データベース操作は行わない）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | ビルドエラー | ビルド、テスト等のいずれかが失敗 | ログを確認して問題を修正 |
| 1 | スクリプトエラー | build.shが見つからない | プロジェクト構成を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | CI/CDシステムの設定に依存 |
| リトライ間隔 | CI/CDシステムの設定に依存 |
| リトライ対象エラー | CI/CDシステムの設定に依存 |

### 障害時対応

1. CI/CDパイプラインのログを確認
2. 失敗したステップ（restore、build、test等）を特定
3. バイナリログを確認して詳細なエラー情報を取得

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のフルビルド |
| 目標処理時間 | プロジェクトサイズに依存（通常数十分〜数時間） |
| メモリ使用量上限 | CIエージェントのスペックに依存 |

## 排他制御

CI/CDシステムのジョブスケジューリングにより、同時実行が制御される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 標準出力 | 処理中 | ビルド進捗、テスト結果 |
| バイナリログ | CIモード時自動 | MSBuildの詳細ログ |
| テスト結果 | テスト完了時 | テスト結果レポート |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非0 | CI/CDシステム、開発者通知 |
| ビルド時間 | 閾値超過時 | CI/CDシステム |
| テスト失敗 | 1件以上 | CI/CDシステム、開発者通知 |

## 備考

- このスクリプトは `eng/common/CIBuild.cmd` のUnix版である
- `-sign` オプションは含まれていない点が CIBuild.cmd と異なる（Unix環境での署名は別途処理）
- シンボリックリンク解決のロジックは他のスクリプトと共通
- `. "$scriptroot/build.sh"` の形式でsourceコマンドとして build.sh を呼び出している
- 追加の引数は `$@` により build.sh にそのまま渡される
- フルビルドが実行されるため、ローカル開発での使用は非推奨（時間がかかる）
