# バッチ設計書 80-extract-artifact-archives.ps1

## 概要

本ドキュメントは、.NET runtimeプロジェクトにおけるアーティファクトアーカイブ展開スクリプト（extract-artifact-archives.ps1）の設計仕様を記載したものである。

### 本バッチの処理概要

このバッチは、tar.gz および zip 形式のアーカイブファイルを展開するスクリプトである。ビルド成果物のアーカイブを展開し、セキュリティスキャンツールがスキャンできる形式にする。Windows 10 / Windows Server 2019 以降で利用可能な tar ユーティリティを使用する。

**業務上の目的・背景**：.NETのビルド成果物は、プラットフォームに応じて異なる形式でアーカイブされる。Linux/macOS向けはtar.gz形式、Windows向けはzip形式が一般的である。セキュリティスキャンツールはこれらのアーカイブ内のファイルを直接スキャンできないため、事前に展開する必要がある。本スクリプトは、両形式のアーカイブを統一的に処理し、セキュリティスキャンの準備を行う。extract-artifact-packages.ps1がNuGetパッケージを対象とするのに対し、本スクリプトは一般的なアーカイブファイルを対象とする。

**バッチの実行タイミング**：SDLスキャン実行前に呼び出される。ビルド完了後、アーティファクトに対するセキュリティスキャンの準備段階で実行される。

**主要な処理内容**：
1. 入力ディレクトリからtar.gzとzipファイルの検索
2. 各アーカイブの並列展開（PowerShell Jobs）
3. tarユーティリティを使用した展開
4. ファイル名.extractedディレクトリへの出力

**前後の処理との関連**：ビルド完了後、execute-all-sdl-tools.ps1によるSDLスキャン前に呼び出される。抽出されたファイルはBinSkimなどのツールでスキャンされる。

**影響範囲**：展開先ディレクトリ、SDLスキャン対象ファイル

## バッチ種別

データ変換 / 前処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（SDLスキャン実行時） |
| 実行時刻 | SDLパイプライン実行時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | Azure DevOpsパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| tarユーティリティ | Windows 10/2019以降の組み込みtarが利用可能であること |
| 入力ディレクトリ | InputPathが存在すること |
| アーカイブファイル | InputPath配下にtar.gzまたはzipが存在すること |
| 書き込み権限 | ExtractPathへの書き込み権限があること |
| tools.ps1 | eng/common/tools.ps1が利用可能であること |

### 実行可否判定

- InputPathとExtractPathが指定されている場合に実行
- tar.gzまたはzipファイルが存在する場合に処理実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| InputPath | string | Yes | なし | アーカイブファイルが格納されているディレクトリ |
| ExtractPath | string | Yes | なし | 展開先ディレクトリ（InputPathと同じでも可） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| .tar.gzファイル | gzip圧縮tar | Linux/macOS向けビルド成果物 |
| .zipファイル | ZIP | Windows向けビルド成果物 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| ExtractPath | ディレクトリ | アーカイブ名.extractedサブディレクトリ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ディレクトリ名 | {アーカイブファイル名}.extracted |
| 出力先 | {ExtractPath}/{filename}.extracted/ |
| 抽出対象 | アーカイブ内のすべてのファイル |
| ディレクトリ構造 | アーカイブ内の相対パスを保持 |

## 処理フロー

### 処理シーケンス

```
1. 初期化
   └─ ErrorActionPreference、StrictMode設定
   └─ $ci変数を$trueに設定、tools.ps1を読み込み
2. アーカイブ検索
   └─ Get-ChildItemで*.tar.gzと*.zipを検索
3. 並列展開ジョブ起動
   └─ 各アーカイブに対してStart-Jobで展開ジョブを起動
4. ジョブ内処理
   └─ 展開先ディレクトリ作成
   └─ tar -xfコマンドで展開
   └─ 終了コード確認
5. ジョブ完了待機
   └─ Receive-Jobで結果取得
6. 処理時間計測
   └─ Measure-Commandで実行時間を出力
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[tools.ps1読み込み]
    B --> C[*.tar.gz検索]
    C --> D[*.zip検索]
    D --> E[アーカイブリスト結合]
    E --> F[ループ: 各アーカイブ]
    F --> G[Start-Jobで並列展開]
    G --> H{全アーカイブ起動?}
    H -->|No| F
    H -->|Yes| I[Receive-Job -Wait]
    I --> J[処理完了]
```

### ジョブ内処理フロー

```mermaid
flowchart TD
    A[ジョブ開始] --> B[ファイル名取得]
    B --> C[展開先ディレクトリ構築]
    C --> D[ディレクトリ作成]
    D --> E[tar -xf 実行]
    E --> F{終了コード=0?}
    F -->|Yes| G[展開完了ログ]
    F -->|No| H[例外スロー]
    G --> I[ジョブ完了]
    H --> I
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非ゼロ | 展開失敗 | tar -xfが非ゼロ終了 | アーカイブファイルの整合性を確認 |
| 1 | 例外発生 | スクリプト実行中の例外 | ログを確認し原因を調査 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. エラーメッセージを確認し、失敗したアーカイブを特定
2. アーカイブファイルの存在と読み取り権限を確認
3. アーカイブファイルの整合性を確認（破損していないか）
4. tarユーティリティが利用可能か確認
5. ExtractPathへの書き込み権限を確認
6. 手動でtar展開を試行して問題を切り分け

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイル操作） |
| コミットタイミング | 各アーカイブ展開完了時 |
| ロールバック条件 | なし（部分展開の可能性あり） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数個〜数十個のアーカイブ |
| 目標処理時間 | アーカイブ数とサイズに依存（数秒〜数分） |
| メモリ使用量上限 | アーカイブサイズに依存 |

## 排他制御

- 同一ExtractPathへの同時実行は避けるべき
- Start-Jobによる並列処理で内部的に並行実行

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | 展開開始時 | "Extracting '{file}' to '{dir}'..." |
| 情報ログ | 展開完了時 | "Extracted to {dir}" |
| エラーログ | 展開失敗時 | "Error extracting '{file}': non-zero exit code" |
| テレメトリ | 例外発生時 | Sdlカテゴリでエラー情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 実行失敗 | 終了コード1 | パイプライン通知 |

## 備考

- Windows 10 / Windows Server 2019 以降の組み込みtarを使用
- tarはtar.gzとzip両方の展開をサポート
- tar -xf で展開、-C で出力先を指定
- 2>&1 でstderrをstdoutにリダイレクトし、出力を$outputに格納
- PowerShellがエラー出力を検出してジョブを早期終了するのを防ぐためのリダイレクト
- ジョブ内ではExit-IfNZECが使用できないため、手動で終了コードをチェック
- InputPathとExtractPathは同じディレクトリでも指定可能
- extract-artifact-packages.ps1がNuGetパッケージ用、本スクリプトが一般アーカイブ用
