# バッチ設計書 81-trim-assets-version

## 概要

本ドキュメントは、`eng/common/sdl/trim-assets-version.ps1` スクリプトの設計仕様を定義するものである。このスクリプトは、NuGetパッケージファイル名からバージョン情報を削除（トリム）するためのセキュリティスキャン準備処理を実行する。

### 本バッチの処理概要

このバッチは、SDL（Security Development Lifecycle）プロセスの一環として、NuGetアセットファイル名からバージョン情報を正規化する処理を行う。

**業務上の目的・背景**：セキュリティスキャンツールでは、バージョン番号が含まれたファイル名は一貫した分析を妨げる場合がある。バージョン情報をトリムすることで、セキュリティスキャンの精度向上と、異なるバージョン間での比較分析が容易になる。また、アーティファクト管理の標準化にも寄与する。

**バッチの実行タイミング**：CIパイプラインでのSDLセキュリティスキャン実行前に実行される。具体的には、ビルドアーティファクトが生成され、セキュリティスキャンを実行する直前のタイミングで呼び出される。

**主要な処理内容**：
1. dotnet CLIの初期化と SDK環境のセットアップ
2. Microsoft.DotNet.VersionTools.Cli ツールのローカルインストール
3. ツールのインストール確認
4. `trim-assets-version` コマンドを使用したNuGetアセットファイル名からのバージョン情報削除

**前後の処理との関連**：前段のビルド処理でNuGetパッケージが生成された後、SDLセキュリティスキャン（extract-artifact-packages.ps1等）の前に実行される。後続のセキュリティスキャンツールは、バージョンがトリムされたファイルを対象として分析を行う。

**影響範囲**：指定された入力パス配下のすべてのNuGetパッケージファイル名が変更される。ファイルの内容自体は変更されないが、ファイル名が正規化される。

## バッチ種別

データ変換処理 / セキュリティスキャン準備

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CIパイプライン実行時） |
| 実行時刻 | パイプライン実行時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | CIパイプライン / SDLタスク |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| InputPath存在 | 入力パスが存在すること |
| .NET SDK | dotnet CLIが利用可能な環境であること |
| ネットワーク接続 | Azure DevOps NuGetフィードにアクセス可能であること |
| tools.ps1 | 共通ツールスクリプトが存在すること |

### 実行可否判定

入力パスの存在確認を行い、存在しない場合はエラーで終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| InputPath | string | Yes | なし | アーティファクトパッケージが格納されているディレクトリのフルパス |
| Recursive | bool | No | $true | NuGetパッケージを再帰的に検索するかどうか |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| InputPath配下のファイル | NuGet (.nupkg) | バージョン情報を含むNuGetパッケージファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| InputPath配下のファイル | NuGet (.nupkg) | バージョン情報がトリムされたNuGetパッケージファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | バージョン番号を除いたパッケージ名 |
| 出力先 | 入力と同じディレクトリ |
| 文字コード | 該当なし（バイナリファイル） |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. 入力パス存在確認
   └─ 存在しない場合はエラー終了（ExitCode 1）
2. 環境初期化
   └─ tools.ps1読み込み、厳格モード設定
3. dotnet CLI初期化
   └─ InitializeDotNetCliでSDK環境をセットアップ
4. Arcade SDKバージョン取得
   └─ Read-ArcadeSdkVersionでツールバージョンを決定
5. VersionTools CLIインストール
   └─ dotnet tool installでローカルツールとしてインストール
6. ツールインストール確認
   └─ dotnet tool listで確認、失敗時はエラー終了
7. trim-assets-versionコマンド実行
   └─ 指定パス配下のNuGetアセットファイル名をトリム
8. 終了処理
   └─ 成功時は正常終了、失敗時はエラー終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{InputPath存在確認}
    B -->|存在しない| C[エラー終了 ExitCode 1]
    B -->|存在する| D[環境変数・モード設定]
    D --> E[InitializeDotNetCli]
    E --> F[Read-ArcadeSdkVersion]
    F --> G[Install-VersionTools-Cli]
    G --> H{ツールインストール確認}
    H -->|失敗| I[エラーログ出力・終了]
    H -->|成功| J[trim-assets-version実行]
    J --> K{実行結果確認}
    K -->|失敗| L[エラーログ出力・終了]
    K -->|成功| M[正常終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 入力パスエラー | InputPathが存在しない | 正しいパスを指定して再実行 |
| 1 | ツールインストールエラー | VersionTools CLIのインストール失敗 | ネットワーク接続確認、NuGetフィード認証確認 |
| 1 | 実行エラー | trim-assets-versionコマンド失敗 | 入力ファイルの形式確認、ログ確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（スクリプト内でのリトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. エラーログを確認し、失敗原因を特定
2. ネットワーク接続やNuGetフィードへのアクセス権限を確認
3. dotnet SDK環境が正しく構成されているか確認
4. 必要に応じてパイプラインを再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイル操作のみ） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | パッケージ数に依存（通常数十〜数百） |
| 目標処理時間 | 数分以内 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同一ディレクトリに対する複数同時実行は想定されていない。パイプライン内で順次実行される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ツールインストール時 | "Installing the package 'Microsoft.DotNet.VersionTools.Cli' with a version of '...' ..." |
| エラーログ | パス未存在時 | "Input Path '...' does not exist" |
| エラーログ | ツール未インストール時 | "The 'Microsoft.DotNet.VersionTools.Cli' tool is not installed." |
| エラーログ | 例外発生時 | 例外メッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | Azure Pipelinesエラー通知 |
| テレメトリカテゴリ | Sdl | NETCORE_ENGINEERING_TELEMETRY |

## 備考

- このスクリプトはSDLセキュリティ検証プロセスの一部として使用される
- Microsoft.DotNet.VersionTools.Cliはdotnet-engフィードから取得される
- $ci変数がtrueに設定され、CI環境での動作を前提としている
