# バッチ設計書 82-generate-sbom-prep

## 概要

本ドキュメントは、`eng/common/generate-sbom-prep.sh` スクリプトの設計仕様を定義するものである。このスクリプトは、SBOM（Software Bill of Materials：ソフトウェア部品表）生成の前処理として、マニフェスト格納用ディレクトリの準備とアーティファクト名の正規化を行う。

### 本バッチの処理概要

このバッチは、Linux/macOS環境でのSBOM生成パイプラインの準備処理を実行し、1ES（One Engineering System）テンプレートとの互換性を確保するためのディレクトリ構造を構築する。

**業務上の目的・背景**：ソフトウェアサプライチェーンセキュリティの観点から、SBOM（ソフトウェア部品表）の生成が必須となっている。このスクリプトは、SBOM生成ツールが正しく動作するための前提条件を整備し、Azure Pipelinesの1ESテンプレートとの互換性を確保する。特に、1ESテンプレートが直接マニフェストディレクトリをアップロードすると、カスタムSBOMが上書きされる問題を回避するための構造を作成する。

**バッチの実行タイミング**：CIパイプラインでのビルド完了後、SBOM生成タスクの実行前に呼び出される。具体的には、ビルドアーティファクトが確定した段階で実行される。

**主要な処理内容**：
1. パイプラインログ関数のインポート
2. ステージ名とジョブ名を組み合わせたアーティファクト名の生成
3. 特殊文字を安全な文字（アンダースコア）に置換
4. SBOMマニフェスト格納用サブディレクトリの作成
5. Azure Pipelines変数への正規化されたアーティファクト名の設定

**前後の処理との関連**：ビルド処理完了後に実行され、後続のSBOM生成タスク（1ES SBOM生成ツール）がこのディレクトリを使用してマニフェストを出力する。環境変数ARTIFACT_NAMEとして設定された値は、後続タスクでアーティファクトのアップロード時に使用される。

**影響範囲**：指定されたマニフェストディレクトリ配下にサブディレクトリが作成される。Azure Pipelines変数ARTIFACT_NAMEが設定され、後続タスクで参照可能になる。

## バッチ種別

環境準備処理 / コンプライアンス支援

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CIパイプライン実行時） |
| 実行時刻 | パイプライン実行時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | CIパイプライン / SBOM生成ステップ前 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| 環境変数 SYSTEM_STAGENAME | Azure Pipelinesステージ名が設定されていること |
| 環境変数 AGENT_JOBNAME | Azure Pipelinesジョブ名が設定されていること |
| pipeline-logging-functions.sh | 同ディレクトリにログ関数スクリプトが存在すること |
| マニフェストディレクトリ引数 | 第1引数としてマニフェストディレクトリパスが渡されること |

### 実行可否判定

ディレクトリ作成の成否で判定。既にディレクトリが存在する場合はエラーとして扱われる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $1 (manifest_dir) | string | Yes | なし | SBOMマニフェストを格納するディレクトリのパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| SYSTEM_STAGENAME | 環境変数 | Azure Pipelinesのステージ名 |
| AGENT_JOBNAME | 環境変数 | Azure Pipelinesのジョブ名 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| $manifest_dir/$safe_artifact_name/ | ディレクトリ | SBOM格納用サブディレクトリ |
| ARTIFACT_NAME環境変数 | 環境変数 | 正規化されたアーティファクト名 |
| Azure Pipelines変数 | パイプライン変数 | ARTIFACT_NAME変数として設定 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ディレクトリ名 | {SYSTEM_STAGENAME}_{AGENT_JOBNAME}_SBOM（特殊文字はアンダースコアに置換） |
| 出力先 | 引数で指定されたマニフェストディレクトリ配下 |
| 文字コード | 該当なし（ディレクトリのみ） |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. スクリプトパス解決
   └─ シンボリックリンクを解決して実際のパスを取得
2. ログ関数読み込み
   └─ pipeline-logging-functions.shをソース
3. アーティファクト名生成
   └─ SYSTEM_STAGENAME + "_" + AGENT_JOBNAME + "_SBOM"
4. 特殊文字置換
   └─ "/:<>\\|?@*$ " および引用符をアンダースコアに置換
5. SBOMディレクトリパス生成
   └─ manifest_dir/safe_artifact_name
6. ディレクトリ作成
   └─ 存在しない場合はmkdir -p、存在する場合はエラー出力
7. 環境変数設定
   └─ export ARTIFACT_NAME=safe_artifact_name
8. パイプライン変数設定
   └─ ##vso[task.setvariable]形式で変数を設定
9. 正常終了
   └─ exit 0
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[スクリプトパス解決]
    B --> C[pipeline-logging-functions.sh読み込み]
    C --> D[アーティファクト名生成]
    D --> E[特殊文字をアンダースコアに置換]
    E --> F[SBOMディレクトリパス生成]
    F --> G{ディレクトリ存在確認}
    G -->|存在しない| H[mkdir -p でディレクトリ作成]
    G -->|存在する| I[エラーメッセージ出力]
    H --> J[成功メッセージ出力]
    I --> K[環境変数・パイプライン変数設定]
    J --> K
    K --> L[exit 0]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ディレクトリ作成エラー | SBOMディレクトリが既に存在する | 既存ディレクトリの削除または別名使用 |
| - | 環境変数未設定 | SYSTEM_STAGENAMEまたはAGENT_JOBNAMEが未設定 | パイプライン設定の確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. エラーメッセージ "Unable to create sbom folder." が出力された場合、既存ディレクトリの確認
2. 環境変数SYSTEM_STAGENAME、AGENT_JOBNAMEの設定確認
3. ディスク容量・権限の確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイルシステム操作のみ） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ディレクトリ |
| 目標処理時間 | 1秒未満 |
| メモリ使用量上限 | 最小限 |

## 排他制御

同一ジョブ内で1回のみ実行される想定。複数同時実行は考慮されていない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | ディレクトリ作成成功時 | "Sbom directory created. {パス}" |
| 情報ログ | アーティファクト名変換前 | "Artifact name before : {変換前名}" |
| 情報ログ | アーティファクト名変換後 | "Artifact name after : {変換後名}" |
| エラーログ | ディレクトリ作成失敗時 | "Unable to create sbom folder." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | Azure Pipelinesエラー通知 |
| テレメトリカテゴリ | Build | NETCORE_ENGINEERING_TELEMETRY |

## 備考

- このスクリプトはLinux/macOS環境専用。Windows環境ではgenerate-sbom-prep.ps1を使用
- 1ESテンプレートとの互換性確保のため、サブディレクトリ構造を使用
- 置換対象の特殊文字: `"/:<>\|?@*$ ` および空白
- 終了コードは常に0（エラー時もエラーメッセージ出力後に0で終了）
