# バッチ設計書 84-vmr-sync

## 概要

本ドキュメントは、`eng/common/vmr-sync.sh` スクリプトの設計仕様を定義するものである。このスクリプトは、現在のリポジトリをローカルのVMR（Virtual Monolithic Repository）に同期するための処理を実行する。

### 本バッチの処理概要

このバッチは、Linux/macOS環境でdotnet/dotnetリポジトリ（VMR）との同期を行い、Source-Build検証やローカルテストのための環境を構築する。

**業務上の目的・背景**：.NETプロジェクトは複数のリポジトリに分散して開発されているが、Source-Build（ソースからの完全ビルド）を実現するためにはVMR（Virtual Monolithic Repository）として統合する必要がある。このスクリプトは、個別リポジトリの変更をVMRに同期することで、Source-Build互換性の検証とローカルでの統合テストを可能にする。

**バッチの実行タイミング**：開発者がローカルでSource-Build検証を行う際、またはCIパイプラインでVMR同期が必要な場合に実行される。主にPull Request作成前のローカル検証や、CI環境でのSource-Build互換性テスト時に使用される。

**主要な処理内容**：
1. 引数解析とバリデーション
2. 一時ディレクトリとVMRディレクトリの準備
3. dotnet/dotnetリポジトリのクローンまたはチェックアウト
4. .NET SDKとDARCツールの初期化
5. darc vmr forwardflowコマンドによる同期実行
6. 同期結果の確認とエラーハンドリング

**前後の処理との関連**：このスクリプトは独立して実行可能だが、後続のSource-Buildテストやローカル検証の前提条件として機能する。同期されたVMRは、その後のビルド・テスト処理で使用される。

**影響範囲**：指定されたVMRディレクトリの内容が更新される。既存の未コミット変更がある場合は同期が拒否される。

## バッチ種別

データ同期処理 / 開発支援ツール

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動実行またはCI実行） |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / CIパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Git | gitコマンドが利用可能であること |
| ネットワーク接続 | GitHubおよびAzure DevOpsにアクセス可能であること |
| tools.sh | eng/common/tools.shが存在すること |
| 一時ディレクトリ | --tmp-dirで指定するディレクトリが作成可能であること |

### 実行可否判定

1. --tmp-dir引数が必須
2. VMRディレクトリに未コミット変更がある場合は実行不可

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -t, --tmp, --tmp-dir | string | Yes | なし | リポジトリクローン用の一時フォルダパス |
| -v, --vmr, --vmr-dir | string | No | $tmp_dir/dotnet | VMRリポジトリのパス |
| -b, --branch, --vmr-branch | string | No | なし | 同期先のVMRブランチ名 |
| --remote | string | No | なし | 追加リモート（name:URI形式） |
| --azdev-pat | string | No | なし | プライベートリポジトリ用Azure DevOps PAT |
| --ci | flag | No | false | CI環境での実行を示すフラグ |
| -d, --debug | flag | No | false | 詳細デバッグログを有効化 |
| -h, --help | flag | No | - | ヘルプを表示 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| 現在のリポジトリ | Git | 同期元のソースコード |
| dotnet/dotnet | Git | 同期先のVMRリポジトリ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| VMRディレクトリ | Git リポジトリ | 同期済みのVMRコード |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ディレクトリ名 | vmr-dir指定値または$tmp_dir/dotnet |
| 出力先 | 指定されたパス |
| 文字コード | ソースファイル依存 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. スクリプトパス解決
   └─ シンボリックリンクを解決
2. 引数解析
   └─ オプション引数を解析、バリデーション
3. 入力検証
   └─ tmp-dirの必須チェック
4. ディレクトリ準備
   └─ 一時ディレクトリ、VMRディレクトリの作成/確認
5. VMR準備
   └─ 未存在時: dotnet/dotnetをクローン
   └─ 既存時: 未コミット変更チェック、ブランチチェックアウト
6. ツール初期化
   └─ tools.sh読み込み、.NET SDK初期化、DARC取得
7. VMR同期実行
   └─ darc vmr forwardflowコマンド実行
8. 結果確認
   └─ 成功: 完了メッセージ
   └─ 失敗: エラーメッセージとガイダンス
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C{tmp-dir指定?}
    C -->|なし| D[エラー終了]
    C -->|あり| E{VMRディレクトリ存在?}
    E -->|なし| F[dotnet/dotnetクローン]
    E -->|あり| G{未コミット変更?}
    G -->|あり| H[エラー終了]
    G -->|なし| I[ブランチチェックアウト]
    F --> J[.NET SDK初期化]
    I --> J
    J --> K[DARC取得]
    K --> L[darc vmr forwardflow実行]
    L --> M{同期成功?}
    M -->|はい| N[成功メッセージ]
    M -->|いいえ| O[エラーメッセージ・ガイダンス]
    N --> P[終了]
    O --> Q[exit 1]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | --tmp-dir未指定 | 必須引数を指定 |
| 1 | 引数エラー | 無効な引数 | ヘルプを参照して正しい引数を指定 |
| 1 | 状態エラー | VMRに未コミット変更あり | 変更をコミットまたはstash |
| 1 | 同期エラー | darc vmr forwardflow失敗 | ログを確認、パッチファイルを修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（スクリプト内でのリトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. ログを確認し、失敗原因を特定
2. --debugオプションで詳細ログを取得
3. パッチファイルの競合がある場合は手動で解決
4. VMRディレクトリを削除して再実行（クリーン状態から）

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（Git操作） |
| コミットタイミング | darc vmr forwardflowが自動コミット |
| ロールバック条件 | 失敗時はVMRが最後の状態で残る |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1リポジトリ |
| 目標処理時間 | リポジトリサイズ・変更量に依存（数分〜数十分） |
| メモリ使用量上限 | リポジトリサイズに依存 |

## 排他制御

同一VMRディレクトリに対する複数同時実行は想定されていない。未コミット変更チェックにより排他制御。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | VMRクローン時 | "Cloning 'dotnet/dotnet' into {パス}.." |
| 情報ログ | 準備時 | "Preparing {パス}" |
| 情報ログ | ツール初期化時 | "Installing .NET, preparing the tooling.." |
| 情報ログ | 同期開始時 | "Starting the synchronization of VMR.." |
| 情報ログ | 成功時 | "Synchronization succeeded" |
| エラーログ | 未コミット変更時 | "There are changes in the working tree..." |
| エラーログ | 同期失敗時 | "Synchronization of repo to VMR failed!" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | コンソール出力 |
| 処理時間 | 60分超過 | 手動監視 |

## 備考

- このスクリプトはLinux/macOS環境専用。Windows環境ではvmr-sync.ps1を使用
- darc（Dependency flow Automation for Repository Coordination）ツールを使用
- 追加リモートオプションにより、フォークからの同期も可能
- CI環境では--ciフラグを使用することで適切なログ出力形式が選択される
- デバッグモードでは`set -x`により詳細なトレースが出力される
