# バッチ設計書 86-pipeline-logging-functions

## 概要

本ドキュメントは、`eng/common/pipeline-logging-functions.sh` スクリプトの設計仕様を定義するものである。このスクリプトは、Azure Pipelines環境でのログ出力およびパイプライン変数設定のための共通関数群を提供するライブラリである。

### 本バッチの処理概要

このスクリプトは、Linux/macOS環境でAzure Pipelinesのログコマンド形式（##vso形式）でメッセージを出力するための関数群を提供する。他のビルド・テストスクリプトからソースされて使用される。

**業務上の目的・背景**：Azure Pipelinesでは、特定の形式（##vso[...]）でメッセージを出力することで、パイプラインの振る舞いを制御できる。このスクリプトは、その形式を抽象化し、ビルドスクリプト全体で一貫したログ出力とパイプライン変数設定を可能にする。また、CI環境と非CI環境での動作を自動的に切り替え、ローカル実行時にも適切な出力を行う。

**バッチの実行タイミング**：他のスクリプトからsource（ドットソース）されるライブラリであり、直接実行されることはない。ビルド・テストパイプラインの実行時に間接的に使用される。

**主要な処理内容**：
1. Write-PipelineTelemetryError: テレメトリカテゴリ付きエラーメッセージの出力
2. Write-PipelineTaskError: パイプラインタスクエラーの出力
3. Write-PipelineSetVariable: パイプライン変数の設定
4. Write-PipelinePrependPath: PATH環境変数への追加
5. Write-PipelineSetResult: パイプライン実行結果の設定

**前後の処理との関連**：このスクリプトは他の多くのビルド・テストスクリプト（generate-sbom-prep.sh等）からソースされる。これらのスクリプトはこのライブラリの関数を使用してAzure Pipelinesと連携する。

**影響範囲**：標準出力へのログメッセージ出力、環境変数PATH、Azure Pipelinesパイプライン変数。

## バッチ種別

共通ライブラリ / ユーティリティ関数群

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 他スクリプトからのソース時 |
| 実行時刻 | パイプライン実行時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | ソース（source/. コマンド） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Bash環境 | bashが利用可能であること |
| $ci変数 | CI環境判定用変数（オプション） |

### 実行可否判定

ライブラリであり、常にソース可能。個別関数はCI環境かどうかで動作が変わる。

## 入力仕様

### 入力パラメータ

各関数のパラメータを以下に示す。

#### Write-PipelineTelemetryError

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -category, -c | string | Yes | なし | テレメトリカテゴリ |
| -force, -f | flag | No | false | CI環境以外でも強制出力 |
| message | string | Yes | なし | エラーメッセージ（残りの引数） |

#### Write-PipelineTaskError

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -type, -t | string | No | error | メッセージタイプ（error/warning） |
| -sourcepath, -s | string | No | なし | ソースファイルパス |
| -linenumber, -ln | string | No | なし | 行番号 |
| -columnnumber, -cn | string | No | なし | 列番号 |
| -errcode, -e | string | No | なし | エラーコード |
| -force, -f | flag | No | false | CI環境以外でも強制出力 |
| message | string | Yes | なし | エラーメッセージ |

#### Write-PipelineSetVariable

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -name, -n | string | Yes | なし | 変数名 |
| -value, -v | string | Yes | なし | 変数値 |
| -secret, -s | flag | No | false | シークレット変数フラグ |
| -as_output, -a | flag | No | false | 出力変数フラグ |
| -is_multi_job_variable, -i | bool | No | true | マルチジョブ変数フラグ |

#### Write-PipelinePrependPath

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -path, -p | string | Yes | なし | PATHに追加するパス |

#### Write-PipelineSetResult

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -result, -r | string | Yes | なし | 結果（Succeeded/SucceededWithIssues/Failed等） |
| -message, -m | string | No | なし | 結果メッセージ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| $ci環境変数 | 変数 | CI環境判定フラグ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | ##vso[...]形式 | Azure Pipelinesログコマンド |
| 標準エラー出力 | テキスト | 非CI環境でのエラーメッセージ |
| PATH環境変数 | 環境変数 | パス追加時 |

### 出力ファイル仕様

ファイル出力なし。

## 処理フロー

### 処理シーケンス

```
【Write-PipelineTelemetryError】
1. 引数解析
   └─ カテゴリ、フォースフラグ、メッセージを抽出
2. CI環境判定
   └─ $ci != true かつ force != true なら標準エラー出力
3. メッセージ整形
   └─ "(NETCORE_ENGINEERING_TELEMETRY={category}) {message}"
4. Write-PipelineTaskError呼び出し

【Write-PipelineTaskError】
1. 引数解析
   └─ タイプ、ソースパス、行番号等を抽出
2. CI環境判定
   └─ $ci != true かつ force != true なら標準エラー出力
3. ログコマンド構築
   └─ "##vso[task.logissue type={type};...]"
4. 標準出力へ出力

【Write-PipelineSetVariable】
1. 引数解析
   └─ 名前、値、シークレット等を抽出
2. CI環境判定
   └─ $ci != true なら何もしない
3. 値のエスケープ
   └─ セミコロン、改行等を%エンコード
4. ログコマンド出力
   └─ "##vso[task.setvariable variable={name};...]{value}"
```

### フローチャート

```mermaid
flowchart TD
    subgraph Write-PipelineTelemetryError
        A1[引数解析] --> A2{CI環境 or force?}
        A2 -->|No| A3[標準エラー出力]
        A2 -->|Yes| A4[メッセージ整形]
        A4 --> A5[Write-PipelineTaskError呼び出し]
    end

    subgraph Write-PipelineTaskError
        B1[引数解析] --> B2{CI環境 or force?}
        B2 -->|No| B3[標準エラー出力]
        B2 -->|Yes| B4[##vso形式構築]
        B4 --> B5[標準出力へ出力]
    end

    subgraph Write-PipelineSetVariable
        C1[引数解析] --> C2{CI環境?}
        C2 -->|No| C3[何もしない]
        C2 -->|Yes| C4[値エスケープ]
        C4 --> C5[##vso形式出力]
    end
```

## データベース操作仕様

### 操作別データベース影響一覧

本スクリプトはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 引数エラー | 必須パラメータ未指定 | 必須パラメータを指定 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

ライブラリ関数であり、呼び出し元で対応。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 関数呼び出し毎 |
| 目標処理時間 | ミリ秒単位 |
| メモリ使用量上限 | 最小限 |

## 排他制御

排他制御なし。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | Write-PipelineTaskError呼び出し時 | ##vso[task.logissue type=error;...] |
| 警告ログ | Write-PipelineTaskError呼び出し時 | ##vso[task.logissue type=warning;...] |
| 変数設定 | Write-PipelineSetVariable呼び出し時 | ##vso[task.setvariable ...] |
| パス追加 | Write-PipelinePrependPath呼び出し時 | ##vso[task.prependpath] |
| 結果設定 | Write-PipelineSetResult呼び出し時 | ##vso[task.complete result=...] |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

## 備考

- このスクリプトはLinux/macOS環境専用。Windows環境ではpipeline-logging-functions.ps1を使用
- 直接実行されることはなく、他スクリプトからsourceされる
- $ci変数がtrueの場合にAzure Pipelines形式で出力
- エスケープ処理: セミコロン(;)→%3B、CR→%0D、LF→%0A、]→%5D
- Write-PipelineTelemetryErrorはNETCORE_ENGINEERING_TELEMETRYカテゴリを付与
