# バッチ設計書 87-pipeline-logging-functions-ps1

## 概要

本ドキュメントは、`eng/common/pipeline-logging-functions.ps1` スクリプトの設計仕様を定義するものである。このスクリプトは、Windows環境でAzure Pipelines環境でのログ出力およびパイプライン変数設定のための共通関数群を提供するライブラリである。

### 本バッチの処理概要

このスクリプトは、Windows環境でAzure Pipelinesのログコマンド形式（##vso形式）でメッセージを出力するための関数群を提供する。他のビルド・テストスクリプトからドットソースされて使用される。

**業務上の目的・背景**：Azure Pipelinesでは、特定の形式（##vso[...]）でメッセージを出力することで、パイプラインの振る舞いを制御できる。このスクリプトは、その形式を抽象化し、ビルドスクリプト全体で一貫したログ出力とパイプライン変数設定を可能にする。また、CI環境と非CI環境での動作を自動的に切り替え、ローカル実行時にも適切な出力を行う。

**バッチの実行タイミング**：他のスクリプトからドットソース（. コマンド）されるライブラリであり、直接実行されることはない。ビルド・テストパイプラインの実行時に間接的に使用される。

**主要な処理内容**：
1. Write-PipelineTelemetryError: テレメトリカテゴリ付きエラーメッセージの出力
2. Write-PipelineTaskError: パイプラインタスクエラーの出力
3. Write-PipelineSetVariable: パイプライン変数の設定
4. Write-PipelinePrependPath: PATH環境変数への追加
5. Write-PipelineSetResult: パイプライン実行結果の設定
6. 内部関数群: Format-LoggingCommandData, Format-LoggingCommand, Write-LoggingCommand, Write-LogIssue

**前後の処理との関連**：このスクリプトは他の多くのビルド・テストスクリプト（generate-sbom-prep.ps1、generate-locproject.ps1等）からドットソースされる。これらのスクリプトはこのライブラリの関数を使用してAzure Pipelinesと連携する。

**影響範囲**：標準出力へのログメッセージ出力、Azure Pipelinesパイプライン変数。

## バッチ種別

共通ライブラリ / ユーティリティ関数群

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 他スクリプトからのドットソース時 |
| 実行時刻 | パイプライン実行時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | ドットソース（. コマンド） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| PowerShell環境 | PowerShellが利用可能であること |
| $ci変数 | CI環境判定用変数（オプション） |

### 実行可否判定

ライブラリであり、常にドットソース可能。個別関数はCI環境かどうかで動作が変わる。

## 入力仕様

### 入力パラメータ

各関数のパラメータを以下に示す。

#### Write-PipelineTelemetryError

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -Category | string | Yes | なし | テレメトリカテゴリ |
| -Message | string | Yes | なし | エラーメッセージ |
| -Type | string | No | 'error' | メッセージタイプ |
| -ErrCode | string | No | なし | エラーコード |
| -SourcePath | string | No | なし | ソースファイルパス |
| -LineNumber | string | No | なし | 行番号 |
| -ColumnNumber | string | No | なし | 列番号 |
| -AsOutput | switch | No | false | 出力として返す |
| -Force | switch | No | false | CI環境以外でも強制出力 |

#### Write-PipelineTaskError

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -Message | string | Yes | なし | エラーメッセージ |
| -Type | string | No | 'error' | メッセージタイプ（error/warning） |
| -ErrCode | string | No | なし | エラーコード |
| -SourcePath | string | No | なし | ソースファイルパス |
| -LineNumber | string | No | なし | 行番号 |
| -ColumnNumber | string | No | なし | 列番号 |
| -AsOutput | switch | No | false | 出力として返す |
| -Force | switch | No | false | CI環境以外でも強制出力 |

#### Write-PipelineSetVariable

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -Name | string | Yes | なし | 変数名 |
| -Value | string | No | なし | 変数値 |
| -Secret | switch | No | false | シークレット変数フラグ |
| -AsOutput | switch | No | false | 出力として返す |
| -IsMultiJobVariable | bool | No | $true | マルチジョブ変数フラグ |

#### Write-PipelinePrependPath

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -Path | string | Yes | なし | PATHに追加するパス |
| -AsOutput | switch | No | false | 出力として返す |

#### Write-PipelineSetResult

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -Result | string | Yes | なし | 結果（Succeeded/SucceededWithIssues/Failed/Cancelled/Skipped） |
| -Message | string | No | なし | 結果メッセージ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| $ci変数 | 変数 | CI環境判定フラグ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力（Write-Host） | ##vso[...]形式 | Azure Pipelinesログコマンド |
| コンソール（非CI） | テキスト | 色付きエラー/警告メッセージ |

### 出力ファイル仕様

ファイル出力なし。

## 処理フロー

### 処理シーケンス

```
【Write-PipelineTelemetryError】
1. パラメータ受け取り
   └─ CmdletBindingによる引数解析
2. メッセージ整形
   └─ Forceまたは$ci時: "(NETCORE_ENGINEERING_TELEMETRY={Category}) {Message}"
3. Write-PipelineTaskError呼び出し
   └─ 整形済みメッセージを渡す

【Write-PipelineTaskError】
1. パラメータ受け取り
   └─ CmdletBindingによる引数解析
2. CI環境判定
   └─ !Force かつ (!$ci または $ci未定義) なら色付きWrite-Host
3. タイプ検証
   └─ error/warning以外なら通常のWrite-Host
4. Write-LogIssue呼び出し
   └─ ログコマンド形式で出力

【Write-PipelineSetVariable】
1. パラメータ受け取り
2. CI環境判定
   └─ $ciがtrueの場合のみ処理
3. Write-LoggingCommand呼び出し
   └─ task.setvariableイベントを出力
```

### フローチャート

```mermaid
flowchart TD
    subgraph Write-PipelineTelemetryError
        A1[パラメータ受け取り] --> A2{Force or $ci?}
        A2 -->|Yes| A3[TELEMETRYカテゴリ付与]
        A2 -->|No| A4[メッセージそのまま]
        A3 --> A5[Write-PipelineTaskError呼び出し]
        A4 --> A5
    end

    subgraph Write-PipelineTaskError
        B1[パラメータ受け取り] --> B2{Force or $ci?}
        B2 -->|No, error| B3[赤色Write-Host]
        B2 -->|No, warning| B4[黄色Write-Host]
        B2 -->|Yes| B5[Write-LogIssue呼び出し]
    end

    subgraph Internal Functions
        C1[Format-LoggingCommandData] --> C2[エスケープ処理]
        C3[Format-LoggingCommand] --> C4[##vso形式構築]
        C5[Write-LoggingCommand] --> C6[Write-Host出力]
        C7[Write-LogIssue] --> C8[task.logissue形式出力]
    end
```

## データベース操作仕様

### 操作別データベース影響一覧

本スクリプトはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 引数エラー | 必須パラメータ未指定 | 必須パラメータを指定 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

ライブラリ関数であり、呼び出し元で対応。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 関数呼び出し毎 |
| 目標処理時間 | ミリ秒単位 |
| メモリ使用量上限 | 最小限 |

## 排他制御

排他制御なし。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | Write-PipelineTaskError呼び出し時 | ##vso[task.logissue type=error;...] |
| 警告ログ | Write-PipelineTaskError呼び出し時 | ##vso[task.logissue type=warning;...] |
| 変数設定 | Write-PipelineSetVariable呼び出し時 | ##vso[task.setvariable ...] |
| パス追加 | Write-PipelinePrependPath呼び出し時 | ##vso[task.prependpath] |
| 結果設定 | Write-PipelineSetResult呼び出し時 | ##vso[task.complete result=...] |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

## 備考

- このスクリプトはWindows環境専用。Linux/macOS環境ではpipeline-logging-functions.shを使用
- 直接実行されることはなく、他スクリプトからドットソースされる
- ソースはMicrosoft azure-pipelines-task-lib から派生
- $ci変数がtrueの場合にAzure Pipelines形式で出力
- エスケープ処理: セミコロン(;)→%3B、CR→%0D、LF→%0A、]→%5D
- Write-PipelineTelemetryErrorはNETCORE_ENGINEERING_TELEMETRYカテゴリを付与
- 非CI環境では色付きメッセージを出力（エラー:赤、警告:黄）
- ValidateSet属性によるResult値の検証（Succeeded/SucceededWithIssues/Failed/Cancelled/Skipped）
