# バッチ設計書 88-retain-build

## 概要

本ドキュメントは、`eng/common/retain-build.ps1` スクリプトの設計仕様を定義するものである。このスクリプトは、Azure DevOpsのビルドを永久保持（keepForever）設定に更新するための処理を実行する。

### 本バッチの処理概要

このスクリプトは、Azure DevOps REST APIを使用して、指定されたビルドの保持設定を「永久保持」に更新する。これにより、ビルドが自動的に削除されることを防ぐ。

**業務上の目的・背景**：Azure DevOpsでは、ビルド結果はデフォルトで一定期間後に自動削除される。リリースビルドや重要なビルドについては、監査・トレーサビリティ・再現性の観点から永久に保持する必要がある。このスクリプトは、そのようなビルドを永久保持対象として設定することで、重要なビルド成果物の喪失を防ぐ。

**バッチの実行タイミング**：リリースパイプラインまたは重要なビルドの完了後に実行される。具体的には、リリース候補ビルドやプロダクションビルドの完了時、パイプラインのポストビルドステップとして呼び出される。

**主要な処理内容**：
1. 入力パラメータの受け取り（ビルドID、組織URI、プロジェクト名、トークン）
2. Azure DevOps認証ヘッダーの生成
3. ビルド更新APIの呼び出し（keepForever: true設定）
4. 結果の確認と成功/失敗の報告

**前後の処理との関連**：ビルド・テストパイプライン完了後に実行される。このスクリプトの前には、リリース対象となるビルドの識別・選択処理がある。後続の処理には、リリースノート生成やアーティファクト公開処理がある。

**影響範囲**：Azure DevOpsの指定されたビルドの保持設定が変更される。ビルド成果物自体には影響しない。

## バッチ種別

API連携処理 / ビルド管理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（リリースパイプライン実行時） |
| 実行時刻 | パイプライン実行時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | CIパイプライン / 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Azure DevOpsアクセス | 指定された組織・プロジェクトにアクセス可能であること |
| 認証トークン | ビルド更新権限を持つPATまたはシステムトークン |
| ビルドID | 有効なビルドIDが指定されていること |
| ネットワーク接続 | Azure DevOps APIエンドポイントにアクセス可能であること |

### 実行可否判定

すべてのパラメータが指定されていること。認証トークンが有効であること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| buildId | int | Yes | なし | 保持対象のビルドID |
| azdoOrgUri | string | Yes | なし | Azure DevOps組織のURI（例: https://dev.azure.com/dnceng） |
| azdoProject | string | Yes | なし | Azure DevOpsプロジェクト名 |
| token | string | Yes | なし | 認証用PAT（Personal Access Token） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| パラメータ | コマンドライン引数 | すべてパラメータとして渡される |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| コンソール | テキスト | 処理状況とresultメッセージ |
| Azure DevOps | API | ビルドの保持設定更新 |

### 出力ファイル仕様

ファイル出力なし。

## 処理フロー

### 処理シーケンス

```
1. パラメータ受け取り
   └─ buildId, azdoOrgUri, azdoProject, token（すべて必須）
2. 厳格モード設定
   └─ ErrorActionPreference = 'Stop', StrictMode Version 2.0
3. 認証ヘッダー生成
   └─ PATをBase64エンコードしてBasic認証ヘッダー作成
4. リクエストボディ作成
   └─ {"keepForever": "true"}
5. API URI構築
   └─ {azdoOrgUri}/{azdoProject}/_apis/build/builds/{buildId}?api-version=6.0
6. APIリクエスト実行
   └─ Invoke-RestMethod -Method Patch
7. 結果確認
   └─ 成功: 保持設定更新完了メッセージ
   └─ 失敗: エラーメッセージ、exit 1
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[パラメータ受け取り]
    B --> C[厳格モード設定]
    C --> D[認証ヘッダー生成]
    D --> E[リクエストボディ作成]
    E --> F[API URI構築]
    F --> G[APIリクエスト送信]
    G --> H{成功?}
    H -->|Yes| I[成功メッセージ出力]
    H -->|No| J[エラーメッセージ出力]
    I --> K[exit 0]
    J --> L[exit 1]
```

## データベース操作仕様

### 操作別データベース影響一覧

本スクリプトはデータベース操作を行わない（Azure DevOps APIを介した操作）。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | API呼び出しエラー | REST API呼び出し失敗 | ネットワーク接続・認証確認 |
| 1 | 認証エラー | トークンが無効または期限切れ | 有効なPATを使用 |
| 1 | 権限エラー | ビルド更新権限がない | 適切な権限を持つトークンを使用 |
| 1 | ビルド不存在 | 指定されたビルドIDが存在しない | 正しいビルドIDを指定 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（スクリプト内でのリトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. エラーメッセージを確認し、失敗原因を特定
2. 認証トークンの有効性を確認
3. Azure DevOpsへのネットワーク接続を確認
4. ビルドIDの正確性を確認
5. 必要に応じて手動でAzure DevOpsポータルから保持設定を変更

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（API呼び出し） |
| コミットタイミング | API呼び出し即時 |
| ロールバック条件 | 手動でのみ可能（APIで保持設定を解除） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ビルド |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 最小限 |

## 排他制御

同一ビルドに対する複数同時実行は想定されていないが、API側で排他制御される。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | API呼び出し前 | "Attempting to retain build using the following URI: {URI} ..." |
| 成功ログ | API呼び出し成功時 | "Updated retention settings for build {buildId}." |
| エラーログ | API呼び出し失敗時 | "Failed to update retention settings for build: {エラー詳細}" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | コンソール出力 / パイプラインエラー |
| API応答時間 | 30秒超過 | タイムアウト |

## 備考

- Azure DevOps REST API バージョン 6.0 を使用
- 認証はBasic認証（PATをBase64エンコード）
- keepForeverを"true"に設定することでビルドが永久保持される
- 保持設定の解除は、再度APIを呼び出してkeepForeverをfalseに設定
- try-catch構文でエラーハンドリングを実装
- $ErrorActionPreference = 'Stop' により、エラー発生時は即座に例外がスロー
