# バッチ設計書 89-generate-locproject

## 概要

本ドキュメントは、`eng/common/generate-locproject.ps1` スクリプトの設計仕様を定義するものである。このスクリプトは、OneLocBuildタスク用のLocProject.jsonファイルを自動生成するための処理を実行する。

### 本バッチの処理概要

このスクリプトは、プロジェクト内のローカライズ対象ファイル（JSON、XLF、WXL、HTML等）を検索し、OneLocBuildタスクが使用するLocProject.json設定ファイルを生成する。

**業務上の目的・背景**：.NETプロジェクトは多言語対応（国際化・ローカライゼーション）が必要であり、翻訳対象のリソースファイルを管理する必要がある。OneLocBuildは、Microsoftの統合ローカライゼーションシステムであり、LocProject.jsonファイルに基づいて翻訳ワークフローを管理する。このスクリプトは、プロジェクト構造から自動的にLocProject.jsonを生成することで、手動設定の手間を削減し、翻訳対象ファイルの追加・削除に追従できるようにする。

**バッチの実行タイミング**：ローカライゼーションパイプラインの実行時、または開発者がローカライズ設定を更新する際に実行される。通常はCIパイプラインの一部として呼び出される。

**主要な処理内容**：
1. ソースディレクトリ内のローカライズ対象ファイルの検索
2. 各ファイル形式に応じたLocItems設定の生成
3. 除外ファイルリスト（LocExclusions.json）の適用
4. 中立言語XLFファイルの生成（オプション）
5. LocProject.jsonの出力または既存ファイルとの比較

**前後の処理との関連**：このスクリプトはビルドパイプライン内のローカライゼーションステップの前に実行される。生成されたLocProject.jsonは、OneLocBuildタスクによって読み込まれ、翻訳ワークフローが実行される。

**影響範囲**：eng/Localize/LocProject.jsonファイルが生成または更新される。-CreateNeutralXlfsオプション使用時はXLFファイルも生成される。

## バッチ種別

設定ファイル生成 / 国際化支援

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ローカライゼーションパイプライン実行時） |
| 実行時刻 | パイプライン実行時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | CIパイプライン / 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| SourcesDirectory | ソースファイルが存在するディレクトリ |
| pipeline-logging-functions.ps1 | ログ関数スクリプトが存在すること |
| ローカライズ対象ファイル | JSON、XLF、WXL、HTMLファイルが存在すること |

### 実行可否判定

SourcesDirectoryが指定されていること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| SourcesDirectory | string | Yes | なし | ソースファイルが存在するディレクトリ |
| LanguageSet | string | No | 'VS_Main_Languages' | OneLocBuildで使用する言語セット |
| UseCheckedInLocProjectJson | switch | No | false | 既存LocProject.jsonとの比較モード |
| CreateNeutralXlfs | switch | No | false | 中立言語XLFファイルを作成 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| .template.config\localize\*.en.json | JSON | .NETテンプレートのローカライズファイル |
| en\strings.json | JSON | WinFormsパターンのローカライズファイル |
| *.\<langcode\>.xlf | XLF | XLIFF形式の翻訳ファイル |
| *.wxl | WXL | WiX Toolsetのローカライズファイル |
| en.lproj\*.html | HTML | macOSインストーラのHTMLファイル |
| eng\Localize\LocExclusions.json | JSON | 除外ファイルリスト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| eng\Localize\LocProject.json | JSON | OneLocBuild設定ファイル |
| eng\Localize\LocProject-generated.json | JSON | 比較用生成ファイル（-UseCheckedInLocProjectJson時） |
| 中立言語XLFファイル | XLF | 言語コードなしのXLFファイル（-CreateNeutralXlfs時） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | LocProject.json / LocProject-generated.json |
| 出力先 | {SourcesDirectory}\eng\Localize\ |
| 文字コード | UTF-8 |
| 形式 | JSON（深さ5でシリアライズ） |

## 処理フロー

### 処理シーケンス

```
1. パラメータ受け取り・初期化
   └─ SourcesDirectory, LanguageSet等
2. 除外リスト読み込み
   └─ eng\Localize\LocExclusions.jsonが存在すれば読み込み
3. 作業ディレクトリ変更
   └─ Push-Location $SourcesDirectory
4. JSONテンプレートファイル検索・処理
   └─ .template.config\localize\*.en.json パターン
5. WinForms JSONファイル検索
   └─ en\strings.json パターン
6. WXLファイル検索・処理
   └─ *.wxl パターン、スキーマでv3/v5を分類
7. macOS HTMLファイル検索・処理
   └─ en.lproj\*.html パターン
8. XLFファイル検索・処理
   └─ *.\<langcode\>.xlf パターン
9. LocProject.json構築
   └─ 各ファイルタイプのLocItemsを統合
10. 出力処理
    └─ 新規生成または既存との比較
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[除外リスト読み込み]
    B --> C[Push-Location SourcesDirectory]
    C --> D[JSONテンプレートファイル検索]
    D --> E[WinForms JSONファイル検索]
    E --> F[WXLファイル検索・分類]
    F --> G[macOS HTMLファイル検索]
    G --> H[XLFファイル検索]
    H --> I[LocProject JSON構築]
    I --> J{UseCheckedInLocProjectJson?}
    J -->|No| K[LocProject.json出力]
    J -->|Yes| L[LocProject-generated.json出力]
    L --> M{ハッシュ比較}
    M -->|一致| N[成功メッセージ]
    M -->|不一致| O[エラー終了 exit 1]
    K --> P[終了]
    N --> P
```

## データベース操作仕様

### 操作別データベース影響一覧

本スクリプトはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 比較エラー | 既存LocProject.jsonと生成ファイルが不一致 | 生成ファイルを確認して既存ファイルを更新 |
| - | ファイル検索エラー | 対象ファイルが見つからない | プロジェクト構造を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. エラーメッセージを確認し、失敗原因を特定
2. LocProject-generated.jsonをダウンロードして差分を確認
3. 必要に応じてLocProject.jsonを手動更新
4. 除外リスト（LocExclusions.json）を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイル生成） |
| コミットタイミング | 即時 |
| ロールバック条件 | 手動でのみ可能 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | ファイル数に依存 |
| 目標処理時間 | 数秒〜数十秒 |
| メモリ使用量上限 | ファイル数に依存 |

## 排他制御

排他制御なし。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | JSON生成後 | "LocProject.json generated:\n\n{JSON内容}\n\n" |
| 情報ログ | 比較一致時 | "Generated LocProject.json and current LocProject.json are identical." |
| エラーログ | 比較不一致時 | "Existing LocProject.json differs from generated LocProject.json..." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 0以外 | パイプラインエラー |
| テレメトリカテゴリ | OneLocBuild | NETCORE_ENGINEERING_TELEMETRY |

## 備考

- OneLocBuildタスクの詳細は https://ceapex.visualstudio.com/CEINTL/_wiki/wikis/CEINTL.wiki/107/ を参照
- WXLファイルはスキーマバージョンでv3（wix/2006/localization）とv5（wixtoolset.org/schemas/v4/wxl）に分類
- LSSファイル: wxl_loc.lss（v3用）、P210WxlSchemaV4.lss（v5用）、P22DotNetHtmlLocalization.lss（HTML用）
- CloneLanguageSet: WiX_CloneLanguages（WXL用）、VS_macOS_CloneLanguages（macOS HTML用）
- CopyOption: LangIDOnName（ファイル名に言語ID）、LangIDOnPath（パスに言語ID）
- -CreateNeutralXlfsがfalseの場合、生成した中立XLFファイルは削除される
- Get-FileHashによるハッシュ比較で既存ファイルとの差分を検出
