# バッチ設計書 9-dotnet.sh

## 概要

本ドキュメントは、.NET Runtimeプロジェクトの `dotnet.sh` - dotnet CLIラッパースクリプト（Linux/macOS）の設計仕様を記載する。

### 本バッチの処理概要

このバッチは、プロジェクト固有の.NET SDKバージョンを使用してdotnet CLIコマンドを実行するためのラッパースクリプトである。プロジェクトルートに配置され、開発者がグローバルにインストールされたSDKではなく、プロジェクトで指定されたSDKバージョンを確実に使用できるようにする。

**業務上の目的・背景**：.NET Runtimeプロジェクトは特定のSDKバージョンを使用してビルドする必要がある。開発者のマシンにインストールされているグローバルSDKのバージョンは様々であり、バージョンの不一致による問題を防ぐため、このスクリプトがローカルSDKを自動的に初期化して使用する。

**バッチの実行タイミング**：開発者による手動実行。`./dotnet.sh build`、`./dotnet.sh test` などの形式で使用される。

**主要な処理内容**：
1. シンボリックリンクの解決
2. DOTNET_SKIP_FIRST_TIME_EXPERIENCEの設定
3. eng/common/tools.shの読み込み
4. InitializeDotNetCli関数によるSDKの初期化
5. ローカルSDKのdotnetコマンドの実行

**前後の処理との関連**：`eng/common/tools.sh` を読み込んでSDK初期化関数を使用する。`dotnet.cmd` のUnix版である。

**影響範囲**：dotnetコマンドの実行環境に影響する。プロジェクト固有のSDKバージョンが使用されることを保証する。

## バッチ種別

SDK管理 / CLIラッパー

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 任意 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Linux/macOS | Unix系環境での実行 |
| Bashシェル | Bash互換シェルが利用可能であること |
| ネットワーク接続 | SDKダウンロードに必要（初回のみ） |
| eng/common/tools.sh | 共通ツール関数が存在すること |

### 実行可否判定

スクリプトは常に実行可能。SDKが未インストールの場合は自動的にダウンロードされる。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| $@ | string[] | No | なし | dotnetコマンドに渡す引数（build, test, run等） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| BASH_SOURCE[0] | 環境変数 | スクリプト自身のパス |
| eng/common/tools.sh | シェルスクリプト | SDK初期化関数の提供 |
| global.json | JSON | プロジェクトで使用するSDKバージョンの定義 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | dotnetコマンドの出力 |
| 標準エラー | テキスト | dotnetコマンドのエラー出力 |

### 出力ファイル仕様

このスクリプト自体はファイル出力を行わない。dotnetコマンドの出力に依存する。

| 項目 | 内容 |
|-----|------|
| ファイル名 | dotnetコマンドに依存 |
| 出力先 | dotnetコマンドに依存 |
| 文字コード | UTF-8 |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. スクリプトパスの初期化
   └─ BASH_SOURCE[0] から source 変数を設定
2. シンボリックリンクの解決
   └─ while ループでシンボリックリンクを解決
3. スクリプトルートの特定
   └─ cd -P と dirname で絶対パスを取得
4. 初回実行体験の無効化
   └─ DOTNET_SKIP_FIRST_TIME_EXPERIENCE=1 を設定
5. tools.sh の読み込み
   └─ source コマンドで関数を定義
6. SDK の初期化
   └─ InitializeDotNetCli true でSDKをインストール/取得
7. dotnet コマンドの実行
   └─ ローカルSDKのdotnetに引数を渡して実行
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[BASH_SOURCE からパス取得]
    B --> C{シンボリックリンク?}
    C -->|Yes| D[リンク先を解決]
    D --> C
    C -->|No| E[scriptroot を設定]
    E --> F[DOTNET_SKIP_FIRST_TIME_EXPERIENCE=1]
    F --> G[tools.sh を読み込み]
    G --> H[InitializeDotNetCli true]
    H --> I[__dotnetDir を取得]
    I --> J[dotnetPath を設定]
    J --> K[dotnet コマンド実行]
    K --> L[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（データベース操作は行わない）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | dotnetエラー | dotnetコマンドがエラー終了 | エラーメッセージを確認 |
| 1 | SDK初期化エラー | SDKのダウンロードまたは初期化に失敗 | ネットワーク接続を確認 |
| 1 | tools.shエラー | tools.shが見つからない | プロジェクト構成を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. エラーメッセージを確認
2. SDKのダウンロードに問題がある場合はネットワーク接続を確認
3. artifacts/toolset ディレクトリを削除してSDKを再ダウンロード

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のコマンド実行 |
| 目標処理時間 | SDK初期化後は即座に実行（初回はダウンロード時間が必要） |
| メモリ使用量上限 | dotnetコマンドに依存 |

## 排他制御

同時実行の制御はこのスクリプトでは行わない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 標準出力 | 処理中 | dotnetコマンドの出力 |
| 標準エラー | エラー発生時 | dotnetコマンドのエラー出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非0 | 呼び出し元 |

## 備考

- DOTNET_SKIP_FIRST_TIME_EXPERIENCE=1 により、dotnetの初回実行時のwelcomeメッセージやNuGetキャッシュの準備をスキップする
- InitializeDotNetCli の引数 `true` はSDKのインストールを行うことを示す
- _InitializeDotNetCli 変数にはSDKのインストールパスが格納される
- グローバルにインストールされたdotnetではなく、プロジェクト固有のSDKを使用することで、ビルドの再現性を確保
- このスクリプトは `dotnet.cmd` と対になるUnix版スクリプトである
