# バッチ設計書 90-enable-cross-org-publishing

## 概要

本ドキュメントは、`eng/common/enable-cross-org-publishing.ps1` スクリプトの設計仕様を定義するものである。このスクリプトは、Azure DevOps組織間でのNuGetパッケージ公開を可能にするための認証設定を行う。

### 本バッチの処理概要

このスクリプトは、Azure DevOps環境で複数の組織（dnceng、devdiv等）のNuGetフィードにアクセスするための認証トークンとURIプレフィックスを設定する。

**業務上の目的・背景**：.NETプロジェクトは複数のAzure DevOps組織（dnceng、devdiv等）で管理されており、ビルドパイプラインは異なる組織のNuGetフィードからパッケージを取得したり、パッケージを公開したりする必要がある。このスクリプトは、組織間のNuGetフィードアクセスに必要な認証設定を行うことで、クロス組織でのパッケージ公開・取得を可能にする。

**バッチの実行タイミング**：CIパイプラインでNuGetパッケージの公開または取得を行う前に実行される。特に、リリースパイプラインやパッケージ公開ステップの前処理として呼び出される。

**主要な処理内容**：
1. パイプラインログ関数の読み込み
2. CI環境変数の設定
3. VSS_NUGET_ACCESSTOKEN変数の設定（認証トークン）
4. VSS_NUGET_URI_PREFIXES変数の設定（許可されたフィードURIプレフィックス）

**前後の処理との関連**：このスクリプトはNuGet操作（restore、push等）を行うタスクの前に実行される。設定された環境変数は、NuGet CredentialProviderによって使用され、プライベートフィードへの認証が行われる。

**影響範囲**：Azure Pipelinesのパイプライン変数（VSS_NUGET_ACCESSTOKEN、VSS_NUGET_URI_PREFIXES）が設定される。

## バッチ種別

認証設定 / CI/CD支援

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CIパイプライン実行時） |
| 実行時刻 | パイプライン実行時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | CIパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| pipeline-logging-functions.ps1 | ログ関数スクリプトが存在すること |
| token | 認証トークンが引数として渡されること |
| Azure Pipelines環境 | Azure DevOpsパイプライン内で実行されること |

### 実行可否判定

tokenパラメータが指定されていること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| token | string | No | なし | NuGetフィードアクセス用の認証トークン |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| token | パラメータ | Azure DevOpsシステムトークンまたはPAT |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| VSS_NUGET_ACCESSTOKEN | パイプライン変数 | 認証トークン |
| VSS_NUGET_URI_PREFIXES | パイプライン変数 | 許可されたNuGetフィードURIプレフィックス |

### 出力ファイル仕様

ファイル出力なし。

## 処理フロー

### 処理シーケンス

```
1. パイプラインログ関数読み込み
   └─ pipeline-logging-functions.ps1をドットソース
2. CI変数設定
   └─ $ci = $true（パイプライン変数設定を有効化）
3. VSS_NUGET_ACCESSTOKEN設定
   └─ Write-PipelineSetVariableで認証トークンを設定
   └─ IsMultiJobVariable = $false（現在のジョブのみ）
4. VSS_NUGET_URI_PREFIXES設定
   └─ Write-PipelineSetVariableでURIプレフィックスを設定
   └─ dnceng、devdiv組織のフィードURIを許可
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[pipeline-logging-functions.ps1読み込み]
    B --> C["$ci = $true 設定"]
    C --> D["Write-PipelineSetVariable VSS_NUGET_ACCESSTOKEN"]
    D --> E["Write-PipelineSetVariable VSS_NUGET_URI_PREFIXES"]
    E --> F[終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本スクリプトはデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | パラメータエラー | tokenが空または未指定 | 有効なトークンを指定 |
| - | スクリプト読み込みエラー | pipeline-logging-functions.ps1が見つからない | スクリプトの配置を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. トークンが正しく渡されているか確認
2. pipeline-logging-functions.ps1が同ディレクトリに存在するか確認
3. Azure Pipelines環境で実行されているか確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 即時 |
| ロールバック条件 | 手動でのみ可能 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 2変数 |
| 目標処理時間 | ミリ秒単位 |
| メモリ使用量上限 | 最小限 |

## 排他制御

排他制御なし。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 変数設定 | VSS_NUGET_ACCESSTOKEN設定時 | ##vso[task.setvariable variable=VSS_NUGET_ACCESSTOKEN;...] |
| 変数設定 | VSS_NUGET_URI_PREFIXES設定時 | ##vso[task.setvariable variable=VSS_NUGET_URI_PREFIXES;...] |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 該当なし | - | - |

## 備考

- Azure Pipelines専用スクリプト（$ci = $trueを明示的に設定）
- 許可されたNuGetフィードURIプレフィックス:
  - https://dnceng.pkgs.visualstudio.com/
  - https://pkgs.dev.azure.com/dnceng/
  - https://devdiv.pkgs.visualstudio.com/
  - https://pkgs.dev.azure.com/devdiv/
- IsMultiJobVariable = $falseにより、変数は現在のジョブ内でのみ有効
- VSS_NUGET_ACCESSTOKENはNuGet Credential Providerによって使用される
- VSS_NUGET_URI_PREFIXESはセミコロン区切りで複数のURIを指定
