# バッチ設計書 92-evaluate-changed-darc-deps.sh

## 概要

本ドキュメントは、.NET Runtimeプロジェクトにおける依存関係変更評価スクリプト（evaluate-changed-darc-deps.sh）の設計仕様を定義するものである。このスクリプトはCI/CDパイプラインで使用され、eng/Version.Details.xmlファイルの依存関係変更を検出して後続のビルドジョブの実行を制御する。

### 本バッチの処理概要

このバッチは、DARC（Dependency Flow Automation）で管理される依存関係ファイル（eng/Version.Details.xml）の変更を検出し、変更された依存関係ごとにAzure DevOps出力変数を設定する処理を行う。これにより、特定の依存関係が更新された場合にのみ関連するビルドジョブを実行することが可能になる。

**業務上の目的・背景**：.NET Runtimeは多数の外部依存関係を持ち、それらはDARC（Dependency Flow Automation）を通じて自動更新される。依存関係の更新により影響を受けるコンポーネントのみをリビルドすることで、CI/CDパイプラインの効率を最適化する必要がある。Version.Details.xmlの変更を詳細に分析し、変更された依存関係を特定することで、ピンポイントでのビルド実行が可能になる。

**バッチの実行タイミング**：CIパイプラインの初期段階で実行される。依存関係の更新PR（Maestroによる自動PR）やmainブランチへのマージ時にトリガーされる。

**主要な処理内容**：
1. コマンドライン引数の解析（difftarget、azurevariableprefix）
2. 指定されたdifftargetからeng/Version.Details.xmlの旧バージョンを取得
3. Python3スクリプト（get-changed-darc-deps.py）を呼び出して新旧XMLを比較
4. バージョンまたはSHAが変更された依存関係、または片方のXMLにのみ存在する依存関係を検出
5. 検出された各依存関係に対してAzure DevOps出力変数を設定

**前後の処理との関連**：パイプラインの最初期にevaluate-changed-paths.shと並行して実行される。出力変数を通じて、依存関係に関連するビルドジョブ（特定ライブラリの更新、ランタイムコンポーネントの再ビルド等）の実行可否を制御する。

**影響範囲**：Azure DevOpsパイプラインの依存関係関連ビルドに影響。Maestroによる自動依存関係更新PRのCI効率に直結する。

## バッチ種別

CI最適化 / 依存関係変更検出 / パイプライン制御

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動 |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 依存関係更新PR、mainブランチへのマージ（Azure DevOpsパイプライン） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Gitリポジトリ | スクリプトはGitリポジトリ内で実行される必要がある |
| difftarget | 比較対象のコミットまたはブランチが必須パラメータとして指定されている |
| Python3 | python3コマンドが利用可能 |
| eng/Version.Details.xml | 現在の依存関係定義ファイルが存在する |
| pipeline-logging-functions.sh | eng/common/pipeline-logging-functions.shが存在する |
| get-changed-darc-deps.py | eng/pipelines/get-changed-darc-deps.pyが存在する |

### 実行可否判定

difftargetパラメータが必須。指定されていない場合はusageを表示して終了コード1で終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --difftarget | string | Yes | なし | 比較対象のSHAまたはブランチ名（例: HEAD^1, origin/main） |
| --azurevariableprefix | string | No | 空文字 | 出力変数名のプレフィックス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| eng/Version.Details.xml | XML | 現在の依存関係定義（バージョン、SHA、依存関係名） |
| difftarget:eng/Version.Details.xml | XML | 比較対象の依存関係定義（git showで取得） |
| eng/pipelines/get-changed-darc-deps.py | Python | XML比較処理を行うPythonスクリプト |
| eng/common/pipeline-logging-functions.sh | Shell Script | Azure Pipelines用のログ関数 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Azure DevOps変数 | 出力変数 | 変更された依存関係ごとに{prefix}_{dependency_name}=trueを設定 |
| 標準出力 | テキスト | 設定した変数名のログ |

### 出力ファイル仕様

ファイル出力なし（Azure DevOps出力変数とコンソール出力のみ）。一時ファイル（旧XML保存用）は処理完了後に削除される。

## 処理フロー

### 処理シーケンス

```
1. 初期設定
   └─ set -f（globbing無効化）、set -u（未定義変数エラー）、set -e（エラー時停止）
2. コマンドライン引数の解析
   └─ difftarget（必須）、azurevariableprefix（任意）
3. difftargetパラメータの検証
   └─ 未指定の場合はusage表示して終了コード1
4. 一時ファイルの作成
   └─ mktemp で旧XMLを保存するファイルを作成
5. pipeline-logging-functions.shの読み込み
   └─ Write-PipelineSetVariable関数を利用可能にする
6. 旧Version.Details.xmlの取得
   └─ git show $difftarget:eng/Version.Details.xml > 一時ファイル
7. Pythonスクリプトで変更検出
   └─ get-changed-darc-deps.py で新旧XMLを比較
8. 一時ファイルの削除
   └─ rm -f で一時ファイルを削除
9. 変数プレフィックスの調整
   └─ プレフィックスがあれば末尾に"_"を追加
10. 変更された依存関係ごとにAzure変数を設定
    └─ 依存関係名の"."を"_"に置換してWrite-PipelineSetVariableを呼び出し
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C{difftarget指定あり?}
    C -->|No| D[usage表示・終了]
    C -->|Yes| E[一時ファイル作成]
    E --> F[pipeline-logging-functions.sh読込]
    F --> G[git showで旧XML取得]
    G --> H[Python3で新旧XML比較]
    H --> I[一時ファイル削除]
    I --> J{変更あり?}
    J -->|No| K[バッチ終了]
    J -->|Yes| L[依存関係名の.を_に置換]
    L --> M[Azure変数設定]
    M --> N{次の依存関係?}
    N -->|Yes| L
    N -->|No| K
```

## データベース操作仕様

データベース操作なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | パラメータエラー | difftargetが未指定 | usageを表示して終了 |
| 1 | Gitエラー | git showコマンド失敗 | set -eにより即座に終了 |
| 1 | Pythonエラー | get-changed-darc-deps.py実行失敗 | スクリプト終了 |
| 1 | ファイルエラー | pipeline-logging-functions.shが見つからない | スクリプト終了 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

スクリプトが失敗した場合、依存関係変更の検出ができないため、すべての依存関係関連ビルドが実行される可能性がある。エラーログを確認し、difftargetの正当性、Version.Details.xmlの存在、Python環境を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（トランザクション処理なし） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のXML比較（数十〜数百の依存関係） |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | 通常のスクリプト実行範囲 |

## 排他制御

同時実行の制限なし。一時ファイルはmktempで一意に生成されるため、並行実行による競合は発生しない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 変数設定ログ | 各依存関係処理時 | 設定するAzure DevOps変数名と値 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| スクリプト失敗 | 終了コード != 0 | Azure DevOpsパイプライン |
| 実行時間 | 60秒超過 | パイプライン監視 |

## 備考

- 依存関係名に含まれる"."は"_"に置換される（Azure DevOps変数名の制約対応）
- FIXME: Pythonスクリプトのエラー処理が明示的に記述されていない（コード内コメント参照）
- 出力変数は`$[ dependencies.<JobName>.outputs["<StepName>.<DependencyName>"] ]`形式でYAMLパイプラインから参照可能
- バージョンまたはSHAの変更、および片方のXMLにのみ存在する依存関係が検出対象
