# バッチ設計書 93-update-machine-certs.ps1

## 概要

本ドキュメントは、.NET Runtimeプロジェクトにおけるマシン証明書更新スクリプト（update-machine-certs.ps1）の設計仕様を定義するものである。このスクリプトはMono環境でのテスト実行前に、Pythonおよびシステムの証明書ストアを更新し、HTTPS通信を可能にする。

### 本バッチの処理概要

このバッチは、Mono環境でEmscripten（WebAssemblyコンパイラ）のインストール時に必要なHTTPS通信のための証明書更新を行う。Pythonのcertifiモジュールとpip-system-certsをインストールし、特定のウェブサイト（storage.googleapis.com、www.sqlite.org）へのSSL接続をテストして証明書が正しく設定されていることを確認する。

**業務上の目的・背景**：Mono環境やHelix CIエージェントでは、システムの証明書ストアが古い、または不完全な場合がある。Emscriptenのインストールではstorage.googleapis.comやwww.sqlite.orgからファイルをダウンロードする必要があり、HTTPS通信に失敗するとビルドが中断される。このスクリプトにより、CI環境での証明書関連エラーを事前に防止する。

**バッチの実行タイミング**：Monoビルドまたはテスト実行前の環境準備段階で実行される。特にWebAssembly（Emscripten）を使用するビルドジョブの前提条件として実行される。

**主要な処理内容**：
1. pipのアップグレード（python -m pip install --upgrade pip）
2. certifiとpip-system-certsのインストール
3. UpdateSite関数によるSSL接続テスト（storage.googleapis.com）
4. UpdateSite関数によるSSL接続テスト（www.sqlite.org）

**前後の処理との関連**：Emscriptenのインストールスクリプトより前に実行される。後続のemsdk installやWebAssemblyビルドがHTTPS通信を正常に行えるようにする前提条件バッチ。

**影響範囲**：マシン全体のPython証明書設定に影響。pip経由でのパッケージダウンロード、およびPython実行環境でのHTTPS通信全般に影響する。

## バッチ種別

環境セットアップ / 証明書管理 / テスト前処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動 |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | Mono/WebAssemblyビルドパイプラインの前提条件として |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Python | pythonコマンドが利用可能 |
| pip | Python pipが利用可能 |
| ネットワーク接続 | PyPIおよび対象ウェブサイトへのアクセスが可能 |
| PowerShell | Windows PowerShell環境 |

### 実行可否判定

常に実行される。ネットワークエラーがあっても処理は継続し、接続テストの結果をログ出力する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| PyPI | HTTPS | certifi、pip-system-certsパッケージのダウンロード元 |
| storage.googleapis.com | HTTPS | SSL接続テスト対象（Emscriptenダウンロード元） |
| www.sqlite.org | HTTPS | SSL接続テスト対象（SQLiteダウンロード元） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | pip installの結果、SSL接続テスト結果 |
| Python環境 | パッケージ | certifi、pip-system-certsのインストール |

### 出力ファイル仕様

ファイル出力なし（Python環境への証明書設定のみ）

## 処理フロー

### 処理シーケンス

```
1. pipのアップグレード
   └─ python -m pip install --upgrade pip
2. 証明書関連パッケージのインストール
   └─ pip install --upgrade certifi pip-system-certs
3. UpdateSite関数の定義
   └─ TCPクライアントでSSL接続をテストする関数
4. storage.googleapis.comへの接続テスト
   └─ ポート443でTLS接続、証明書情報を取得
5. www.sqlite.orgへの接続テスト
   └─ ポート443でTLS接続、証明書情報を取得
6. 結果出力
   └─ 成功時: 緑色で"Connection Successful"
   └─ 失敗時: 黄色でエラーメッセージ
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[pip --upgrade pip]
    B --> C[pip install certifi pip-system-certs]
    C --> D[UpdateSite: storage.googleapis.com]
    D --> E{接続成功?}
    E -->|Yes| F[緑色で成功メッセージ]
    E -->|No| G[黄色でエラーメッセージ]
    F --> H[UpdateSite: www.sqlite.org]
    G --> H
    H --> I{接続成功?}
    I -->|Yes| J[緑色で成功メッセージ]
    I -->|No| K[黄色でエラーメッセージ]
    J --> L[バッチ終了]
    K --> L
```

## データベース操作仕様

データベース操作なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | ネットワークエラー | PyPIへの接続失敗 | pip installが失敗するが処理継続 |
| N/A | SSL接続エラー | 対象サイトへの接続失敗 | 黄色でエラーメッセージを出力、処理継続 |
| N/A | 証明書エラー | TLS認証失敗 | 黄色でエラーメッセージを出力、処理継続 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

SSL接続テストが失敗した場合、後続のEmscriptenインストールが失敗する可能性が高い。ネットワーク設定、プロキシ設定、ファイアウォール設定を確認する。必要に応じて手動で証明書をインストールする。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（トランザクション処理なし） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 2件のSSL接続テスト |
| 目標処理時間 | 30秒以内 |
| メモリ使用量上限 | 通常のPython/PowerShell実行範囲 |

## 排他制御

同時実行の制限なし。ただし、同一マシンでのpip installは競合する可能性があるため、並行実行は推奨されない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| pip出力 | pip install実行時 | インストール結果 |
| 接続成功ログ | SSL接続成功時 | 緑色で"Connection Successful"、ウェブサイト名 |
| 接続失敗ログ | SSL接続失敗時 | 黄色でエラーメッセージ、ウェブサイト名、例外詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| SSL接続テスト失敗 | 1件以上 | パイプラインログ |
| pip install失敗 | 失敗発生時 | パイプラインログ |

## 備考

- このスクリプトはpypi.org/project/certifi/の情報に基づいて作成されている（コード内コメント参照）
- certifiはMozillaの証明書バンドルをPythonで利用可能にするパッケージ
- pip-system-certsはシステムの証明書ストアをpipに統合するパッケージ
- UpdateSite関数はTcpClientとSslStreamを使用してTLS接続をテストし、証明書の有効期限も取得する
- 接続テストの失敗はエラーとして扱わず、警告として処理を継続する設計
