# バッチ設計書 94-create-provisioning-profile.sh

## 概要

本ドキュメントは、.NET Runtimeプロジェクトにおけるプロビジョニングプロファイル作成スクリプト（create-provisioning-profile.sh）の設計仕様を定義するものである。このスクリプトはiOSパフォーマンステスト用の自己署名証明書とプロビジョニングプロファイルを作成し、CI環境でのiOSアプリケーション署名を可能にする。

### 本バッチの処理概要

このバッチは、iOS向けのパフォーマンステストを実行するために必要な自己署名コード署名証明書とプロビジョニングプロファイルを自動生成する。OpenSSLを使用して自己署名証明書を作成し、macOSのKeychainにインポートした後、Appleのプロビジョニングプロファイルフォーマットでmobileprovisionファイルを生成する。

**業務上の目的・背景**：iOSデバイスでアプリケーションを実行するには、Appleの署名要件を満たす必要がある。しかし、CI環境では正規のApple Developer証明書を使用するのは運用上困難であり、内部テスト用には自己署名証明書で十分である。このスクリプトにより、Helix CIエージェント上でiOSパフォーマンステストを自動実行できるようになる。

**バッチの実行タイミング**：iOSパフォーマンステストジョブの前提条件として、テスト実行前に1回実行される。

**主要な処理内容**：
1. 自己署名コード署名証明書の生成（OpenSSL使用）
2. Keychainの作成と証明書のインポート
3. Keychain設定（アクセス許可、ロック解除、タイムアウト設定）
4. プロビジョニングプロファイル用plistテンプレートの作成
5. UUIDと証明書内容でplistを更新
6. mobileprovisionファイルの生成（security cmsで署名）
7. プロビジョニングプロファイルの正規パスへのコピー

**前後の処理との関連**：iOSパフォーマンステストの前提条件として実行される。後続のテストビルドとデバイス上でのテスト実行がこのプロファイルを使用してアプリに署名する。

**影響範囲**：macOSのKeychain設定、およびホームディレクトリのProvisioning Profilesフォルダに影響。既存のSelfSign関連リソースは上書きされる。

## バッチ種別

環境セットアップ / 証明書管理 / テスト前処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動 |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | iOSパフォーマンステストパイプラインの前提条件として |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| macOS | macOS環境での実行が必須 |
| OpenSSL | opensslコマンドが利用可能 |
| security | macOS securityコマンドが利用可能 |
| plutil | macOS plutilコマンドが利用可能 |
| uuidgen | uuidgenコマンドが利用可能 |

### 実行可否判定

常に実行される。既存のKeychainやプロファイルがある場合は削除して再作成する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| なし | - | 入力データソースなし（全て内部生成） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| selfsign.keychain | Keychain | 自己署名証明書を含むKeychain |
| ~/Library/MobileDevice/Provisioning Profiles/SelfSign.mobileprovision | mobileprovision | iOSプロビジョニングプロファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | SelfSign.mobileprovision |
| 出力先 | ~/Library/MobileDevice/Provisioning Profiles/ |
| 形式 | Apple Provisioning Profile（CMS署名付きplist） |

## 処理フロー

### 処理シーケンス

```
1. 一時フォルダの作成
   └─ mktemp -d で作業ディレクトリを作成
2. OpenSSL設定ファイルの作成
   └─ コード署名用の拡張キー使用法を含む証明書設定
3. RSA秘密鍵の生成
   └─ openssl genrsa -out selfsigncert.key 2048
4. 自己署名証明書の生成
   └─ openssl req -x509 で証明書作成
5. PKCS12ファイルの生成
   └─ openssl pkcs12 -export で.p12ファイル作成
6. 既存Keychainの削除
   └─ security delete-keychain selfsign.keychain（存在する場合）
7. 新規Keychainの作成
   └─ security create-keychain で新規作成
8. 証明書のインポート
   └─ security import で.p12をKeychainにインポート
9. Keychain設定
   └─ パーティションリスト設定、ロック解除、タイムアウト設定
10. plistテンプレートの作成
    └─ プロビジョニングプロファイル用のplist構造
11. UUID生成と証明書内容の抽出
    └─ uuidgen、sed で証明書base64を抽出
12. plistの更新
    └─ plutil で UUID、DeveloperCertificatesを設定
13. Keychainをユーザー検索パスに追加
    └─ security list-keychains で検索パスに追加
14. mobileprovisionの生成
    └─ security cms -S で署名付きプロファイル作成
15. プロファイルの配置
    └─ ~/Library/MobileDevice/Provisioning Profiles/にコピー
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[一時フォルダ作成]
    B --> C[OpenSSL設定ファイル作成]
    C --> D[RSA秘密鍵生成]
    D --> E[自己署名証明書生成]
    E --> F[PKCS12ファイル生成]
    F --> G[既存Keychain削除]
    G --> H[新規Keychain作成]
    H --> I[証明書インポート]
    I --> J[Keychain設定]
    J --> K[plistテンプレート作成]
    K --> L[UUID生成・証明書抽出]
    L --> M[plist更新]
    M --> N[Keychainを検索パスに追加]
    N --> O[mobileprovision生成]
    O --> P[プロファイル配置]
    P --> Q[バッチ終了]
```

## データベース操作仕様

データベース操作なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 非0 | OpenSSLエラー | 証明書生成失敗 | set -eにより即座に終了 |
| 非0 | Keychainエラー | Keychain操作失敗 | set -eにより即座に終了 |
| 非0 | CMSエラー | mobileprovision署名失敗 | set -eにより即座に終了 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

スクリプトが失敗した場合、一時フォルダとKeychain（selfsign.keychain）が残留する可能性がある。手動でクリーンアップが必要。また、後続のiOSテストは署名エラーで失敗する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（トランザクション処理なし） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1セットの証明書・プロファイル生成 |
| 目標処理時間 | 30秒以内 |
| メモリ使用量上限 | 通常のOpenSSL/security実行範囲 |

## 排他制御

同一マシンでの並行実行は推奨されない。selfsign.keychainとSelfSign.mobileprovisionは固定名のため、並行実行時は競合が発生する。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| コマンドログ | 全コマンド実行時 | set -xにより全コマンドを標準エラー出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| スクリプト失敗 | 終了コード != 0 | Azure DevOpsパイプライン |
| 処理時間 | 60秒超過 | パイプライン監視 |

## 備考

- 証明書のCommon Name（CN）は"Apple Development: Self Sign"
- 証明書の有効期限は2100年1月1日（長期有効）
- Keychainのタイムアウトは21600秒（6時間）に設定
- プロビジョニングプロファイルのTimeToLiveは36500日（約100年）
- パスワードは"PLACEHOLDERselfsignpass"を使用（セキュリティ上重要でないテスト用証明書のため）
- 既存のselfsign.keychainは削除して再作成される（`|| true`でエラーを無視）
- extendedKeyUsage = 1.3.6.1.5.5.7.3.3（id-kp-codeSigning）を設定
