# バッチ設計書 95-breaking-change-doc.ps1

## 概要

本ドキュメントは、.NET Runtimeプロジェクトにおける破壊的変更ドキュメント生成スクリプト（breaking-change-doc.ps1）の設計仕様を定義するものである。このスクリプトはLLM（Large Language Model）を使用して、PRの内容から破壊的変更のドキュメントを自動生成し、GitHub Issueの作成やPRへのコメント追加を行う。

### 本バッチの処理概要

このバッチは、.NET RuntimeのPull Requestを分析し、破壊的変更に関する高品質なドキュメントをLLMを使用して自動生成する。GitHub CLI（gh）を使用してPR情報を収集し、複数のLLMプロバイダー（OpenAI、Anthropic、Azure OpenAI、GitHub Models、GitHub Copilot）と連携してドキュメントを作成する。生成されたドキュメントは、dotnet/docsリポジトリにIssueとして作成するか、元のPRにコメントとして追加できる。

**業務上の目的・背景**：.NET Runtimeの破壊的変更は、開発者のアプリケーションに影響を与える可能性があるため、詳細なドキュメントが必要である。しかし、手動でのドキュメント作成は時間がかかり、品質のばらつきも発生する。このツールにより、破壊的変更のドキュメント作成プロセスを自動化・標準化し、ドキュメント品質の向上とメンテナンス負担の軽減を実現する。

**バッチの実行タイミング**：手動実行。`needs-breaking-change-doc-created`ラベルが付いたPRに対して、ドキュメント担当者が随時実行する。

**主要な処理内容**：
1. 前提条件の検証（GitHub CLI認証、LLM API設定）
2. PRデータの収集（GitHub API経由で詳細情報、コメント、レビュー、関連Issue取得）
3. バージョン情報の取得（Gitタグから.NETバージョンを推定）
4. LLMプロンプトの構築（Issueテンプレート、既存例を参照）
5. LLM APIを呼び出してドキュメント生成
6. 結果の出力（Issue作成、PRコメント追加、またはドラフト保存）

**前後の処理との関連**：独立したツールとして動作。生成されたIssueはdotnet/docsリポジトリで管理され、Microsoft Docsのコンテンツとして公開される。

**影響範囲**：dotnet/runtimeリポジトリのPRコメント、dotnet/docsリポジトリのIssue作成に影響。LLM APIの利用料金にも影響する。

## バッチ種別

ドキュメント自動化 / LLM連携 / GitHub API連携

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | 手動実行（ドキュメント担当者による） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| PowerShell | Windows PowerShell環境 |
| GitHub CLI | ghコマンドがインストールされ、認証済み |
| config.ps1 | 同一ディレクトリにconfig.ps1が存在 |
| LLM API | 選択したLLMプロバイダーのAPIキーまたはツールが利用可能 |
| Gitリポジトリ | dotnet/runtimeリポジトリ内で実行 |
| powershell-yaml | GitHub Modelsプロバイダー使用時に必要 |

### 実行可否判定

前提条件チェックを実行し、未満足の場合はエラーメッセージを表示して終了。-PrNumberまたは-Queryのいずれかの指定が必須。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -CollectOnly | switch | No | $false | PRデータ収集のみ実行、ドキュメント生成なし |
| -CreateIssues | switch | No | $false | dotnet/docsにGitHub Issueを直接作成 |
| -Comment | switch | No | $false | 元PRにIssue作成リンク付きコメントを追加 |
| -Clean | switch | No | $false | 前回の出力データを削除してから開始 |
| -PrNumber | string | No | $null | 処理対象の特定PRの番号 |
| -Query | string | No | $null | PRを検索するGitHub検索クエリ |
| -Help | switch | No | $false | ヘルプを表示 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| dotnet/runtime PR | GitHub API | PRの詳細情報、コメント、レビュー、コミット |
| dotnet/docs Issue Template | GitHub API | 破壊的変更Issue用のYAMLテンプレート |
| dotnet/docs Example Issues | GitHub API | 既存の破壊的変更Issueの例 |
| Gitタグ | Git | バージョン情報の推定に使用 |
| config.ps1 | PowerShell | LLM設定、リポジトリ設定 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| artifacts/docs/breakingChanges/data/ | JSON | PR詳細データ、サマリーレポート |
| artifacts/docs/breakingChanges/issue-drafts/ | Markdown | 生成されたIssueドラフト |
| artifacts/docs/breakingChanges/comment-drafts/ | Markdown | PR用コメントドラフト |
| artifacts/docs/breakingChanges/prompts/ | YAML/Text | LLMプロンプトファイル |
| dotnet/docs Issues | GitHub Issue | -CreateIssues指定時に作成 |
| dotnet/runtime PR Comments | GitHub Comment | -Comment指定時に追加 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | pr_{number}.json, issue_pr_{number}.md, comment_pr_{number}.md |
| 出力先 | artifacts/docs/breakingChanges/配下の各ディレクトリ |
| 文字コード | UTF-8 |

## 処理フロー

### 処理シーケンス

```
1. 前提条件検証
   └─ GitHub CLI認証、LLM API設定、config.ps1存在確認
2. パラメータ検証
   └─ -PrNumberまたは-Queryの指定確認、排他条件チェック
3. 出力ディレクトリ準備
   └─ -Clean時は既存データ削除、各ディレクトリ作成
4. PR一覧取得
   └─ 単一PR指定またはクエリによる検索
5. 各PRのデータ収集（Step 1）
   └─ PR詳細、コメント、レビュー、関連Issue、コミット情報取得
   └─ バージョン情報取得（Gitタグ解析）
   └─ 既存ドキュメントIssueの確認
   └─ 個別JSONファイル保存
6. ドキュメント生成（Step 2、-CollectOnly時はスキップ）
   └─ Issueテンプレート・既存例の取得
   └─ LLMプロンプト構築
   └─ LLM API呼び出し
   └─ 結果解析・ドラフト保存
7. アクション実行
   └─ -CreateIssues: dotnet/docsにIssue作成
   └─ -Comment: PRにコメント追加
   └─ デフォルト: ドラフト保存のみ
8. サマリー出力
   └─ 処理結果、出力ファイルパスを表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B{-Help?}
    B -->|Yes| C[ヘルプ表示・終了]
    B -->|No| D[前提条件検証]
    D --> E{検証OK?}
    E -->|No| F[エラー・終了]
    E -->|Yes| G[パラメータ検証]
    G --> H{-Clean?}
    H -->|Yes| I[既存データ削除]
    H -->|No| J[ディレクトリ準備]
    I --> J
    J --> K[PR一覧取得]
    K --> L[各PRデータ収集]
    L --> M[JSONファイル保存]
    M --> N{-CollectOnly?}
    N -->|Yes| O[サマリー出力・終了]
    N -->|No| P[テンプレート・例取得]
    P --> Q[LLMプロンプト構築]
    Q --> R[LLM API呼び出し]
    R --> S[ドラフト保存]
    S --> T{-CreateIssues?}
    T -->|Yes| U[Issue作成]
    T -->|No| V{-Comment?}
    V -->|Yes| W[PRコメント追加]
    V -->|No| X[ドラフトのみ]
    U --> O
    W --> O
    X --> O
```

## データベース操作仕様

データベース操作なし（GitHub APIのみ使用）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 前提条件エラー | GitHub CLI未インストールまたは未認証 | 手順に従いGitHub CLIを設定 |
| 1 | 設定エラー | config.ps1が見つからない | config.ps1を作成 |
| 1 | API設定エラー | LLM APIキーが未設定 | 環境変数を設定 |
| 1 | パラメータエラー | -PrNumberと-Query両方未指定 | いずれかを指定 |
| 1 | パラメータエラー | 排他パラメータの同時指定 | 1つのアクションモードを選択 |
| N/A | LLMエラー | LLM API呼び出し失敗 | エラーログ出力、次のPRに継続 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（LLMエラー時はスキップして継続） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

LLM API呼び出しが失敗した場合、該当PRのドキュメント生成はスキップされ、次のPRの処理に進む。エラーログを確認し、APIキー、ネットワーク接続、API利用制限を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（トランザクション処理なし） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 最大100PR（MaxPRs設定） |
| 目標処理時間 | PR1件あたり30秒〜2分（LLM応答時間依存） |
| メモリ使用量上限 | 通常のPowerShell実行範囲 |

## 排他制御

同時実行の制限なし。ただし、同一PRに対する並行実行は重複Issue作成やコメント追加のリスクがあるため推奨されない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | ツールタイトル |
| 検証ログ | 前提条件検証時 | 各検証結果（成功/失敗） |
| 進捗ログ | PR処理時 | 処理中のPR番号、タイトル |
| LLMログ | LLM呼び出し時 | 生成中のステータス |
| 結果ログ | 各PR完了時 | 保存したファイルパス |
| サマリーログ | バッチ終了時 | 処理結果、出力ファイル一覧 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| スクリプト失敗 | 終了コード != 0 | コンソール出力 |
| LLMエラー | 発生時 | コンソール出力 |

## 備考

- 5種類のLLMプロバイダーをサポート：OpenAI、Anthropic、Azure OpenAI、GitHub Models、GitHub Copilot
- GitHub Modelsは追加認証不要（GitHub CLI認証を使用）
- RateLimiting設定によりAPI呼び出し間隔を制御（DelayBetweenCalls: 2秒、DelayBetweenIssues: 3秒）
- Limit-Text関数によりLLMへの入力テキストを適切な長さに制限（デフォルト2000文字）
- バージョン推定ロジックはGitタグのセマンティックバージョニングに基づく
- 生成されるIssueはbreaking-change、Pri1、doc-ideaラベルが付与される
- デフォルトの担当者（Assignee）はgewarren
