# バッチ設計書 96-config.ps1

## 概要

本ドキュメントは、.NET Runtimeプロジェクトにおける破壊的変更ドキュメントワークフロー設定ファイル（config.ps1）の設計仕様を定義するものである。このファイルは、breaking-change-doc.ps1スクリプトで使用される各種設定（LLM設定、GitHub設定、出力設定等）を定義する設定モジュールである。

### 本バッチの処理概要

このファイルは、破壊的変更ドキュメント生成ツール（breaking-change-doc.ps1）の動作を制御するための設定値を定義する。LLMプロバイダーの選択、APIエンドポイント、GitHubリポジトリ設定、Issue作成時のメタデータ、レート制限設定など、ツール全体の振る舞いを決定する設定を集約している。

**業務上の目的・背景**：breaking-change-doc.ps1は複数のLLMプロバイダーや環境で使用される可能性があり、これらの設定を外部ファイルに分離することで、コード変更なしに動作をカスタマイズできる。また、機密性の低い設定（APIキー以外）をバージョン管理し、チーム間で共有可能にする。

**バッチの実行タイミング**：breaking-change-doc.ps1起動時に自動的に読み込まれる。直接実行されるスクリプトではない。

**主要な処理内容**：
1. $Config変数にHashtableとして設定値を定義
2. LLM設定（プロバイダー、モデル、ベースURL）
3. GitHub設定（ソースリポジトリ、ドキュメントリポジトリ、テンプレートパス）
4. 出力設定（Issueラベル、担当者、通知先メール）
5. レート制限設定（API呼び出し間隔）

**前後の処理との関連**：breaking-change-doc.ps1の起動時に`. ".\config.ps1"`でドットソースとして読み込まれる。$Config変数がグローバルスコープで定義され、メインスクリプト内から参照される。

**影響範囲**：breaking-change-doc.ps1の全ての動作に影響。特にLLM API呼び出し、GitHub操作、生成されるIssueのメタデータに直接影響する。

## バッチ種別

設定ファイル / モジュール

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | N/A（直接実行されない） |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | breaking-change-doc.ps1からの読み込み |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| PowerShell | Windows PowerShell環境 |
| 呼び出し元 | breaking-change-doc.ps1と同一ディレクトリに配置 |

### 実行可否判定

呼び出し元スクリプトがTest-Pathで存在確認を行い、存在しない場合はエラーで終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータなし（設定値を定義するのみ） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| なし | - | 入力データソースなし |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| $Config変数 | Hashtable | グローバルスコープの設定変数 |

### 設定項目詳細

#### LLM設定

| 設定項目 | 型 | デフォルト値 | 説明 |
|---------|-----|-------------|------|
| LlmProvider | string | "github-models" | LLMプロバイダー（openai/anthropic/azure-openai/github-models/github-copilot） |
| LlmModel | string | "openai/gpt-4o" | 使用するモデル名 |
| LlmApiKey | string | $null | APIキー（環境変数優先） |
| LlmBaseUrl | string | $null | APIベースURL（Azure OpenAI用） |
| AzureApiVersion | string | "2024-02-15-preview" | Azure OpenAI APIバージョン |

#### GitHub設定

| 設定項目 | 型 | デフォルト値 | 説明 |
|---------|-----|-------------|------|
| SourceRepo | string | "dotnet/runtime" | 破壊的変更PRのソースリポジトリ |
| DocsRepo | string | "dotnet/docs" | ドキュメントIssue作成先リポジトリ |
| IssueTemplatePath | string | ".github/ISSUE_TEMPLATE/02-breaking-change.yml" | Issueテンプレートのパス |

#### 分析設定

| 設定項目 | 型 | デフォルト値 | 説明 |
|---------|-----|-------------|------|
| MaxPRs | int | 100 | 1回の実行で処理する最大PR数 |

#### 出力設定（IssueTemplate）

| 設定項目 | 型 | デフォルト値 | 説明 |
|---------|-----|-------------|------|
| Labels | string[] | @("breaking-change", "Pri1", "doc-idea") | 作成するIssueに付与するラベル |
| Assignee | string | "gewarren" | 作成するIssueの担当者 |
| NotificationEmail | string | "dotnetbcn@microsoft.com" | 通知先メールアドレス |

#### レート制限設定（RateLimiting）

| 設定項目 | 型 | デフォルト値 | 説明 |
|---------|-----|-------------|------|
| DelayBetweenCalls | int | 2 | GitHub API呼び出し間の待機秒数 |
| DelayBetweenIssues | int | 3 | Issue作成間の待機秒数 |

## 処理フロー

### 処理シーケンス

```
1. PowerShellによるファイル読み込み
   └─ breaking-change-doc.ps1からドットソースで読み込み
2. $Config変数の定義
   └─ Hashtableとして全設定値を格納
3. グローバルスコープへの展開
   └─ 呼び出し元スクリプトから$Configでアクセス可能
```

### フローチャート

```mermaid
flowchart TD
    A[breaking-change-doc.ps1起動] --> B{config.ps1存在?}
    B -->|No| C[エラー終了]
    B -->|Yes| D[ドットソースで読み込み]
    D --> E[$Config変数定義]
    E --> F[メインスクリプト継続]
```

## データベース操作仕様

データベース操作なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | ファイルエラー | config.ps1が見つからない | 呼び出し元でエラー処理 |
| N/A | 構文エラー | PowerShell構文エラー | 構文を修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | N/A |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

設定ファイルが見つからない、または構文エラーがある場合、breaking-change-doc.ps1はエラーメッセージを表示して終了する。設定ファイルを正しく配置・修正する必要がある。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | N/A（設定読み込みのみ） |
| 目標処理時間 | 瞬時（ミリ秒以下） |
| メモリ使用量上限 | 最小限 |

## 排他制御

なし

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| なし | - | ログ出力なし |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| なし | - | - |

## 備考

- このファイルは設定定義のみを行い、処理ロジックは含まない
- APIキーは環境変数で管理することを推奨（LlmApiKey = $nullのまま）
- Azure OpenAI使用時はLlmBaseUrlの設定が必須
- LlmProviderの選択肢: "openai", "anthropic", "azure-openai", "github-models", "github-copilot"
- GitHub Modelsでは多数のモデルが利用可能（openai/gpt-4o, microsoft/phi-4等）
- DelayBetweenCalls/DelayBetweenIssuesはAPI利用制限回避のための設定
- NotificationEmailはIssue作成後の通知に使用（メール送信機能は未実装）
