# バッチ設計書 97-getRefPackFolderFromArtifacts.ps1

## 概要

本ドキュメントは、.NET Runtimeプロジェクトにおける参照パックフォルダ取得スクリプト（getRefPackFolderFromArtifacts.ps1）の設計仕様を定義するものである。このスクリプトはIJW（It Just Works、C++/CLI相互運用）ビルドで使用され、ビルドアーティファクトから参照アセンブリのパスを解決する。

### 本バッチの処理概要

このバッチは、.NET Runtimeのビルドアーティファクトフォルダから参照アセンブリ（ref pack）のパスを取得する。eng/Versions.propsファイルからメジャー・マイナーバージョンを読み取り、artifacts/bin/ref/配下の対応するディレクトリパスを構築して出力する。

**業務上の目的・背景**：IJW（C++/CLI）プロジェクトはマネージドコードとネイティブコードを混在させることができ、.NETランタイムの参照アセンブリへの参照が必要である。ビルド時に正しい参照アセンブリのパスを動的に解決することで、バージョン変更時の手動修正を不要にし、ビルドの自動化と保守性を向上させる。

**バッチの実行タイミング**：IJWプロジェクトのビルド時に、MSBuild/CMakeから呼び出される。

**主要な処理内容**：
1. スクリプトパスからリポジトリルートを算出
2. eng/Versions.propsからMajorVersion、MinorVersionをXPath取得
3. 参照パックパス（artifacts/bin/ref/net{major}.{minor}）を構築
4. パスの存在確認
5. 結果を「refPackPath={path}」形式で標準出力

**前後の処理との関連**：IJWプロジェクトのCMakeLists.txtまたはMSBuildターゲットから呼び出される。出力されたパスは後続のコンパイル処理で参照アセンブリのディレクトリとして使用される。

**影響範囲**：IJWプロジェクトのコンパイル設定に影響。パスが正しく解決されない場合、コンパイルエラーが発生する。

## バッチ種別

ビルドユーティリティ / パス解決 / IJWサポート

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | ビルド時 |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | IJWプロジェクトのビルドプロセス |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| PowerShell | Windows PowerShell環境 |
| eng/Versions.props | バージョン情報を含むXMLファイルが存在 |
| artifacts/bin/ref/ | ライブラリビルドが完了し、参照アセンブリが生成済み |

### 実行可否判定

参照パックのパスが存在しない場合、エラーメッセージを出力して終了コード1で終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| eng/Versions.props | XML | MajorVersion、MinorVersionを含むバージョン定義ファイル |
| artifacts/bin/ref/ | ディレクトリ | ビルド済み参照アセンブリの格納場所 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | refPackPath={絶対パス} 形式 |
| 終了コード | int | 成功: 0、失敗: 1 |

### 出力ファイル仕様

ファイル出力なし（標準出力のみ）

## 処理フロー

### 処理シーケンス

```
1. スクリプトパスの解決
   └─ $PSScriptRootからeng/native/ijwディレクトリを特定
2. リポジトリルートの算出
   └─ 3階層上に移動（eng/native/ijw → eng/native → eng → root）
3. Versions.propsパスの構築
   └─ $repoRoot/eng/Versions.props
4. MajorVersionの取得
   └─ Select-Xml -XPath "/Project/PropertyGroup/MajorVersion"
5. MinorVersionの取得
   └─ Select-Xml -XPath "/Project/PropertyGroup/MinorVersion"
6. 参照パックパスの構築
   └─ $repoRoot/artifacts/bin/ref/net{major}.{minor}
7. パス存在確認
   └─ Test-Pathでディレクトリ存在をチェック
8. 結果出力
   └─ 存在する場合: Write-Output "refPackPath=$refPackPath"
   └─ 存在しない場合: Write-Error + exit 1
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[スクリプトパス解決]
    B --> C[リポジトリルート算出]
    C --> D[Versions.props読込]
    D --> E[MajorVersion取得]
    E --> F[MinorVersion取得]
    F --> G[参照パックパス構築]
    G --> H{パス存在?}
    H -->|Yes| I[refPackPath出力]
    H -->|No| J[エラーメッセージ出力]
    I --> K[終了コード0]
    J --> L[終了コード1]
```

## データベース操作仕様

データベース操作なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | パス不在エラー | artifacts/bin/ref/net{ver}が存在しない | build.cmd libsを実行して参照アセンブリをビルド |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

参照パックが見つからない場合のエラーメッセージには対処方法が含まれている：「Did you invoke 'build.cmd libs' to make sure that refs are built? Did the repo layout change?」。まずライブラリのビルドを実行し、それでも解決しない場合はリポジトリ構造の変更を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（トランザクション処理なし） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のパス解決 |
| 目標処理時間 | 1秒以内 |
| メモリ使用量上限 | 最小限 |

## 排他制御

なし

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 結果ログ | 正常終了時 | refPackPath={path} |
| エラーログ | 異常終了時 | エラーメッセージと対処方法 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| スクリプト失敗 | 終了コード != 0 | ビルドログ |

## 備考

- Split-Pathを3回使用してリポジトリルートを算出（eng/native/ijw → eng/native → eng → root）
- Select-Xmlを使用したXPath式でVersions.propsを解析
- 出力形式「refPackPath=...」はビルドシステム（MSBuild/CMake）での解析を想定
- 参照パックのパス形式は net{major}.{minor}（例: net9.0）
- このスクリプトはgetRefPackFolderFromSdk.ps1と対になる（ビルドアーティファクト vs SDK）
