# バッチ設計書 98-getRefPackFolderFromSdk.ps1

## 概要

本ドキュメントは、.NET Runtimeプロジェクトにおける参照パックフォルダ取得スクリプト（getRefPackFolderFromSdk.ps1）の設計仕様を定義するものである。このスクリプトはIJW（It Just Works、C++/CLI相互運用）ビルドで使用され、インストール済みの.NET SDKから参照アセンブリのパスを解決する。

### 本バッチの処理概要

このバッチは、インストール済みの.NET SDKのpacksフォルダから参照アセンブリ（ref pack）のパスを取得する。eng/common/tools.ps1を読み込んでSDKを初期化し、SDK内のMicrosoft.NETCoreSdk.BundledVersions.propsからバンドルされたランタイムバージョンを取得して、対応する参照パックのパスを特定する。

**業務上の目的・背景**：IJW（C++/CLI）プロジェクトでは、ビルドアーティファクトがまだ存在しない初期段階でも参照アセンブリへのアクセスが必要な場合がある。SDKにバンドルされた参照パックを使用することで、ライブラリのフルビルドを待たずにIJWプロジェクトのコンパイルを開始できる。

**バッチの実行タイミング**：IJWプロジェクトのビルド時に、MSBuild/CMakeから呼び出される。特にビルドアーティファクトが存在しない場合のフォールバックとして使用。

**主要な処理内容**：
1. スクリプトパスからリポジトリルートを算出
2. eng/common/tools.ps1を読み込みSDKを初期化
3. GlobalJsonからSDKバージョンを取得
4. Microsoft.NETCoreSdk.BundledVersions.propsからバンドルランタイムバージョンを取得
5. Microsoft.NETCore.App.Ref packsフォルダでSystem.Runtime.dllを検索
6. System.Runtime.dllの親フォルダを参照パックパスとして出力

**前後の処理との関連**：IJWプロジェクトのCMakeLists.txtまたはMSBuildターゲットから呼び出される。getRefPackFolderFromArtifacts.ps1の代替として、SDKベースの参照アセンブリを提供する。

**影響範囲**：IJWプロジェクトのコンパイル設定に影響。SDKの構造変更やバージョン不整合があると失敗する可能性がある。

## バッチ種別

ビルドユーティリティ / パス解決 / IJWサポート

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | ビルド時 |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | IJWプロジェクトのビルドプロセス |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| PowerShell | Windows PowerShell環境 |
| eng/common/tools.ps1 | SDK初期化スクリプトが存在 |
| global.json | SDKバージョン指定ファイルが存在 |
| .NET SDK | 指定バージョンのSDKがインストール済み |

### 実行可否判定

System.Runtime.dllが見つからない場合、エラーメッセージを出力して終了コード1で終了する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| eng/common/tools.ps1 | PowerShell | SDK初期化関数を提供 |
| global.json | JSON | $GlobalJson.tools.dotnetでSDKバージョン取得 |
| Microsoft.NETCoreSdk.BundledVersions.props | XML | バンドルされたランタイムバージョン情報 |
| packs/Microsoft.NETCore.App.Ref/ | ディレクトリ | SDK内の参照パック |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | refPackPath={絶対パス} 形式 |
| 終了コード | int | 成功: 0、失敗: 1 |

### 出力ファイル仕様

ファイル出力なし（標準出力のみ）

## 処理フロー

### 処理シーケンス

```
1. スクリプトパスの解決
   └─ $PSScriptRootからeng/native/ijwディレクトリを特定
2. リポジトリルートの算出
   └─ 3階層上に移動（eng/native/ijw → eng/native → eng → root）
3. tools.ps1の読み込み
   └─ . "$repoRoot/eng/common/tools.ps1"
4. SDK初期化
   └─ InitializeDotNetCli $true $false
5. SDKバージョン取得
   └─ $GlobalJson.tools.dotnetから取得
6. BundledVersions.propsパス構築
   └─ $dotnetRoot/sdk/$dotnetSdkVersion/Microsoft.NETCoreSdk.BundledVersions.props
7. バンドルランタイムバージョン取得
   └─ Select-Xml -XPath "BundledNETCoreAppPackageVersion"
8. 参照パックベースパス構築
   └─ $dotnetRoot/packs/Microsoft.NETCore.App.Ref/$refPackVersion/ref
9. System.Runtime.dll検索
   └─ Get-ChildItem -Recurse -Filter "System.Runtime.dll"
10. パス存在確認
    └─ System.Runtime.dllが見つかるかチェック
11. 結果出力
    └─ 見つかった場合: 親フォルダパスを出力
    └─ 見つからない場合: エラー終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[スクリプトパス解決]
    B --> C[リポジトリルート算出]
    C --> D[tools.ps1読み込み]
    D --> E[SDK初期化]
    E --> F[SDKバージョン取得]
    F --> G[BundledVersions.props読込]
    G --> H[バンドルランタイムバージョン取得]
    H --> I[参照パックパス構築]
    I --> J[System.Runtime.dll検索]
    J --> K{見つかった?}
    K -->|Yes| L[親フォルダパス出力]
    K -->|No| M[エラーメッセージ出力]
    L --> N[終了コード0]
    M --> O[終了コード1]
```

## データベース操作仕様

データベース操作なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 参照不在エラー | System.Runtime.dllが見つからない | SDKの再インストール、またはSDK構造の確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

参照アセンブリが見つからない場合のエラーメッセージには原因候補が含まれている：「Did the SDK layout change? Did the SDK change how it describes the bundled runtime version?」。SDK構造の変更やバージョン記述方法の変更を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（トランザクション処理なし） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のパス解決 |
| 目標処理時間 | 数秒以内（SDK初期化含む） |
| メモリ使用量上限 | 通常のPowerShell実行範囲 |

## 排他制御

なし

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 結果ログ | 正常終了時 | refPackPath={path} |
| エラーログ | 異常終了時 | エラーメッセージと原因候補 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| スクリプト失敗 | 終了コード != 0 | ビルドログ |

## 備考

- InitializeDotNetCli関数でSDKを初期化（第1引数: $true = インストール許可、第2引数: $false = 非対話モード）
- $GlobalJsonはtools.ps1で定義されるグローバル変数
- System.Runtime.dllの検索は、実際のTFMディレクトリ名が変動する可能性に対応するための実用的アプローチ
- コメントに記載: "The actual path to assemblies is defined by the information in data/FrameworkList.xml, but we don't need to read that."
- Split-Pathで親ディレクトリを取得し、System.Runtime.dllのフォルダを参照パックパスとして使用
- このスクリプトはgetRefPackFolderFromArtifacts.ps1と対になる（SDK vs ビルドアーティファクト）
