# バッチ設計書 99-extract-for-crossdac.ps1

## 概要

本ドキュメントは、.NET RuntimeプロジェクトにおけるクロスプラットフォームDAC抽出スクリプト（extract-for-crossdac.ps1）の設計仕様を定義するものである。このスクリプトは、クロスプラットフォームデバッグのためにLinux向けランタイムパッケージ（NuGet）からDACコンポーネントを抽出・配置する。

### 本バッチの処理概要

このバッチは、Microsoft.NETCore.App.Runtimeの各Linux向けNuGetパッケージ（linux-x64、linux-arm、linux-arm64、linux-musl-x64等）をダウンロードディレクトリから検出し、指定された抽出ディレクトリに展開する。抽出されたDACコンポーネントは、Windows上でLinuxコアダンプをデバッグする際に使用される。

**業務上の目的・背景**：.NET Runtimeのデバッグでは、DAC（Data Access Component）がメモリダンプやライブプロセスからマネージドスタックやオブジェクトを解析するために必要である。クロスプラットフォームデバッグ（例: Windows上でLinuxのコアダンプを解析）では、ターゲットプラットフォーム用のDACが必要となる。このスクリプトは、ビルドパイプラインでLinux向けランタイムパッケージからDACを抽出し、クロスDAC開発やテストに使用可能にする。

**バッチの実行タイミング**：クロスDACビルドパイプラインの一部として実行される。Linux向けランタイムパッケージがビルド・ダウンロードされた後に実行される。

**主要な処理内容**：
1. コマンドライン引数からダウンロードディレクトリと抽出先ディレクトリを受け取る
2. ダウンロードディレクトリを再帰的に検索し、.nupkgファイルを列挙
3. ファイル名パターンマッチングでLinuxランタイムパッケージを識別
4. ZipFileクラスでNuGetパッケージを展開
5. パッケージIDとバージョンに基づくディレクトリ構造で配置

**前後の処理との関連**：Linux向けランタイムビルドの後、およびクロスDACコンパイルの前に実行される。抽出されたDACファイルは、クロスDACのビルドとテストで使用される。

**影響範囲**：指定された抽出ディレクトリに新しいファイルが作成される。既存のファイルは上書きされる可能性がある。

## バッチ種別

ビルドユーティリティ / パッケージ抽出 / クロスプラットフォームデバッグサポート

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | ビルドパイプライン実行時 |
| 実行時刻 | N/A |
| 実行曜日 | N/A |
| 実行日 | N/A |
| トリガー | クロスDACビルドパイプライン |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| PowerShell | Windows PowerShell環境 |
| System.IO.Compression.FileSystem | .NET Frameworkの圧縮ライブラリ |
| ダウンロードディレクトリ | Linux向けランタイムNuGetパッケージが存在 |

### 実行可否判定

パラメータが必須。ダウンロードディレクトリにマッチするパッケージがない場合、警告を出力して正常終了。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -DownloadDirectory | string | Yes | なし | NuGetパッケージのダウンロードディレクトリ |
| -ExtractDirectory | string | Yes | なし | 抽出先ディレクトリ |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| *.nupkg | NuGet Package | Microsoft.NETCore.App.Runtime.linux-*パッケージ |

### 対象パッケージパターン

以下の正規表現パターンにマッチするパッケージが処理対象:
```
^(?<id>Microsoft.NETCore.App.Runtime.linux(-musl)?-((arm(64)?)|x64)).(?<ver>.+).nupkg$
```

マッチするパッケージ例:
- Microsoft.NETCore.App.Runtime.linux-x64.{version}.nupkg
- Microsoft.NETCore.App.Runtime.linux-arm.{version}.nupkg
- Microsoft.NETCore.App.Runtime.linux-arm64.{version}.nupkg
- Microsoft.NETCore.App.Runtime.linux-musl-x64.{version}.nupkg
- Microsoft.NETCore.App.Runtime.linux-musl-arm.{version}.nupkg
- Microsoft.NETCore.App.Runtime.linux-musl-arm64.{version}.nupkg

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| {ExtractDirectory}/{package-id-lowercase}/{version}/ | ディレクトリ | 抽出されたパッケージ内容 |
| 標準出力 | テキスト | 処理状況のログ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ディレクトリ構造 | {ExtractDirectory}/{id.ToLowerInvariant()}/{version}/ |
| 内容 | NuGetパッケージの完全な内容（lib、runtimes、content等） |

## 処理フロー

### 処理シーケンス

```
1. 圧縮ライブラリの読み込み
   └─ Add-Type -Assembly 'System.IO.Compression.FileSystem'
2. ダウンロードディレクトリのログ出力
   └─ "Looking for packages under {path}"
3. .nupkgファイルの再帰検索
   └─ Get-ChildItem -Recurse -Filter '*.nupkg'
4. 各パッケージの処理
   └─ ファイル名のログ出力
5. パターンマッチング
   └─ 正規表現でLinuxランタイムパッケージを識別
6. パッケージID・バージョンの抽出
   └─ $matches['id']、$matches['ver']
7. 抽出先パスの構築
   └─ {ExtractDirectory}/{id.ToLowerInvariant()}/{version}
8. パッケージの展開
   └─ ZipFile.ExtractToDirectory
9. 非マッチパッケージのスキップ
   └─ "Skipping non-runtime pack: {name}"
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[圧縮ライブラリ読み込み]
    B --> C[ダウンロードディレクトリログ出力]
    C --> D[.nupkgファイル検索]
    D --> E{ファイルあり?}
    E -->|No| F[バッチ終了]
    E -->|Yes| G[次のファイルを取得]
    G --> H[パッケージログ出力]
    H --> I{パターンマッチ?}
    I -->|Yes| J[ID・バージョン抽出]
    I -->|No| K[スキップログ出力]
    J --> L[抽出先パス構築]
    L --> M[ZipFile展開]
    M --> N{次のファイル?}
    K --> N
    N -->|Yes| G
    N -->|No| F
```

## データベース操作仕様

データベース操作なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| N/A | 展開エラー | ZipFile.ExtractToDirectoryが失敗 | ディスク容量、パーミッション確認 |
| N/A | パスエラー | 無効なパス指定 | パラメータを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

展開に失敗した場合、PowerShellの例外がスローされる。抽出先ディレクトリの存在、書き込み権限、ディスク容量を確認する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（トランザクション処理なし） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 最大6パッケージ（Linuxアーキテクチャ数） |
| 目標処理時間 | パッケージあたり数秒（パッケージサイズ依存） |
| メモリ使用量上限 | 圧縮展開に十分なメモリ |

## 排他制御

同一抽出ディレクトリへの並行書き込みは推奨されない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | 処理開始時 | "Looking for packages under {path}" |
| 検出ログ | パッケージ検出時 | "Found Package: {fullpath}" |
| 抽出ログ | 展開時 | "Extracting Package: {id} {ver} to {path}" |
| スキップログ | 非マッチ時 | "Skipping non-runtime pack: {name}" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| スクリプト失敗 | 例外発生時 | パイプラインログ |

## 備考

- CmdletBindingが指定されており、共通パラメータ（-Verbose等）が使用可能
- パッケージIDは小文字化して抽出先パスに使用（ToLowerInvariant）
- NuGetパッケージはZIPフォーマットであり、System.IO.Compression.ZipFileで展開可能
- クロスDACはWindows上でLinuxコアダンプを解析するために使用される重要なコンポーネント
- 対象パターンに含まれない他のLinuxディストリビューション（Alpine以外のmusl等）は将来的に追加される可能性がある
