---
generated_at: 2026-01-30 13:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：11-dotnet-install.sh.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **目標処理時間（1-5分）**：実測データなし
  2. **リトライ間隔の指数バックオフ計算式**：コード確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/dotnet-install.sh` 行1-95
- E-02: `eng/common/tools.sh` 行1-600（特に行52-270のInstallDotNet関数）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行12

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バージョン引数のデフォルト値はLatest | E-01 行16 | ○ |
| C-02 | アーキテクチャ引数のデフォルト値は空（自動検出） | E-01 行17 | ○ |
| C-03 | ランタイム引数のデフォルト値はdotnet | E-01 行18 | ○ |
| C-04 | CPUアーキテクチャはuname -mで検出 | E-01 行53 | ○ |
| C-05 | arm64/aarch64をarm64として認識 | E-01 行55-61 | ○ |
| C-06 | 32bit OSが64bit CPUで動作する場合の検出 | E-01 行57-59 | ○ |
| C-07 | loongarch64アーキテクチャ対応 | E-01 行62-64 | ○ |
| C-08 | amd64/x86_64をx64として認識 | E-01 行65-67 | ○ |
| C-09 | armv*lをarmとして認識 | E-01 行68-70 | ○ |
| C-10 | i[3-6]86をx86として認識 | E-01 行71-73 | ○ |
| C-11 | riscv64アーキテクチャ対応 | E-01 行74-76 | ○ |
| C-12 | 不明CPUはx64として扱う | E-01 行77-80 | ○ |
| C-13 | dotnetRootは${repo_root}.dotnet | E-01 行83 | ○ |
| C-14 | 異なるアーキテクチャ指定時はサブディレクトリ使用 | E-01 行84-86 | ○ |
| C-15 | InstallDotNet関数を呼び出し | E-01 行88 | ○ |
| C-16 | tools.shをソース読み込み | E-01 行14 | ○ |
| C-17 | 不正引数でエラー終了（exit code 1） | E-01 行45-47 | ○ |
| C-18 | インストール失敗時にWrite-PipelineTelemetryError出力 | E-01 行90 | ○ |
| C-19 | リトライ回数は5回 | E-02 行273-274 | ○ |
| C-20 | リトライ間隔は指数バックオフ | E-02 行285 | ○ |
| C-21 | シンボリックリンク解決処理 | E-01 行3-12 | ○ |
| C-22 | runtimesourcefeedパラメータ対応 | E-01 行36-39 | ○ |
| C-23 | runtimesourcefeedkeyパラメータ対応 | E-01 行40-43 | ○ |
| C-24 | 目標処理時間1-5分 | **根拠なし** | △ |
| C-25 | リトライ間隔計算式（3^n - 1 秒） | E-02 行285 | ○ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間の根拠となる実測データまたは要件定義書が存在しない
  - 候補：パフォーマンステスト結果 / CI実行ログ / 要件定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード解析による主張は高い信頼性
- 1: 中リスク - パフォーマンス要件は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] 目標処理時間（1-5分）が実際の運用要件と整合しているか確認
- [ ] リトライ仕様がCI/CD環境のタイムアウト設定と整合しているか確認
- [ ] 対応アーキテクチャ一覧が最新のサポート要件と一致しているか確認
