---
generated_at: 2026-01-30 13:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：12-dotnet-install.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間（1-5分）**：実測データなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/common/dotnet-install.ps1` 行1-29
- E-02: `eng/common/tools.ps1`（参照先として確認）
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行13

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | verbosityパラメータのデフォルト値はminimal | E-01 行3 | ○ |
| C-02 | architectureパラメータのデフォルト値は空文字列 | E-01 行4 | ○ |
| C-03 | versionパラメータのデフォルト値はLatest | E-01 行5 | ○ |
| C-04 | runtimeパラメータのデフォルト値はdotnet | E-01 行6 | ○ |
| C-05 | RuntimeSourceFeedパラメータのデフォルト値は空文字列 | E-01 行7 | ○ |
| C-06 | RuntimeSourceFeedKeyパラメータのデフォルト値は空文字列 | E-01 行8 | ○ |
| C-07 | tools.ps1をドットソースで読み込み | E-01 行11 | ○ |
| C-08 | dotnetRootはRepoRoot\.dotnetで構築 | E-01 行13 | ○ |
| C-09 | x86アーキテクチャ指定時はx86サブディレクトリを使用 | E-01 行17-18 | ○ |
| C-10 | InstallDotNet関数を呼び出し | E-01 行20 | ○ |
| C-11 | try-catchで例外処理 | E-01 行16, 22 | ○ |
| C-12 | 例外時にスタックトレースを出力 | E-01 行23 | ○ |
| C-13 | 例外時にWrite-PipelineTelemetryErrorを呼び出し | E-01 行24 | ○ |
| C-14 | 例外時にExitWithExitCode 1で終了 | E-01 行25 | ○ |
| C-15 | 正常終了時にExitWithExitCode 0で終了 | E-01 行28 | ○ |
| C-16 | CmdletBindingでPositionalBinding=$false | E-01 行1 | ○ |
| C-17 | アーキテクチャ判定でTrim()を使用 | E-01 行17 | ○ |
| C-18 | 目標処理時間1-5分 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間の根拠となる実測データまたは要件定義書が存在しない
  - 候補：パフォーマンステスト結果 / CI実行ログ / 要件定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード解析による主張は高い信頼性
- 1: 中リスク - パフォーマンス要件は推定値

## 6) レビュアーチェックリスト（最小）
- [ ] 目標処理時間（1-5分）が実際の運用要件と整合しているか確認
- [ ] tools.ps1のInstallDotNet関数のリトライ仕様を確認
- [ ] PowerShell実行ポリシー要件が運用環境と整合しているか確認
