---
generated_at: 2026-01-30 13:20:00
metrics:
  claims_total: 35
  claims_with_evidence: 34
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：15-RunnerTemplate.sh.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：34 / 35、根拠なし：1
- 優先レビュー（高）
  1. **Helixリトライ仕様**：Helix側の設定に依存し、本スクリプトからは確認不可

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/testing/RunnerTemplate.sh` 行1-260
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行16

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | --runtime-path/-rパラメータは必須 | E-01 行42-46 | ○ |
| C-02 | --rsp-fileパラメータはオプション | E-01 行27-31 | ○ |
| C-03 | --help/-hでヘルプ表示 | E-01 行20-23 | ○ |
| C-04 | SIGINT(130)はCtrl-C、タイムアウト | E-01 行49 | ○ |
| C-05 | SIGQUIT(131)はCtrl-\、コアダンプ | E-01 行50 | ○ |
| C-06 | SIGILL(132)は不正命令 | E-01 行51 | ○ |
| C-07 | SIGTRAP(133)はブレークポイント | E-01 行52 | ○ |
| C-08 | SIGABRT(134)はabort()呼び出し | E-01 行53 | ○ |
| C-09 | SIGKILL(137)はOOMまたは明示的kill | E-01 行56 | ○ |
| C-10 | SIGSEGV(139)は不正メモリアクセス | E-01 行57 | ○ |
| C-11 | Darwinでは/coresが空の場合ulimit -c 0 | E-01 行103-116 | ○ |
| C-12 | DOTNET_DbgEnableMiniDump=1を設定 | E-01 行118 | ○ |
| C-13 | DOTNET_EnableCrashReport=1を設定 | E-01 行119 | ○ |
| C-14 | DOTNET_DbgMiniDumpNameを設定 | E-01 行120 | ○ |
| C-15 | SuperPMI設定はspmi_enable_collection変数で制御 | E-01 行124 | ○ |
| C-16 | SuperPMIはspmi_collect_dirが必要 | E-01 行127-129 | ○ |
| C-17 | SuperPMIはspmi_core_rootが必要 | E-01 行130-132 | ○ |
| C-18 | Darwin用拡張子はdylib | E-01 行137-139 | ○ |
| C-19 | [[SetCommands]]プレースホルダー | E-01 行161 | ○ |
| C-20 | [[SetCommandsEcho]]プレースホルダー | E-01 行160 | ○ |
| C-21 | [[RunCommands]]プレースホルダー | E-01 行171 | ○ |
| C-22 | [[RunCommandsEcho]]プレースホルダー | E-01 行167 | ○ |
| C-23 | testResults.xmlの存在確認 | E-01 行173-175 | ○ |
| C-24 | Linuxでcore.*ファイルを検索 | E-01 行207-213 | ○ |
| C-25 | コアダンプをHELIX_DUMP_FOLDERに移動 | E-01 行61-72 | ○ |
| C-26 | XUnitLogCheckerの実行制御 | E-01 行229-245 | ○ |
| C-27 | __IsXUnitLogCheckerSupported環境変数で有効/無効制御 | E-01 行231-234 | ○ |
| C-28 | XUnitLogCheckerはHELIX_CORRELATION_PAYLOADから実行 | E-01 行82 | ○ |
| C-29 | テスト失敗(1)+結果ありでHelix環境は終了コード0 | E-01 行251-255 | ○ |
| C-30 | 終了コードの説明を出力 | E-01 行179-181 | ○ |
| C-31 | dmesgログ出力（異常終了時） | E-01 行223-225 | ○ |
| C-32 | ulimit -c値を出力（テスト失敗時） | E-01 行187-189 | ○ |
| C-33 | /proc/sys/kernel/core_pattern出力 | E-01 行192 | ○ |
| C-34 | /proc/sys/kernel/core_uses_pid出力 | E-01 行193 | ○ |
| C-35 | Helixリトライはスクリプト外で管理 | **根拠なし（Helix設定依存）** | △ |

## 4) 不足情報（Unknown / Missing）
- Helixのリトライ仕様はHelix SDKおよびAzure DevOps設定に依存
  - 候補：Helix SDK ドキュメント / Azure DevOps パイプライン定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード解析による主張は高い信頼性
- 1: 中リスク - Helix連携部分は外部システム依存

## 6) レビュアーチェックリスト（最小）
- [ ] プレースホルダー（[[RunCommands]]等）がビルド時に正しく置換されることを確認
- [ ] XUnitLogCheckerの動作要件を確認
- [ ] macOSでのコアダンプ無効化がCI環境で適切か確認
- [ ] シグナル番号とメッセージの対応が正確か確認
