---
generated_at: 2026-01-30 13:25:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：16-RunnerTemplate.cmd.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **Helixリトライ仕様**：Helix側の設定に依存し、本スクリプトからは確認不可

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/testing/RunnerTemplate.cmd` 行1-142
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行17

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ENABLEEXTENSIONS有効化 | E-01 行2 | ○ |
| C-02 | ENABLEDELAYEDEXPANSION有効化 | E-01 行2 | ○ |
| C-03 | EXECUTION_DIRを%~dp0で設定 | E-01 行4 | ○ |
| C-04 | --help/-hでヘルプ表示 | E-01 行12-16 | ○ |
| C-05 | --runtime-path/-rパラメータ処理 | E-01 行18-25 | ○ |
| C-06 | --rsp-fileパラメータ処理 | E-01 行27-31 | ○ |
| C-07 | RSP_FILEは@プレフィックス付き | E-01 行29 | ○ |
| C-08 | 不正引数でusage表示 | E-01 行33-36 | ○ |
| C-09 | HAS_TEST_RESULTS初期値は0 | E-01 行45 | ○ |
| C-10 | SuperPMI設定はspmi_enable_collection変数で制御 | E-01 行49 | ○ |
| C-11 | SuperPMIはspmi_collect_dirが必要 | E-01 行52 | ○ |
| C-12 | SuperPMIはspmi_core_rootが必要 | E-01 行53 | ○ |
| C-13 | SuperPMIShimPath設定 | E-01 行56 | ○ |
| C-14 | DOTNET_JitPath設定 | E-01 行59 | ○ |
| C-15 | [[SetCommands]]プレースホルダー | E-01 行69 | ○ |
| C-16 | [[SetCommandsEcho]]プレースホルダー | E-01 行68 | ○ |
| C-17 | [[RunCommands]]プレースホルダー | E-01 行80 | ○ |
| C-18 | [[RunCommandsEcho]]プレースホルダー | E-01 行75 | ○ |
| C-19 | テスト実行時@echo on | E-01 行79 | ○ |
| C-20 | 終了コードを_exit_codeに保存 | E-01 行81 | ○ |
| C-21 | testResults.xml存在確認 | E-01 行83-85 | ○ |
| C-22 | テスト失敗(1)+結果あり+Helixで終了コード0 | E-01 行90-96 | ○ |
| C-23 | XUnitLogCheckerパス設定 | E-01 行109 | ○ |
| C-24 | XUnitLogChecker実行 | E-01 行119 | ○ |
| C-25 | __IsXUnitLogCheckerSupported変数で制御 | E-01 行101-103 | ○ |
| C-26 | XUnitLogChecker終了コードでテスト終了コード更新 | E-01 行124-126 | ○ |
| C-27 | usageでパラメータ説明表示 | E-01 行135-141 | ○ |
| C-28 | Helixリトライはスクリプト外で管理 | **根拠なし（Helix設定依存）** | △ |

## 4) 不足情報（Unknown / Missing）
- Helixのリトライ仕様はHelix SDKおよびAzure DevOps設定に依存
  - 候補：Helix SDK ドキュメント / Azure DevOps パイプライン定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード解析による主張は高い信頼性
- 1: 中リスク - Helix連携部分は外部システム依存

## 6) レビュアーチェックリスト（最小）
- [ ] プレースホルダー（[[RunCommands]]等）がビルド時に正しく置換されることを確認
- [ ] XUnitLogChecker.exeの存在確認ロジックが適切か確認
- [ ] SuperPMI設定のDLLパスが正しいか確認
- [ ] ENABLEDELAYEDEXPANSION使用箇所を確認
