---
generated_at: 2026-01-30 13:35:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-AndroidRunnerTemplate.cmd.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、特に優先度の高いレビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/testing/AndroidRunnerTemplate.cmd` 行1-48
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行19

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ECHO OFF設定 | E-01 行1 | ○ |
| C-02 | enabledelayedexpansion有効化 | E-01 行2 | ○ |
| C-03 | EXECUTION_DIRは%~dp0で取得 | E-01 行4 | ○ |
| C-04 | ASSEMBLY_NAMEは%1 | E-01 行5 | ○ |
| C-05 | TARGET_ARCHは%2 | E-01 行6 | ○ |
| C-06 | TARGET_OSは%3 | E-01 行7 | ○ |
| C-07 | TEST_NAMEは%4 | E-01 行8 | ○ |
| C-08 | REPO_ROOTは%5 | E-01 行9 | ○ |
| C-09 | Arg_Loopで%6以降を__AdditionalArgsに追加 | E-01 行11-13 | ○ |
| C-10 | XHARNESS_OUTはxharness-outputディレクトリ | E-01 行16 | ○ |
| C-11 | cd %EXECUTION_DIR%で移動 | E-01 行18 | ○ |
| C-12 | MKDIR androidtests.lockでロック取得 | E-01 行21 | ○ |
| C-13 | ロック取得失敗時ping -n 6で約6秒待機 | E-01 行23 | ○ |
| C-14 | 2>NULでエラー出力抑制 | E-01 行21 | ○ |
| C-15 | XHARNESS_CLI_PATH設定時はdotnet.cmd exec | E-01 行27-30 | ○ |
| C-16 | XHARNESS_CLI_PATH未設定時はdotnet.cmd xharness | E-01 行32 | ○ |
| C-17 | REPO_ROOTからdotnet.cmdパスを構築 | E-01 行30, 32 | ○ |
| C-18 | android testコマンド実行 | E-01 行35 | ○ |
| C-19 | --instrumentation="net.dot.MonoRunner" | E-01 行35 | ○ |
| C-20 | --package-name="net.dot.%ASSEMBLY_NAME%" | E-01 行35 | ○ |
| C-21 | --app="%EXECUTION_DIR%bin\%TEST_NAME%.apk" | E-01 行35 | ○ |
| C-22 | --timeout=1800 | E-01 行35 | ○ |
| C-23 | EXIT_CODEに%ERRORLEVEL%保存 | E-01 行37 | ○ |
| C-24 | RMDIR /Q androidtests.lockでロック解放 | E-01 行41 | ○ |
| C-25 | NORMALIZEPATH関数定義（未使用） | E-01 行44-47 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張がコードから直接確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に明確な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] XHarnessのバージョン要件を確認
- [ ] REPO_ROOT引数がdotnet.cmdへの正しいパスを提供しているか確認
- [ ] APKファイルのパス（bin\%TEST_NAME%.apk）がビルド設定と一致しているか確認
- [ ] NORMALIZEPATH関数の使用予定を確認（デッドコードの可能性）
