---
generated_at: 2026-01-30 13:40:00
metrics:
  claims_total: 32
  claims_with_evidence: 32
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-AppleRunnerTemplate.sh.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：32 / 32、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、特に優先度の高いレビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/testing/AppleRunnerTemplate.sh` 行1-78
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行20

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ローカル開発用スクリプト（CIではHelix SDK使用） | E-01 行3（コメント） | ○ |
| C-02 | EXECUTION_DIRはdirname $0で取得 | E-01 行5 | ○ |
| C-03 | XHARNESS_CMDデフォルトは"test" | E-01 行11 | ○ |
| C-04 | $6存在時はXHARNESS_CMD="run" | E-01 行16 | ○ |
| C-05 | Debug以外の構成はReleaseに正規化 | E-01 行20 | ○ |
| C-06 | maccatalystターゲット設定 | E-01 行22 | ○ |
| C-07 | iossimulator+x86→ios-simulator-32 | E-01 行24 | ○ |
| C-08 | iossimulator+x64→ios-simulator-64 | E-01 行25 | ○ |
| C-09 | iossimulator+arm64→ios-simulator-64 | E-01 行26 | ○ |
| C-10 | ios+arm→ios-device | E-01 行27 | ○ |
| C-11 | ios+arm64→ios-device | E-01 行28 | ○ |
| C-12 | tvossimulator+x64→tvos-simulator | E-01 行30 | ○ |
| C-13 | tvossimulator+arm64→tvos-simulator | E-01 行31 | ○ |
| C-14 | tvos+arm64→tvos-device | E-01 行32 | ○ |
| C-15 | ios-simulator-*のSCHEME_SDK設定 | E-01 行35 | ○ |
| C-16 | tvos-simulatorのSCHEME_SDK設定 | E-01 行36 | ○ |
| C-17 | ios-deviceのSCHEME_SDK設定 | E-01 行37 | ○ |
| C-18 | tvos-deviceのSCHEME_SDK設定 | E-01 行38 | ○ |
| C-19 | maccatalystのSCHEME_SDK設定 | E-01 行39 | ○ |
| C-20 | 実機ターゲットでSIGNAL_APP_END設定 | E-01 行41 | ○ |
| C-21 | XCODE_PATHはxcode-select -pから取得 | E-01 行13 | ○ |
| C-22 | cd $EXECUTION_DIRで移動 | E-01 行43 | ○ |
| C-23 | /tmp/appletests.lockでセマフォ実装 | E-01 行46-55 | ○ |
| C-24 | ロック取得失敗時5秒sleep | E-01 行53 | ○ |
| C-25 | trap 0でロックディレクトリ削除 | E-01 行50 | ○ |
| C-26 | XHARNESS_CLI_PATH設定時はdotnet exec | E-01 行57-59 | ○ |
| C-27 | XHARNESS_CLI_PATH未設定時はdotnet xharness | E-01 行62 | ○ |
| C-28 | apple $XHARNESS_CMDコマンド実行 | E-01 行65 | ○ |
| C-29 | --app引数にSCHEME_SDK含むパス | E-01 行66 | ○ |
| C-30 | --targets引数 | E-01 行67 | ○ |
| C-31 | --xcode引数 | E-01 行68 | ○ |
| C-32 | XHarness artifacts表示 | E-01 行75 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。すべての主張がコードから直接確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に明確な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] XHarnessのバージョン要件を確認
- [ ] ターゲットマッピング（iossimulator等→ios-simulator-64等）が正しいか確認
- [ ] SCHEME_SDK命名規則がXcodeビルド出力と一致しているか確認
- [ ] --signal-app-endの実機での動作を確認
