---
generated_at: 2026-01-30 13:45:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：20-AppleHelixRunnerTemplate.sh.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **tests.mobile.targetsでの[[RunCommands]]定義**：外部ファイル参照が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/testing/AppleHelixRunnerTemplate.sh` 行1-5
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行21

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | XHARNESS_EXECUTION_DIRをcd+pwdで決定 | E-01 行1 | ○ |
| C-02 | cd --により特殊文字対応 | E-01 行1 | ○ |
| C-03 | >/dev/null 2>&1でcd出力抑制 | E-01 行1 | ○ |
| C-04 | pwd -Pでシンボリックリンク解決 | E-01 行1 | ○ |
| C-05 | XHARNESS_OUT設定 | E-01 行2 | ○ |
| C-06 | XHARNESS_OUTはxharness-outputディレクトリ | E-01 行2 | ○ |
| C-07 | [[RunCommands]]プレースホルダー | E-01 行5 | ○ |
| C-08 | コメントでRunCommands定義元を記載 | E-01 行4（コメント） | ○ |
| C-09 | シンプルなテンプレート構造（5行） | E-01 全体 | ○ |
| C-10 | 排他制御なし | E-01 全体（ロック処理不在） | ○ |
| C-11 | XHarnessパス決定ロジックなし | E-01 全体（パス決定処理不在） | ○ |
| C-12 | tests.mobile.targetsでRunCommands定義 | **根拠なし（外部ファイル参照必要）** | △ |

## 4) 不足情報（Unknown / Missing）
- tests.mobile.targetsでの[[RunCommands]]定義内容の確認が必要
  - 候補：eng/testing/tests.mobile.targets / Directory.Build.targets

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - スクリプト自体はシンプルで明確
- 1: 中リスク - [[RunCommands]]の実際の内容は外部ファイルに依存

## 6) レビュアーチェックリスト（最小）
- [ ] tests.mobile.targetsでのRunCommands定義を確認
- [ ] [[RunCommands]]がビルド時に正しく置換されることを確認
- [ ] Helix環境でのXHarnessパス設定を確認
- [ ] テンプレート置換メカニズムの動作を確認
