---
generated_at: 2026-01-30 10:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：21-WasmRunnerTemplate.sh.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **Helixタイムアウト設定**：具体的な設定値の根拠なし
  2. **ブラウザプリインストール情報**：Helix環境の詳細設定は外部情報

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/testing/WasmRunnerTemplate.sh` (ソースコード)
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (バッチ一覧)
- E-03: コメント「SetCommands defined in eng\testing\tests.wasm.targets」(行3-4)
- E-04: コメント「RunCommands defined in eng\testing\tests.wasm.targets」(行129, 135)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | XHarnessテストフレームワークを使用 | E-01 行20-26, 48 | ○ |
| C-02 | V8エンジンがデフォルト | E-01 行39-41 | ○ |
| C-03 | Chrome/Firefoxブラウザテストをサポート | E-01 行29-35, 54-65 | ○ |
| C-04 | SCENARIOパラメータでテスト種別を判定 | E-01 行10-12, 29-35 | ○ |
| C-05 | AOTビルド機能を提供（_buildAOTFunc） | E-01 行92-121 | ○ |
| C-06 | OOMエラーコード9200を返す | E-01 行108-109 | ○ |
| C-07 | AOTビルド失敗時にエラーコード9100を返す | E-01 行116-117 | ○ |
| C-08 | jsvuパス設定（$HOME/.jsvu/bin） | E-01 行7 | ○ |
| C-09 | XHARNESS_CLI_PATHで直接DLL実行可能 | E-01 行20-26 | ○ |
| C-10 | HELIX_WORKITEM_UPLOAD_ROOTで出力先変更 | E-01 行14-18 | ○ |
| C-11 | test-browserコマンドをブラウザテストで使用 | E-01 行29-35 | ○ |
| C-12 | Firefoxでprivate-windowオプション使用 | E-01 行62-64 | ○ |
| C-13 | V8でstack-trace-limit=1000設定 | E-01 行47-51 | ○ |
| C-14 | V8で--moduleオプション追加 | E-01 行49-51 | ○ |
| C-15 | tests.wasm.targetsでSetCommands定義 | E-03 | ○ |
| C-16 | tests.wasm.targetsでRunCommands定義 | E-04 | ○ |
| C-17 | PREPEND_PATHでPATH追加可能 | E-01 行72-74 | ○ |
| C-18 | XUNIT_RANDOM_ORDER_SEED対応 | E-01 行76-78 | ○ |
| C-19 | 再現コマンドをechoで出力 | E-01 行127-132 | ○ |
| C-20 | dmesgで最終20行を取得（OOM検出） | E-01 行105-106 | ○ |
| C-21 | binlogでパフォーマンスサマリー出力 | E-01 行101-102 | ○ |
| C-22 | XHarnessアーティファクトパスを最後に出力 | E-01 行140 | ○ |
| C-23 | MAIN_JSのデフォルトはtest-main.js | E-01 行42-44 | ○ |
| C-24 | Helixタイムアウトは通常30分以内 | **根拠なし** | △ |
| C-25 | Chrome/FirefoxがHelix環境にプリインストール | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Helixタイムアウト設定の具体値は本スクリプト内に記載なし
  - 候補：Helix設定ファイル / Azure DevOps Pipeline定義 / tests.wasm.targets
- Helix環境のブラウザインストール情報
  - 候補：Helixインフラドキュメント / CI設定ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - スクリプトの主要機能はすべてソースコードから確認可能
- 1: 中リスク - Helix環境依存の設定（タイムアウト、ブラウザ）は環境固有
- 0: 低リスク - エラーハンドリングはソースコードに明記

## 6) レビュアーチェックリスト（最小）
- [ ] tests.wasm.targetsの実装とテンプレートプレースホルダーの対応を確認
- [ ] Helix環境でのタイムアウト設定が適切か確認
- [ ] V8/Chrome/Firefoxの各シナリオが正しく動作するか確認
