---
generated_at: 2026-01-30 10:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：22-WasmRunnerTemplate.cmd.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **Helixタイムアウト設定**：具体的な設定値の根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/testing/WasmRunnerTemplate.cmd` (ソースコード)
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (バッチ一覧)
- E-03: コメント「SetCommands defined in eng\testing\tests.wasm.targets」(行4-5)
- E-04: コメント「RunCommands defined in eng\testing\tests.wasm.targets」(行101, 107)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | XHarnessテストフレームワークを使用 | E-01 行21-27 | ○ |
| C-02 | V8エンジンがデフォルト | E-01 行42-44 | ○ |
| C-03 | Chrome/Firefoxブラウザテストをサポート | E-01 行30-38, 57-76 | ○ |
| C-04 | SCENARIOパラメータでテスト種別を判定 | E-01 行9-11, 29-38 | ○ |
| C-05 | tests.wasm.targetsでSetCommands定義 | E-03 | ○ |
| C-06 | tests.wasm.targetsでRunCommands定義 | E-04 | ○ |
| C-07 | HELIX_CORRELATION_PAYLOADからブラウザパス解決 | E-01 行58-59, 66-67 | ○ |
| C-08 | Chrome用にchrome-win\chrome.exeパス設定 | E-01 行59 | ○ |
| C-09 | Firefox用にfirefox\firefox.exeパス設定 | E-01 行67 | ○ |
| C-10 | Chromeで--disable-gpuオプション使用 | E-01 行62 | ○ |
| C-11 | ChromeでpageLoadStrategy=none設定 | E-01 行62 | ○ |
| C-12 | Firefoxで-private-windowオプション使用 | E-01 行73 | ○ |
| C-13 | V8でstack-trace-limit=1000設定 | E-01 行50 | ○ |
| C-14 | V8で--moduleオプション追加 | E-01 行52-54 | ○ |
| C-15 | XHARNESS_CLI_PATHで直接DLL実行可能 | E-01 行21-27 | ○ |
| C-16 | HELIX_WORKITEM_UPLOAD_ROOTで出力先変更 | E-01 行15-19 | ○ |
| C-17 | PREPEND_PATHでPATH追加可能 | E-01 行13, 37-39 | ○ |
| C-18 | XUNIT_RANDOM_ORDER_SEED対応 | E-01 行83-85 | ○ |
| C-19 | 遅延展開（enabledelayedexpansion）使用 | E-01 行2 | ○ |
| C-20 | 再現コマンドをechoで出力 | E-01 行99-104 | ○ |
| C-21 | XHarnessアーティファクトパスを最後に出力 | E-01 行114 | ○ |
| C-22 | Helixタイムアウト設定に依存 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Helixタイムアウト設定の具体値は本スクリプト内に記載なし
  - 候補：Helix設定ファイル / Azure DevOps Pipeline定義 / tests.wasm.targets

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - スクリプトの主要機能はすべてソースコードから確認可能
- 0: 低リスク - Windows固有のパス処理もソースコードに明記

## 6) レビュアーチェックリスト（最小）
- [ ] tests.wasm.targetsの実装とテンプレートプレースホルダーの対応を確認
- [ ] HELIX_CORRELATION_PAYLOADからのブラウザパス解決が正しいか確認
- [ ] Linux版（WasmRunnerTemplate.sh）との機能的な同等性を確認
