---
generated_at: 2026-01-30 10:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：23-WasiRunnerTemplate.sh.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **WASI-SDK使用**：スクリプト内に明示的な記載なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/testing/WasiRunnerTemplate.sh` (ソースコード)
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (バッチ一覧)
- E-03: コメント「SetCommands defined in eng\testing\tests.wasi.targets」(行3)
- E-04: コメント「RunCommands defined in eng\testing\tests.wasi.targets」(行86, 92)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | XHarnessテストフレームワークを使用 | E-01 行18-24 | ○ |
| C-02 | testコマンドがデフォルト | E-01 行26-28 | ○ |
| C-03 | tests.wasi.targetsでSetCommands定義 | E-03 | ○ |
| C-04 | tests.wasi.targetsでRunCommands定義 | E-04 | ○ |
| C-05 | SCENARIOパラメータ対応 | E-01 行8-10 | ○ |
| C-06 | ENGINE_ARGSからXHARNESS_ARGS設定 | E-01 行30-32 | ○ |
| C-07 | AOTビルド機能を提供（_buildAOTFunc） | E-01 行50-79 | ○ |
| C-08 | OOMエラーコード9200を返す | E-01 行66-67 | ○ |
| C-09 | AOTビルド失敗時にエラーコード9100を返す | E-01 行74-75 | ○ |
| C-10 | XHARNESS_CLI_PATHで直接DLL実行可能 | E-01 行18-24 | ○ |
| C-11 | HELIX_WORKITEM_UPLOAD_ROOTで出力先変更 | E-01 行12-16 | ○ |
| C-12 | PREPEND_PATHでPATH追加可能 | E-01 行34-36 | ○ |
| C-13 | XUNIT_RANDOM_ORDER_SEED対応 | E-01 行38-40 | ○ |
| C-14 | --env形式でXUNIT_RANDOM_ORDER_SEED設定 | E-01 行39 | ○ |
| C-15 | 再現コマンドをechoで出力 | E-01 行84-89 | ○ |
| C-16 | dmesgで最終20行を取得（OOM検出） | E-01 行63-64 | ○ |
| C-17 | binlogでパフォーマンスサマリー出力 | E-01 行59-60 | ○ |
| C-18 | XHarnessアーティファクトパスを最後に出力 | E-01 行97 | ○ |
| C-19 | ブラウザテスト機能は含まない | E-01（test-browserの記載なし） | ○ |
| C-20 | WASI-SDKを使用 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- WASI-SDKの使用についてはスクリプト内に直接の記載なし
  - 候補：tests.wasi.targets / ビルドシステム設定 / WASI関連ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - スクリプトの主要機能はすべてソースコードから確認可能
- 1: 中リスク - WASI-SDK依存関係は外部設定に依存

## 6) レビュアーチェックリスト（最小）
- [ ] tests.wasi.targetsの実装とテンプレートプレースホルダーの対応を確認
- [ ] WasmRunnerTemplate.shとの構造的な差異を確認
- [ ] ENGINE_ARGS設定がWASIランタイムに適切か確認
