---
generated_at: 2026-01-30 10:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：24-WasiRunnerTemplate.cmd.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **WASI-SDK使用**：スクリプト内に明示的な記載なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/testing/WasiRunnerTemplate.cmd` (ソースコード)
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (バッチ一覧)
- E-03: コメント「SetCommands defined in eng\testing\tests.wasi.targets」(行4)
- E-04: コメント「RunCommands defined in eng\testing\tests.wasi.targets」(行56, 63)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | XHarnessテストフレームワークを使用 | E-01 行21-27 | ○ |
| C-02 | testコマンドがデフォルト | E-01 行29-31 | ○ |
| C-03 | tests.wasi.targetsでSetCommands定義 | E-03 | ○ |
| C-04 | tests.wasi.targetsでRunCommands定義 | E-04 | ○ |
| C-05 | SCENARIOパラメータ対応 | E-01 行9-11 | ○ |
| C-06 | ENGINE_ARGSからXHARNESS_ARGS設定 | E-01 行33-35 | ○ |
| C-07 | XHARNESS_CLI_PATHで直接DLL実行可能 | E-01 行21-27 | ○ |
| C-08 | HELIX_WORKITEM_UPLOAD_ROOTで出力先変更 | E-01 行15-19 | ○ |
| C-09 | PREPEND_PATHでPATH追加可能 | E-01 行13, 37-39 | ○ |
| C-10 | XUNIT_RANDOM_ORDER_SEED対応 | E-01 行41-43 | ○ |
| C-11 | 遅延展開（enabledelayedexpansion）使用 | E-01 行2 | ○ |
| C-12 | 再現コマンドをechoで出力 | E-01 行54-59 | ○ |
| C-13 | XHarnessアーティファクトパスを最後に出力 | E-01 行69 | ○ |
| C-14 | _buildAOTFunc関数は含まれない | E-01（関数定義なし） | ○ |
| C-15 | Linux版と機能的に同等 | E-01, WasiRunnerTemplate.sh比較 | ○ |
| C-16 | --setenv形式でXUNIT_RANDOM_ORDER_SEED設定 | E-01 行42 | ○ |
| C-17 | ブラウザテスト機能は含まない | E-01（test-browserの記載なし） | ○ |
| C-18 | WASI-SDKを使用 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- WASI-SDKの使用についてはスクリプト内に直接の記載なし
  - 候補：tests.wasi.targets / ビルドシステム設定 / WASI関連ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - スクリプトの主要機能はすべてソースコードから確認可能
- 1: 中リスク - Linux版との差異（AOT関数なし）が意図的かどうか要確認

## 6) レビュアーチェックリスト（最小）
- [ ] tests.wasi.targetsの実装とテンプレートプレースホルダーの対応を確認
- [ ] Linux版（WasiRunnerTemplate.sh）との機能的な差異が意図的か確認
- [ ] _buildAOTFunc関数がWindows版に不要な理由を確認
