---
generated_at: 2026-01-30 10:20:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：25-BionicRunnerTemplate.sh.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **Android NDK使用**：スクリプト内に直接の記載なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/testing/BionicRunnerTemplate.sh` (ソースコード)
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (バッチ一覧)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | XHarnessテストフレームワークを使用 | E-01 行40-46 | ○ |
| C-02 | android-headlessコマンドを使用 | E-01 行48 | ○ |
| C-03 | TestEnv.txtから環境変数読み込み | E-01 行5 | ○ |
| C-04 | --runtime-pathオプションが必須 | E-01 行19-22 | ○ |
| C-05 | RUNTIME_PATHをrealpathで正規化 | E-01 行24 | ○ |
| C-06 | /tmp/androidtests.lockでセマフォ実装 | E-01 行29-38 | ○ |
| C-07 | ロック失敗時5秒間隔でリトライ | E-01 行36 | ○ |
| C-08 | trapでスクリプト終了時にロック解放 | E-01 行33 | ○ |
| C-09 | XHARNESS_CLI_PATHで直接DLL実行可能 | E-01 行40-46 | ○ |
| C-10 | HELIX_WORKITEM_UPLOAD_ROOTで出力先変更 | E-01 行9-13 | ○ |
| C-11 | タイムアウト1800秒（30分） | E-01 行55 | ○ |
| C-12 | TEST_SCRIPTはASSEMBLY_NAMEから自動生成 | E-01 行8 | ○ |
| C-13 | ADDITIONAL_ARGSで追加引数対応 | E-01 行15-17, 56 | ○ |
| C-14 | XHarnessアーティファクトパスを最後に出力 | E-01 行60 | ○ |
| C-15 | 実行ディレクトリへのcd | E-01 行26 | ○ |
| C-16 | 並列実行をサポートしない | E-01 行28（コメント） | ○ |
| C-17 | --test-pathで実行ディレクトリ指定 | E-01 行49 | ○ |
| C-18 | --runtime-folderでランタイムパス指定 | E-01 行50 | ○ |
| C-19 | --test-assemblyでテストアセンブリ指定 | E-01 行51 | ○ |
| C-20 | --device-archでアーキテクチャ指定 | E-01 行52 | ○ |
| C-21 | --output-directoryで出力先指定 | E-01 行54 | ○ |
| C-22 | Android NDKを使用 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Android NDKの使用についてはスクリプト内に直接の記載なし
  - 候補：ビルドシステム設定 / Android関連ドキュメント / バッチ一覧.csv（備考欄）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - スクリプトの主要機能はすべてソースコードから確認可能
- 1: 中リスク - セマフォによる排他制御の信頼性

## 6) レビュアーチェックリスト（最小）
- [ ] TestEnv.txtの形式と必要な変数を確認
- [ ] /tmp/androidtests.lockの排他制御が適切に動作するか確認
- [ ] タイムアウト設定（1800秒）が適切か確認
