---
generated_at: 2026-01-30 10:25:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：26-BionicRunnerTemplate.cmd.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **Android NDK使用**：スクリプト内に直接の記載なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/testing/BionicRunnerTemplate.cmd` (ソースコード)
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (バッチ一覧)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | XHarnessテストフレームワークを使用 | E-01 行36-42 | ○ |
| C-02 | android-headlessコマンドを使用 | E-01 行44 | ○ |
| C-03 | TestEnv.txtから環境変数読み込み | E-01 行4 | ○ |
| C-04 | FOR /Fコマンドで読み込み | E-01 行4 | ○ |
| C-05 | --runtime-pathオプションが必須 | E-01 行17-20 | ○ |
| C-06 | NORMALIZEPATH関数でパス正規化 | E-01 行24-25, 54-56 | ○ |
| C-07 | androidtests.lockでセマフォ実装 | E-01 行29-34 | ○ |
| C-08 | ロック失敗時ping -n 6で待機 | E-01 行32 | ○ |
| C-09 | RMDIR /Qでロック解放 | E-01 行50 | ○ |
| C-10 | XHARNESS_CLI_PATHで直接DLL実行可能 | E-01 行36-42 | ○ |
| C-11 | HELIX_WORKITEM_UPLOAD_ROOTで出力先変更 | E-01 行9-13 | ○ |
| C-12 | タイムアウト1800秒（30分） | E-01 行44 | ○ |
| C-13 | TEST_SCRIPTはASSEMBLY_NAMEから自動生成 | E-01 行15 | ○ |
| C-14 | ADDITIONAL_ARGSで追加引数対応 | E-01 行22, 44 | ○ |
| C-15 | XHarnessアーティファクトパスを最後に出力 | E-01 行48 | ○ |
| C-16 | 実行ディレクトリへのCD | E-01 行27 | ○ |
| C-17 | 遅延展開（enabledelayedexpansion）使用 | E-01 行2 | ○ |
| C-18 | 並列実行をサポートしない | E-01 行29-34（ロック実装） | ○ |
| C-19 | Linux版と機能的に同等 | E-01, BionicRunnerTemplate.sh比較 | ○ |
| C-20 | %~f1でフルパス取得 | E-01 行55 | ○ |
| C-21 | MKDIRでロック取得 | E-01 行30 | ○ |
| C-22 | Android NDKを使用 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Android NDKの使用についてはスクリプト内に直接の記載なし
  - 候補：ビルドシステム設定 / Android関連ドキュメント / バッチ一覧.csv（備考欄）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - スクリプトの主要機能はすべてソースコードから確認可能
- 1: 中リスク - セマフォによる排他制御の信頼性

## 6) レビュアーチェックリスト（最小）
- [ ] TestEnv.txtの形式と必要な変数を確認
- [ ] androidtests.lockの排他制御が適切に動作するか確認
- [ ] Linux版（BionicRunnerTemplate.sh）との機能的な同等性を確認
