---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：27-BionicRunOnDevice.sh.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **adb使用**：スクリプト内に直接のadbコマンドなし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/testing/BionicRunOnDevice.sh` (ソースコード)
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (バッチ一覧)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | -rオプションでランタイムパス指定 | E-01 行12-24 | ○ |
| C-02 | -lオプションでプリロードライブラリ指定 | E-01 行25-35 | ○ |
| C-03 | スクリプト名からテスト名導出 | E-01 行3 | ○ |
| C-04 | ランタイム実行ファイルの存在確認 | E-01 行17-19 | ○ |
| C-05 | LD_LIBRARY_PATH環境変数設定 | E-01 行34, 56 | ○ |
| C-06 | OpenSSLをランタイムフォルダから自動検出 | E-01 行38-56 | ○ |
| C-07 | アーキテクチャマッピング（x86_64） | E-01 行41-42 | ○ |
| C-08 | アーキテクチャマッピング（i*86 -> x86） | E-01 行43-44 | ○ |
| C-09 | アーキテクチャマッピング（armv* -> armeabi-v7a） | E-01 行45-46 | ○ |
| C-10 | アーキテクチャマッピング（aarch* -> arm64-v8a） | E-01 行47-48 | ○ |
| C-11 | SSL_CERT_DIR設定 | E-01 行58 | ○ |
| C-12 | /system/etc/security/cacertsへのSSL_CERT_DIR | E-01 行58 | ○ |
| C-13 | HOME環境変数を実行ディレクトリに設定 | E-01 行63 | ○ |
| C-14 | Androidの無効なHOME値回避 | E-01 行60-63（コメント） | ○ |
| C-15 | 実行ディレクトリへのcd | E-01 行64 | ○ |
| C-16 | deps.jsonの条件付き使用 | E-01 行66-68 | ○ |
| C-17 | XUnitテストランナー使用 | E-01 行69 | ○ |
| C-18 | testResults.xml出力 | E-01 行69 | ○ |
| C-19 | --nologo オプション | E-01 行69 | ○ |
| C-20 | --nocolor オプション | E-01 行69 | ○ |
| C-21 | IgnoreForCI除外トレイト | E-01 行69 | ○ |
| C-22 | OuterLoop除外トレイト | E-01 行69 | ○ |
| C-23 | failing除外トレイト | E-01 行69 | ○ |
| C-24 | adbを使用 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- adbの使用についてはスクリプト内に直接のコマンドなし
  - 候補：バッチ一覧.csv（備考欄「adb使用」と記載） / 上位スクリプト / Helix設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - スクリプトの主要機能はすべてソースコードから確認可能
- 1: 中リスク - adb接続はスクリプト外で管理される可能性

## 6) レビュアーチェックリスト（最小）
- [ ] OpenSSL自動検出のパスが正しいか確認
- [ ] アーキテクチャマッピングが現在のAndroid NDKと一致するか確認
- [ ] SSL_CERT_DIR設定がHelix環境で有効か確認
