---
generated_at: 2026-01-30 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-build-docker-sdk.sh.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/docker/build-docker-sdk.sh` (ソースコード)
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (バッチ一覧)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | set -uで未定義変数エラー | E-01 行5 | ○ |
| C-02 | set -eでコマンドエラー時停止 | E-01 行9 | ○ |
| C-03 | シンボリックリンクの再帰的解決 | E-01 行15-21 | ○ |
| C-04 | git rev-parseでリポジトリルート取得 | E-01 行26 | ○ |
| C-05 | Versions.propsからMajorVersion取得 | E-01 行27 | ○ |
| C-06 | Versions.propsからMinorVersion取得 | E-01 行28 | ○ |
| C-07 | バージョン形式は{Major}.{Minor} | E-01 行29 | ○ |
| C-08 | -imagename/-tオプションでイメージ名指定 | E-01 行34-36 | ○ |
| C-09 | デフォルトイメージ名はdotnet-sdk-libs-current | E-01 行24 | ○ |
| C-10 | -configuration/-cオプションで構成指定 | E-01 行37-40 | ○ |
| C-11 | デフォルト構成はRelease | E-01 行25 | ○ |
| C-12 | libraries-sdk.linux.Dockerfile使用 | E-01 行48 | ○ |
| C-13 | docker buildでイメージ生成 | E-01 行50-54 | ○ |
| C-14 | --build-arg CONFIGURATIONを渡す | E-01 行51 | ○ |
| C-15 | --build-arg VERSIONを渡す | E-01 行52 | ○ |
| C-16 | --tagでイメージ名指定 | E-01 行50 | ○ |
| C-17 | --fileでDockerfile指定 | E-01 行53 | ○ |
| C-18 | ビルドコンテキストはリポジトリルート | E-01 行54 | ○ |
| C-19 | grepの-oPオプション使用 | E-01 行27-28 | ○ |
| C-20 | exit $?で終了コード伝播 | E-01 行56 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - スクリプトは短く、すべての機能がソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] eng/docker/libraries-sdk.linux.Dockerfileが存在し、正しく構成されているか確認
- [ ] eng/Versions.propsのXML構造が期待通りか確認
- [ ] Dockerビルドに必要なビルド成果物が存在するか確認
