---
generated_at: 2026-01-30 10:40:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：29-build-docker-sdk.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/docker/build-docker-sdk.ps1` (ソースコード)
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (バッチ一覧)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | $ErrorActionPreference = "Stop"設定 | E-01 行12 | ○ |
| C-02 | CmdletBinding(PositionalBinding=$false)使用 | E-01 行5 | ○ |
| C-03 | -imageName/-tオプションでイメージ名指定 | E-01 行7 | ○ |
| C-04 | デフォルトイメージ名はdotnet-sdk-libs-current | E-01 行7 | ○ |
| C-05 | -configuration/-cオプションで構成指定 | E-01 行8 | ○ |
| C-06 | デフォルト構成はRelease | E-01 行8 | ○ |
| C-07 | -buildWindowsContainers/-wフラグ対応 | E-01 行9 | ○ |
| C-08 | git rev-parseでリポジトリルート取得 | E-01 行14 | ○ |
| C-09 | Versions.propsからXML解析でバージョン取得 | E-01 行15-16 | ○ |
| C-10 | バージョン形式は{Major}.{Minor} | E-01 行16 | ○ |
| C-11 | Windowsコンテナ時はホストでbuild.cmd実行 | E-01 行25 | ○ |
| C-12 | build.cmdでclr+libsをビルド | E-01 行25 | ○ |
| C-13 | ビルド失敗時はLASTEXITCODEで終了 | E-01 行27-30 | ○ |
| C-14 | libraries-sdk.windows.Dockerfile使用 | E-01 行32 | ○ |
| C-15 | artifacts/docker-contextにアーティファクト収集 | E-01 行41-57 | ○ |
| C-16 | microsoft.netcore.app.refを収集 | E-01 行48-49 | ○ |
| C-17 | microsoft.netcore.app.runtime.win-x64を収集 | E-01 行50-51 | ○ |
| C-18 | testhostを収集 | E-01 行52-53 | ○ |
| C-19 | targetingpacks.targetsを収集 | E-01 行54-55 | ○ |
| C-20 | msquic-interopを収集 | E-01 行56-57 | ○ |
| C-21 | Microsoft.AspNetCore.Appを除去 | E-01 行59-63 | ○ |
| C-22 | libraries-sdk.linux.Dockerfile使用（Linux時） | E-01 行74 | ○ |
| C-23 | docker buildで--build-arg CONFIGURATION | E-01 行65-66, 76-77 | ○ |
| C-24 | docker buildで--build-arg VERSION | E-01 行67, 78 | ○ |
| C-25 | exit $LASTEXITCODEで終了コード伝播 | E-01 行83 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - スクリプトの全機能がソースコードから確認可能
- 1: 中リスク - Windowsコンテナビルドは複雑なアーティファクト収集を行う

## 6) レビュアーチェックリスト（最小）
- [ ] Windowsコンテナ用Dockerfileが正しく構成されているか確認
- [ ] アーティファクト収集パスが現在のビルド出力構造と一致するか確認
- [ ] Microsoft.AspNetCore.App除去ロジックが適切か確認
