---
generated_at: 2026-01-30 10:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：3-eng/build.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間の数値**：具体的なビルド時間の根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomoka.baba/Work/runtime-main/eng/build.sh` (ソースコード、624行)
- E-02: `/Users/tomoka.baba/Work/runtime-main/docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (バッチ一覧)
- E-03: `/Users/tomoka.baba/Work/runtime-main/eng/common/build.sh` (委譲先スクリプト)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | set -ue でエラー時停止を設定 | E-01 (行3) | ○ |
| C-02 | x86, x64, arm, arm64, wasm等のアーキテクチャをサポート | E-01 (行218, usage関数) | ○ |
| C-03 | Debug, Release, Checked構成をサポート | E-01 (行237, usage関数) | ○ |
| C-04 | linux, osx, windows等のターゲットOSをサポート | E-01 (行267-313, usage関数) | ○ |
| C-05 | サブセット指定による選択的ビルドが可能 | E-01 (行196-209, usage関数) | ○ |
| C-06 | --cross オプションでクロスコンパイルを有効化 | E-01 (行430-434) | ○ |
| C-07 | init-os-and-arch.sh を読み込む | E-01 (行165) | ○ |
| C-08 | init-distro-rid.sh を使用してRIDを初期化 | E-01 (行136-150) | ○ |
| C-09 | --bootstrap オプションでブートストラップビルドを実行 | E-01 (行527-530, 597-621) | ○ |
| C-10 | ブートストラップ後にartifacts/binを削除 | E-01 (行617) | ○ |
| C-11 | eng/common/build.sh を呼び出す | E-01 (行623) | ○ |
| C-12 | --clang, --gccオプションでコンパイラを指定可能 | E-01 (行442-461) | ○ |
| C-13 | --ninja オプションでNinjaを使用可能 | E-01 (行498-515) | ○ |
| C-14 | アクション未指定時は -restore -build がデフォルト | E-01 (行559-561) | ○ |
| C-15 | Browser向けビルドでarchをwasmに自動設定 | E-01 (行563-570) | ○ |
| C-16 | CMake引数のスペースを%20にエンコード | E-01 (行593) | ○ |
| C-17 | terminal logger を無効化（-tl:false） | E-01 (行581) | ○ |
| C-18 | TreatWarningsAsErrors環境変数を参照 | E-01 (行576-578) | ○ |
| C-19 | DOTNETSDK_ALLOW_TARGETING_PACK_CACHING=0を設定 | E-01 (行589) | ○ |
| C-20 | フルビルドで数十分〜数時間かかる | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20（ビルド時間）：具体的なビルド時間はソースコードから判断できない。CI/CDログやパフォーマンス計測データが必要
  - 候補：CI/CDパイプラインログ / パフォーマンステスト結果 / 開発者ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 入力バリデーションが実装されている
- 1: 中リスク - ブートストラップビルドでのartifacts削除は意図しないデータ損失の可能性

## 6) レビュアーチェックリスト（最小）
- [ ] サポートされているOS/アーキテクチャの組み合わせ網羅性確認
- [ ] ブートストラップビルド時のartifacts削除の影響範囲確認
- [ ] クロスコンパイル時のROOTFS_DIR要件の明確化
- [ ] 各コンパイラバージョン（clang, gcc）のサポート範囲確認
