---
generated_at: 2026-01-30 10:45:00
metrics:
  claims_total: 35
  claims_with_evidence: 34
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：30-build-commons.sh.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：34 / 35、根拠なし：1
- 優先レビュー（高）
  1. **scan-build静的解析サポート**：部分的な根拠のみ

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `eng/native/build-commons.sh` (ソースコード)
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (バッチ一覧)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | initTargetDistroRid関数を提供 | E-01 行3-15 | ○ |
| C-02 | setup_dirs関数を提供 | E-01 行17-24 | ○ |
| C-03 | check_prereqs関数を提供 | E-01 行27-47 | ○ |
| C-04 | build_native関数を提供 | E-01 行49-253 | ○ |
| C-05 | usage関数を提供 | E-01 行255-290 | ○ |
| C-06 | init-os-and-arch.shをsource | E-01 行292 | ○ |
| C-07 | macOSでpkg-config確認 | E-01 行32-33 | ○ |
| C-08 | macOSでOpenSSL確認 | E-01 行35-41 | ○ |
| C-09 | HomebrewのOpenSSLパス自動検出 | E-01 行38 | ○ |
| C-10 | Ninja確認（-ninja時） | E-01 行44-46 | ○ |
| C-11 | Android NDK確認 | E-01 行102-105 | ○ |
| C-12 | CMakeアーキテクチャ設定（OSX） | E-01 行80-89 | ○ |
| C-13 | Android toolchain使用 | E-01 行107-108 | ○ |
| C-14 | iOS/tvOS対応 | E-01 行125-177 | ○ |
| C-15 | maccatalyst対応 | E-01 行91-97 | ○ |
| C-16 | クロスコンパイル時ROOTFS_DIR設定 | E-01 行565-573 | ○ |
| C-17 | gen-buildsys.sh呼び出し | E-01 行192-194 | ○ |
| C-18 | CMakeCache.txt確認 | E-01 行203-207 | ○ |
| C-19 | __ConfigureOnlyオプション対応 | E-01 行210-213 | ○ |
| C-20 | __NumProc自動検出 | E-01 行299-312 | ○ |
| C-21 | -debug/-checked/-releaseオプション | E-01 行358-360, 391-393, 432-434 | ○ |
| C-22 | -clang/-gccオプション | E-01 行367-369, 395-397 | ○ |
| C-23 | -ninjaオプション | E-01 行414-416 | ○ |
| C-24 | -crossオプション | E-01 行387-389 | ○ |
| C-25 | -cmakeargsオプション | E-01 行371-379 | ○ |
| C-26 | -numprocオプション | E-01 行418-426 | ○ |
| C-27 | -targetridオプション | E-01 行468-476 | ○ |
| C-28 | -fsanitizeオプション | E-01 行403-412 | ○ |
| C-29 | -verboseオプション | E-01 行440-442 | ○ |
| C-30 | EXTRA_CFLAGS/CXXFLAGS/LDFLAGS対応 | E-01 行76-78 | ○ |
| C-31 | CIモードで##vso形式エラー | E-01 行362-365 | ○ |
| C-32 | __PortableBuild対応 | E-01 行541-543, 561-562 | ○ |
| C-33 | __TargetRid設定 | E-01 行577-584 | ○ |
| C-34 | WebAssembly (wasm) 対応 | E-01 行227-231, 464-466, 545-547 | ○ |
| C-35 | scan-build静的解析サポート | E-01 行188-189, 216-224（部分的） | △ |

## 4) 不足情報（Unknown / Missing）
- scan-build静的解析の完全なサポート情報
  - 候補：外部ドキュメント / CI設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能はソースコードから確認可能
- 1: 中リスク - クロスコンパイル設定は環境依存が大きい
- 1: 中リスク - Android/iOS等のプラットフォーム固有設定

## 6) レビュアーチェックリスト（最小）
- [ ] サポートされる全アーキテクチャが正しくマッピングされているか確認
- [ ] クロスコンパイル用ROOTFS_DIRのパスが適切か確認
- [ ] Android NDKツールチェーン設定が最新のNDKと互換性があるか確認
- [ ] iOS/tvOSのデプロイメントターゲットバージョンが適切か確認
