---
generated_at: 2026-01-30 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：31-gen-buildsys.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `eng/native/gen-buildsys.sh` - メインソースコード（141行）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ定義情報（行31）
- E-03: スクリプト内Usage出力（行10-20）
- E-04: スクリプト内コンパイラ初期化処理（行27-35）
- E-05: スクリプト内ビルドオプション解析（行44-61）
- E-06: スクリプト内クロスコンパイル設定（行64-82）
- E-07: スクリプト内WASM設定（行97-127）
- E-08: スクリプト内CMake実行（行129-138）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | スクリプトはCMakeを使用してビルドシステムを生成する | E-01, E-08 | ○ |
| C-02 | 引数が4個未満の場合はUsageを表示して終了 | E-01, E-03 (行9-21) | ○ |
| C-03 | compilerがdefaultでない場合init-compiler.shを読み込む | E-01, E-04 (行27-33) | ○ |
| C-04 | CC、CXX、CCC_CC、CCC_CXX環境変数を設定 | E-01, E-04 (行31-35) | ○ |
| C-05 | ビルドタイプはDEBUG/CHECKED/RELEASE/RELWITHDEBINFOをサポート | E-01, E-05 (行46-50) | ○ |
| C-06 | デフォルトのビルドタイプはDEBUG | E-01 (行37) | ○ |
| C-07 | Ninjaジェネレータをサポート | E-01, E-05 (行51-52) | ○ |
| C-08 | デフォルトはUnix Makefilesジェネレータ | E-01 (行41) | ○ |
| C-09 | scan-buildオプションで静的解析を有効化 | E-01, E-05 (行54-57) | ○ |
| C-10 | クロスコンパイル時はCROSSCOMPILE=1を判定 | E-01, E-06 (行64) | ○ |
| C-11 | Darwin以外のクロスコンパイルでROOTFS_DIR必須 | E-01, E-06 (行67-70) | ○ |
| C-12 | クロスコンパイル時はtryrun.cmakeを使用 | E-01, E-06 (行75) | ○ |
| C-13 | クロスコンパイル時はtoolchain.cmakeを使用 | E-01, E-06 (行80) | ○ |
| C-14 | armelアーキテクチャでARM_SOFTFP=1を設定 | E-01 (行84-86) | ○ |
| C-15 | CMakeが見つからない場合はエラー終了 | E-01 (行88-91) | ○ |
| C-16 | WASM/browser向けでEMSDK_PATHを使用 | E-01, E-07 (行99-108) | ○ |
| C-17 | WASM/browser向けでemcmakeラッパーを使用 | E-01, E-07 (行109) | ○ |
| C-18 | WASM/browser向けでtryrun.browser.cmakeを使用 | E-01, E-07 (行112) | ○ |
| C-19 | WASM/wasi向けでWASI_SDK_PATHを使用 | E-01, E-07 (行114-121) | ○ |
| C-20 | WASM/wasi向けでwasi-sdk-p2.cmakeツールチェーンを使用 | E-01, E-07 (行122) | ○ |
| C-21 | 入力パラメータ$1はCMakeLists.txtパス | E-01, E-03, E-08 (行137) | ○ |
| C-22 | 入力パラメータ$2は中間ディレクトリパス | E-01, E-03, E-08 (行138) | ○ |
| C-23 | 入力パラメータ$3はホストアーキテクチャ | E-01, E-03 (行23) | ○ |
| C-24 | 入力パラメータ$4はターゲットOS | E-01, E-03 (行24) | ○ |
| C-25 | CMakeの終了コードがスクリプトの終了コードになる | E-01 (行140 コメント) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張にソースコードからの根拠あり）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] CMake実行部分のオプション指定が実際の運用と一致しているか確認
- [ ] クロスコンパイル設定が各ターゲットプラットフォームで正しく動作するか確認
- [ ] WASM/WASI環境でのSDKパス解決ロジックが正しいか確認
