---
generated_at: 2026-01-30 10:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：32-gen-buildsys.cmd バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `eng/native/gen-buildsys.cmd` - メインソースコード（148行）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ定義情報（行32）
- E-03: スクリプト内Usage出力（行142-147）
- E-04: スクリプト内Emscripten SDK設定（行17-27）
- E-05: スクリプト内CMakeジェネレータ選択（行35-51）
- E-06: スクリプト内WASM設定（行53-75）
- E-07: スクリプト内Android設定（行77-102）
- E-08: スクリプト内コマンドラインキャッシュ（行113-130）
- E-09: スクリプト内CMake実行（行132-137）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | スクリプトはCMakeを使用してビルドシステムを生成する | E-01, E-09 | ○ |
| C-02 | 引数が4個未満の場合はUsageを表示して終了 | E-01 (行8-9), E-03 | ○ |
| C-03 | 引数が/?の場合はUsageを表示 | E-01 (行9) | ○ |
| C-04 | __OsがbrowserでEMSDK_PATH未設定の場合はデフォルトパスを使用 | E-01, E-04 (行18-23) | ○ |
| C-05 | emsdk_envを呼び出して環境設定 | E-01, E-04 (行23, 25) | ○ |
| C-06 | __Ninja=1の場合はNinjaジェネレータを使用 | E-01, E-05 (行37-38) | ○ |
| C-07 | wasmかつ非Ninjaの場合はNMake Makefilesジェネレータ | E-01, E-05 (行49) | ○ |
| C-08 | VS 17.0でVisual Studio 17 2022を使用 | E-01, E-05 (行42) | ○ |
| C-09 | VS 18.0でVisual Studio 18 2026を使用 | E-01, E-05 (行41) | ○ |
| C-10 | x64アーキテクチャで-A x64オプション | E-01, E-05 (行44) | ○ |
| C-11 | armアーキテクチャで-A ARMオプション | E-01, E-05 (行45) | ○ |
| C-12 | arm64アーキテクチャで-A ARM64オプション | E-01, E-05 (行46) | ○ |
| C-13 | x86アーキテクチャで-A Win32オプション | E-01, E-05 (行47) | ○ |
| C-14 | wasmかつOS未指定でエラー終了 | E-01, E-06 (行53-57) | ○ |
| C-15 | wasmかつbrowserでemcmakeプレフィックス設定 | E-01, E-06 (行58-59) | ○ |
| C-16 | wasmかつwasiでWASI_SDK_PATHを使用 | E-01, E-06 (行61-69) | ○ |
| C-17 | wasmかつwasiでNinjaジェネレータ強制 | E-01, E-06 (行70) | ○ |
| C-18 | wasmかつwasiでwasi-sdk-p2.cmakeツールチェーン使用 | E-01, E-06 (行71) | ○ |
| C-19 | 非wasmでCMAKE_SYSTEM_VERSION=10.0設定 | E-01, E-06 (行74) | ○ |
| C-20 | androidでANDROID_NDK_ROOT必須 | E-01, E-07 (行80-83) | ○ |
| C-21 | androidでAPIレベル21を使用 | E-01, E-07 (行79, 86) | ○ |
| C-22 | androidでアーキテクチャに応じたABI設定 | E-01, E-07 (行88-99) | ○ |
| C-23 | androidでtryrun.cmakeを使用 | E-01, E-07 (行101) | ○ |
| C-24 | %6以降の引数を__ExtraCmakeParamsに追加 | E-01 (行104-108) | ○ |
| C-25 | 非Visual StudioジェネレータでキャッシュによるCMakeスキップ | E-01, E-08 (行117-130) | ○ |
| C-26 | cmake_cmd_line.txtにコマンドラインを保存 | E-01, E-08 (行113, 136) | ○ |
| C-27 | __ConfigureOnly=1でキャッシュチェックをスキップ | E-01, E-08 (行115) | ○ |
| C-28 | CMake成功時にコマンドラインをキャッシュ保存 | E-01 (行135-136) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張にソースコードからの根拠あり）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] Visual Studio 18 2026の設定が実際のVSバージョンと一致しているか確認
- [ ] Android APIレベル21がDirectory.Build.propsのAndroidApiLevelMinと同期しているか確認
- [ ] WASI SDKのツールチェーンファイル名（wasi-sdk-p2.cmake）が最新SDKと一致しているか確認
- [ ] コマンドラインキャッシュのスペース末尾トリム処理が正しく動作するか確認
