---
generated_at: 2026-01-30 10:45:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：34-generateversionscript.ps1 バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `eng/native/generateversionscript.ps1` - メインソースコード（34行）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ定義情報（行34）
- E-03: スクリプト内パラメータ定義（行1-4）
- E-04: スクリプト内ヘッダ出力（行7-8）
- E-05: スクリプト内行処理（行11-29）
- E-06: スクリプト内フッタ出力（行32-33）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | param()で$inputFile、$prefixを受け取り | E-01, E-03 (行1-4) | ○ |
| C-02 | "V1.0 {"形式のヘッダを出力 | E-01, E-04 (行7) | ○ |
| C-03 | "global:"を出力 | E-01, E-04 (行8) | ○ |
| C-04 | Get-Contentで入力ファイルを読み込み | E-01, E-05 (行11) | ○ |
| C-05 | Trim()で行の前後の空白を除去 | E-01, E-05 (行12) | ○ |
| C-06 | 空行をスキップ | E-01, E-05 (行15-16) | ○ |
| C-07 | セミコロンで始まるコメント行をスキップ | E-01, E-05 (行15-16) | ○ |
| C-08 | -replaceでCR文字を除去 | E-01, E-05 (行21) | ○ |
| C-09 | #で始まるエントリを判定 | E-01, E-05 (行24) | ○ |
| C-10 | #を除去してプレフィックスと結合 | E-01, E-05 (行25-26) | ○ |
| C-11 | 各シンボルの末尾にセミコロンを付加 | E-01, E-05 (行26, 28) | ○ |
| C-12 | "local: *;"形式のフッタを出力 | E-01, E-06 (行32) | ○ |
| C-13 | "};"で閉じる | E-01, E-06 (行33) | ○ |
| C-14 | ForEach-Object内でreturnによりスキップ | E-01, E-05 (行16) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張にソースコードからの根拠あり）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードから直接確認可能
- スクリプトはBash版と同等のシンプルな実装

## 6) レビュアーチェックリスト（最小）

- [ ] バージョンスクリプト形式がGNU ldの仕様と一致しているか確認
- [ ] Bash版（generateversionscript.sh）と出力が一致するか確認
- [ ] PowerShellのパイプライン処理が正しく動作するか確認
