---
generated_at: 2026-01-30 10:50:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：35-generateexportedsymbols.sh バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `eng/native/generateexportedsymbols.sh` - メインソースコード（26行）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ定義情報（行35）
- E-03: スクリプト内Usage出力（行7-8）
- E-04: スクリプト内行処理ループ（行14-25）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | --help/-hオプションでUsage表示 | E-01, E-03 (行6-8) | ○ |
| C-02 | $1は入力ファイルパス | E-01, E-03 (行7), E-04 (行25) | ○ |
| C-03 | 空行をスキップ | E-01, E-04 (行15-17) | ○ |
| C-04 | セミコロンで始まるコメント行をスキップ | E-01, E-04 (行15-17) | ○ |
| C-05 | CR文字を除去（Windows改行対応） | E-01, E-04 (行22) | ○ |
| C-06 | #記号を除去 | E-01, E-04 (行24 "${line//#/}") | ○ |
| C-07 | アンダースコアプレフィックスを付加 | E-01, E-04 (行24 "_%s") | ○ |
| C-08 | 正規表現で空行・コメント行をマッチ | E-01, E-04 (行15-16) | ○ |
| C-09 | 入力ファイルをread -rで処理 | E-01, E-04 (行14) | ○ |
| C-10 | 標準出力にシンボルリストを出力 | E-01, E-04 (行24 printf使用) | ○ |
| C-11 | 各シンボルは改行区切り | E-01, E-04 (行24 "\n") | ○ |
| C-12 | プレフィックスパラメータは不要 | E-01 (パラメータは$1のみ) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全ての主張にソースコードからの根拠あり）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードから直接確認可能
- スクリプトは非常にシンプルで、処理フローが明確

## 6) レビュアーチェックリスト（最小）

- [ ] アンダースコアプレフィックスがmacOS ABIの要件と一致しているか確認
- [ ] #記号の除去処理が実際のシンボル定義ファイルと整合しているか確認
- [ ] Native AOTビルドで正しく使用されているか確認
